/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.CatoblepasEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CatoblepasModel
extends HierarchicalModel<CatoblepasEntity> {
    public CatoblepasEntity entity;
    public ModelPart root;
    public ModelPart head;
    public ModelPart skull;
    public ModelPart hornRightBaby;
    public ModelPart hornLeftBaby;
    public ModelPart hornRightKid;
    public ModelPart hornLeftKid;
    public ModelPart hornRightTeen;
    public ModelPart hornLeftTeen;
    public ModelPart hornRightAdult;
    public ModelPart hornLeftAdult;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightFrontLower;
    public ModelPart legLeftFront;
    public ModelPart legLeftFrontLower;
    public ModelPart legRightRear;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRear;
    public ModelPart legLeftRearLower;

    public CatoblepasModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.skull = this.head.getChild("skull");
        this.hornRightBaby = this.skull.getChild("hornRightBaby");
        this.hornLeftBaby = this.skull.getChild("hornLeftBaby");
        this.hornRightKid = this.skull.getChild("hornRightKid");
        this.hornLeftKid = this.skull.getChild("hornLeftKid");
        this.hornRightTeen = this.skull.getChild("hornRightTeen");
        this.hornLeftTeen = this.skull.getChild("hornLeftTeen");
        this.hornRightAdult = this.skull.getChild("hornRightAdult");
        this.hornLeftAdult = this.skull.getChild("hornLeftAdult");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightFrontLower = this.legRightFront.getChild("legRightFrontLower");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftFrontLower = this.legLeftFront.getChild("legLeftFrontLower");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legRightRearLower = this.legRightRear.getChild("legRightRearLower");
        this.legLeftRear = this.root.getChild("legLeftRear");
        this.legLeftRearLower = this.legLeftRear.getChild("legLeftRearLower");
    }

    public void prepareMobModel(CatoblepasEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.entity = pEntity;
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, int pColor) {
        if (this.entity.getSize() < 2) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = true;
            this.hornLeftBaby.visible = true;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 3) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = true;
            this.hornLeftKid.visible = true;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 4) {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = true;
            this.hornLeftTeen.visible = true;
            this.hornRightAdult.visible = false;
            this.hornLeftAdult.visible = false;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else {
            pPoseStack.pushPose();
            this.hornRightBaby.visible = false;
            this.hornLeftBaby.visible = false;
            this.hornRightKid.visible = false;
            this.hornLeftKid.visible = false;
            this.hornRightTeen.visible = false;
            this.hornLeftTeen.visible = false;
            this.hornRightAdult.visible = true;
            this.hornLeftAdult.visible = true;
            this.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        }
    }

    public void setupAnim(CatoblepasEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.CATOBLEPAS_ATTACK, pAgeInTicks);
        this.animate(pEntity.eatingAnimationState, IcariaAnimations.CATOBLEPAS_EATING, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.skull.xRot = IcariaMath.rad(pHeadPitch) + 0.3927f;
        this.skull.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)(pLimbSwing *= Mth.lerp((float)this.entity.getSize(), (float)0.5f, (float)1.0f))) * pLimbSwingAmount * 0.5f;
        this.legRightFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * pLimbSwingAmount + 0.0911f;
        this.legRightFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount + pLimbSwingAmount - 0.182f;
        this.legLeftFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * pLimbSwingAmount + 0.0911f;
        this.legLeftFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount - 0.182f;
        this.legRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * pLimbSwingAmount - 0.0911f;
        this.legRightRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount + 0.182f;
        this.legLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * pLimbSwingAmount - 0.0911f;
        this.legLeftRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount + 0.182f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(46, 27).addBox(-3.5f, -4.1f, -4.65f, 7.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.416f, (float)-6.2573f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition skull = head.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(12, 31).addBox(-3.0f, -3.5f, -6.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.25f, (float)-3.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(79, 37).addBox(-2.5f, -1.15f, -3.05f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(112, 0).addBox(-1.5f, -5.5f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.3f, (float)-2.0f, (float)0.6374f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(101, 35).addBox(-2.0f, -3.5f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-5.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(31, 8).addBox(-1.5f, -0.9048f, -4.0351f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.1306f, (float)-4.289f, (float)0.3927f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(119, 6).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.7f, (float)0.5f, (float)-2.0f, (float)0.182f, (float)0.0f, (float)-0.3927f));
        skull.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(80, 0).addBox(-1.5f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.7f, (float)0.5f, (float)-2.0f, (float)0.182f, (float)0.0f, (float)0.3927f));
        PartDefinition hornRightBaby = skull.addOrReplaceChild("hornRightBaby", CubeListBuilder.create().texOffs(0, 7).addBox(6.3f, -0.5f, 1.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8f, (float)-6.0f, (float)-3.225f, (float)0.0f, (float)0.2731f, (float)2.6721f));
        hornRightBaby.addOrReplaceChild("hornRightBabyOuter", CubeListBuilder.create().texOffs(49, 2).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.3f, (float)0.0f, (float)3.1f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        PartDefinition hornLeftBaby = skull.addOrReplaceChild("hornLeftBaby", CubeListBuilder.create().texOffs(0, 10).addBox(6.3f, -0.5f, 1.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.85f, (float)-5.925f, (float)-3.25f, (float)0.0f, (float)0.2731f, (float)0.4554f));
        hornLeftBaby.addOrReplaceChild("hornLeftBabyOuter", CubeListBuilder.create().texOffs(44, 12).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.3f, (float)0.0f, (float)3.1f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        PartDefinition hornRightKid = skull.addOrReplaceChild("hornRightKid", CubeListBuilder.create().texOffs(0, 7).addBox(6.3f, -0.5f, 1.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8f, (float)-6.0f, (float)-3.225f, (float)0.0f, (float)0.2731f, (float)2.6721f));
        hornRightKid.addOrReplaceChild("hornRightKidOuter", CubeListBuilder.create().texOffs(49, 2).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.3f, (float)0.0f, (float)3.1f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        PartDefinition hornLeftKid = skull.addOrReplaceChild("hornLeftKid", CubeListBuilder.create().texOffs(0, 10).addBox(6.3f, -0.5f, 1.5f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.85f, (float)-5.925f, (float)-3.25f, (float)0.0f, (float)0.2731f, (float)0.4554f));
        hornLeftKid.addOrReplaceChild("hornLeftKidOuter", CubeListBuilder.create().texOffs(44, 12).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.3f, (float)0.0f, (float)3.1f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        PartDefinition hornRightTeen = skull.addOrReplaceChild("hornRightTeen", CubeListBuilder.create().texOffs(41, 8).addBox(2.8f, -0.5f, 0.4f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.625f, (float)-4.425f, (float)-3.6f, (float)0.0f, (float)0.2731f, (float)2.6721f));
        PartDefinition hornRightTeenCenter = hornRightTeen.addOrReplaceChild("hornRightTeenCenter", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.3f, (float)0.0f, (float)2.5f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        hornRightTeenCenter.addOrReplaceChild("hornRightTeenOuter", CubeListBuilder.create().texOffs(49, 2).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        PartDefinition hornLeftTeen = skull.addOrReplaceChild("hornLeftTeen", CubeListBuilder.create().texOffs(113, 17).addBox(2.8f, -0.5f, 0.4f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.675f, (float)-4.375f, (float)-3.625f, (float)0.0f, (float)0.2731f, (float)0.4554f));
        PartDefinition hornLeftTeenCenter = hornLeftTeen.addOrReplaceChild("hornLeftTeenCenter", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.3f, (float)0.0f, (float)2.5f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        hornLeftTeenCenter.addOrReplaceChild("hornLeftTeenOuter", CubeListBuilder.create().texOffs(44, 12).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        PartDefinition hornRightAdult = skull.addOrReplaceChild("hornRightAdult", CubeListBuilder.create().texOffs(97, 30).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.1f, (float)-3.5f, (float)0.0f, (float)0.2731f, (float)2.6721f));
        PartDefinition hornRightAdultInner = hornRightAdult.addOrReplaceChild("hornRightAdultInner", CubeListBuilder.create().texOffs(41, 8).addBox(0.0f, -0.5f, -1.5f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)0.0f, (float)1.9f, (float)0.0f, (float)0.7285f, (float)-0.1367f));
        PartDefinition hornRightAdultCenter = hornRightAdultInner.addOrReplaceChild("hornRightAdultCenter", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        hornRightAdultCenter.addOrReplaceChild("hornRightAdultOuter", CubeListBuilder.create().texOffs(49, 2).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)-0.1367f));
        PartDefinition hornLeftAdult = skull.addOrReplaceChild("hornLeftAdult", CubeListBuilder.create().texOffs(30, 31).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-3.1f, (float)-3.5f, (float)0.0f, (float)0.2731f, (float)0.4554f));
        PartDefinition hornLeftAdultInner = hornLeftAdult.addOrReplaceChild("hornLeftAdultInner", CubeListBuilder.create().texOffs(113, 17).addBox(0.0f, -0.5f, -1.5f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)0.0f, (float)1.9f, (float)0.0f, (float)0.7285f, (float)0.1367f));
        PartDefinition hornLeftAdultCenter = hornLeftAdultInner.addOrReplaceChild("hornLeftAdultCenter", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        hornLeftAdultCenter.addOrReplaceChild("hornLeftAdultOuter", CubeListBuilder.create().texOffs(44, 12).addBox(0.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.6f, (float)0.0f, (float)0.5463f, (float)0.1367f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -4.95f, -7.325f, 9.0f, 8.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)11.9018f, (float)4.1216f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("back", CubeListBuilder.create().texOffs(18, 21).addBox(-4.0f, -1.1094f, -4.3712f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.3108f, (float)-7.1788f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(85, 28).addBox(-1.0f, -0.075f, 0.75f, 2.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.6358f, (float)-8.0288f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("front", CubeListBuilder.create().texOffs(85, 0).addBox(-5.0f, -18.625f, -9.125f, 10.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.5392f, (float)-3.5538f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("rear", CubeListBuilder.create().texOffs(55, 0).addBox(-5.0f, -18.325f, 6.325f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)13.3392f, (float)-4.0596f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -0.025f, -0.9f, 3.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.9917f, (float)6.1731f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition udder = body.addOrReplaceChild("udder", CubeListBuilder.create().texOffs(31, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.6683f, (float)-0.5686f));
        udder.addOrReplaceChild("teatRightFront", CubeListBuilder.create().texOffs(8, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.5f, (float)-1.5f));
        udder.addOrReplaceChild("teatLeftFront", CubeListBuilder.create().texOffs(31, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)1.5f, (float)-1.5f));
        udder.addOrReplaceChild("teatRightRear", CubeListBuilder.create().texOffs(53, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.5f, (float)0.5f));
        udder.addOrReplaceChild("teatLeftRear", CubeListBuilder.create().texOffs(49, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)1.5f, (float)0.5f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(0, 21).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)8.666f, (float)-6.7073f, (float)0.0911f, (float)0.0f, (float)0.0f));
        legRightFront.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(115, 27).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)6.7f, (float)1.2f, (float)-0.182f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(100, 17).addBox(0.0f, 0.0f, -2.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)8.666f, (float)-6.7073f, (float)0.0911f, (float)0.0f, (float)0.0f));
        legLeftFront.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(73, 26).addBox(0.0f, 0.0f, -2.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)6.7f, (float)1.2f, (float)-0.182f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(60, 15).addBox(-4.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)9.541f, (float)7.9619f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        legRightRear.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(88, 17).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)6.7f, (float)0.2f, (float)0.182f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(44, 15).addBox(0.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)9.541f, (float)7.9619f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        legLeftRear.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(76, 15).addBox(0.0f, 0.0f, -2.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)6.7f, (float)0.2f, (float)0.182f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

