/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.CerverEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CerverModel
extends HierarchicalModel<CerverEntity> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart skull;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legRightFrontLower;
    public ModelPart pawRightFront;
    public ModelPart legLeftFront;
    public ModelPart legLeftFrontLower;
    public ModelPart pawLeftFront;
    public ModelPart legRightRear;
    public ModelPart legRightRearLower;
    public ModelPart pawRightRear;
    public ModelPart legLeftRear;
    public ModelPart legLeftRearLower;
    public ModelPart pawLeftRear;

    public CerverModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.skull = this.head.getChild("skull");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legRightFrontLower = this.legRightFront.getChild("legRightFrontLower");
        this.pawRightFront = this.legRightFrontLower.getChild("pawRightFront");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legLeftFrontLower = this.legLeftFront.getChild("legLeftFrontLower");
        this.pawLeftFront = this.legLeftFrontLower.getChild("pawLeftFront");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legRightRearLower = this.legRightRear.getChild("legRightRearLower");
        this.pawRightRear = this.legRightRearLower.getChild("pawRightRear");
        this.legLeftRear = this.root.getChild("legLeftRear");
        this.legLeftRearLower = this.legLeftRear.getChild("legLeftRearLower");
        this.pawLeftRear = this.legLeftRearLower.getChild("pawLeftRear");
    }

    public void setupAnim(CerverEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.CERVER_ATTACK, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.skull.xRot = IcariaMath.rad(pHeadPitch) + 0.2138f;
        this.skull.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount * 0.5f;
        this.legRightFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * 0.6f * pLimbSwingAmount + 0.182f;
        this.legRightFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount - pLimbSwingAmount - 0.3187f;
        this.pawRightFront.xRot = -Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount + pLimbSwingAmount + 0.1367f;
        this.legLeftFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * 0.6f * pLimbSwingAmount + 0.182f;
        this.legLeftFrontLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.3187f;
        this.pawLeftFront.xRot = -Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.1367f;
        this.legRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * 1.2f * pLimbSwingAmount - 0.4383f;
        this.legRightRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount + 0.5918f;
        this.pawRightRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount - 0.1367f;
        this.legLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * 1.2f * pLimbSwingAmount - 0.4383f;
        this.legLeftRearLower.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount + 0.5918f;
        this.pawLeftRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount - 0.1367f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(72, 0).addBox(-2.0f, -3.0f, -5.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.2181f, (float)-3.9255f));
        PartDefinition skull = head.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(66, 21).addBox(-3.0f, -2.0f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-3.5f, (float)0.2138f, (float)0.0f, (float)0.0f));
        PartDefinition snout = skull.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(12, 20).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-6.0f));
        snout.addOrReplaceChild("teeth", CubeListBuilder.create().texOffs(12, 44).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.3f));
        snout.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(24, 18).addBox(-1.5f, -0.5166f, -3.611f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.3875f, (float)0.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        skull.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.75f, (float)-1.75f, (float)-2.5f, (float)0.0f, (float)-0.5236f, (float)0.7854f));
        skull.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -1.5f, -0.5f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.75f, (float)-2.5f, (float)0.5236f, (float)0.0f, (float)0.7854f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -1.0f, -8.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.5f, (float)2.0f, (float)-0.1367f, (float)0.0f, (float)0.0f));
        PartDefinition front = body.addOrReplaceChild("front", CubeListBuilder.create().texOffs(30, 13).addBox(-4.0f, 0.0f, -8.0f, 8.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.1534f, (float)7.6926f, (float)0.0853f, (float)0.0f, (float)0.0f));
        PartDefinition rear = front.addOrReplaceChild("rear", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(-4.5f, 0.2f, -2.1f, 9.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)1.3f, (float)3.6f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailFront = rear.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(30, 30).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-0.8f, (float)2.0033f, (float)0.0f, (float)0.0f));
        tailFront.addOrReplaceChild("tailRear", CubeListBuilder.create().texOffs(62, 33).addBox(-0.98f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-1.5f, (float)0.5463f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(56, 0).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)10.3704f, (float)-4.8828f, (float)0.182f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFrontLower = legRightFront.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(81, 10).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.5f, (float)-0.3187f, (float)0.0f, (float)0.0f));
        legRightFrontLower.addOrReplaceChild("pawRightFront", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.3f, (float)0.1367f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(40, 0).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)10.3704f, (float)-4.8828f, (float)0.182f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFrontLower = legLeftFront.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(69, 10).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.5f, (float)-0.3187f, (float)0.0f, (float)0.0f));
        legLeftFrontLower.addOrReplaceChild("pawLeftFront", CubeListBuilder.create().texOffs(56, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-0.3f, (float)0.1367f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(50, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)12.209f, (float)12.8827f, (float)-0.4383f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRearLower = legRightRear.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(82, 33).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)5.15f, (float)-0.25f, (float)0.5918f, (float)0.0f, (float)0.0f));
        legRightRearLower.addOrReplaceChild("pawRightRear", CubeListBuilder.create().texOffs(16, 38).addBox(-2.0f, 0.0f, -2.2f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.3f, (float)0.0f, (float)-0.1367f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(38, 30).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)12.209f, (float)12.8827f, (float)-0.4383f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRearLower = legLeftRear.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(70, 33).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)5.15f, (float)-0.25f, (float)0.5918f, (float)0.0f, (float)0.0f));
        legLeftRearLower.addOrReplaceChild("pawLeftRear", CubeListBuilder.create().texOffs(0, 38).addBox(-2.0f, 0.0f, -2.2f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.3f, (float)0.0f, (float)-0.1367f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)96, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

