/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.CivilianRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CivilianRevenantModel
extends HierarchicalModel<CivilianRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart headMain;
    public ModelPart jawUpper;
    public ModelPart jawLower;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart bodyLower;
    public ModelPart pelvisMain;
    public ModelPart pelvisRight;
    public ModelPart pelvisLeft;
    public ModelPart thighRight;
    public ModelPart thighLeft;
    public ModelPart legRight;
    public ModelPart legLeft;

    public CivilianRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.headMain = this.bodyUpper.getChild("headMain");
        this.jawUpper = this.headMain.getChild("jawUpper");
        this.jawLower = this.jawUpper.getChild("jawLower");
        this.shoulderMain = this.bodyUpper.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.bodyLower = this.root.getChild("bodyLower");
        this.pelvisMain = this.bodyLower.getChild("pelvisMain");
        this.pelvisRight = this.pelvisMain.getChild("pelvisRight");
        this.pelvisLeft = this.pelvisMain.getChild("pelvisLeft");
        this.thighRight = this.pelvisRight.getChild("thighRight");
        this.thighLeft = this.pelvisLeft.getChild("thighLeft");
        this.legRight = this.thighRight.getChild("legRight");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(CivilianRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, 0.0f, 0.0f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f);
        this.setRotateAngles(this.jawLower, 0.1047f, 0.0f, 0.0f);
        this.setRotateAngles(this.armRightUpper, 0.0f, 0.0f, 0.2047f);
        this.setRotateAngles(this.armRightLower, -0.1047f, 0.0f, -0.1047f);
        this.setRotateAngles(this.armLeftUpper, 0.0f, 0.0f, -0.2094f);
        this.setRotateAngles(this.armLeftLower, -0.1047f, 0.0f, 0.1047f);
        this.setRotateAngles(this.thighRight, -0.3142f, 0.3142f, -0.0436f);
        this.setRotateAngles(this.thighLeft, -0.3142f, -0.3142f, 0.0436f);
        this.setRotateAngles(this.legRight, 0.2094f, 0.0f, 0.0f);
        this.setRotateAngles(this.legLeft, 0.2094f, 0.0f, 0.0f);
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void attackAnim() {
        this.armRightUpper.xRot -= Mth.sin((float)(this.attackTime * (float)Math.PI));
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.zRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.jawLower.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.thighRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        this.thighLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.5f * pLimbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(18, 46).addBox(-3.5f, -16.2f, 0.3f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)10.2f, (float)0.1f));
        PartDefinition headMain = bodyUpper.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -8.0f, -4.0f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-14.2f, (float)-0.1f));
        PartDefinition jawUpper = headMain.addOrReplaceChild("jawUpper", CubeListBuilder.create().texOffs(41, 18).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        jawUpper.addOrReplaceChild("jawLower", CubeListBuilder.create().texOffs(42, 30).addBox(-2.5f, -0.8f, -3.3f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1047f, (float)0.0f, (float)0.0f));
        PartDefinition shoulderMain = bodyUpper.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(22, 0).addBox(-5.0f, 5.5f, 0.2f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-18.2f, (float)-0.3f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(50, 51).addBox(-1.8f, 0.0f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)6.0f, (float)0.2f, (float)0.0f, (float)0.0f, (float)0.2047f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(52, 9).addBox(-1.8f, -0.2f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.1047f, (float)0.0f, (float)-0.1047f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(26, 46).addBox(-0.2f, 0.0f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.5f, (float)6.0f, (float)0.2f, (float)0.0f, (float)0.0f, (float)-0.2047f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(34, 46).addBox(-0.2f, -0.2f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.1047f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperRightRear = bodyUpper.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(57, 18).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-16.2f, (float)-0.1f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(12, 38).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(0, 6).addBox(-5.0f, 8.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperLeftRear = bodyUpper.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(56, 5).addBox(1.0f, 3.0f, 1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-16.2f, (float)-0.1f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(36, 2).addBox(5.0f, 5.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(0, 0).addBox(2.0f, 8.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperCenterRightRear = bodyUpper.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(56, 42).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8f, (float)-14.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(36, 55).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(32, 55).addBox(-5.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribUpperCenterLeftRear = bodyUpper.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(50, 0).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)-14.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(26, 55).addBox(5.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(46, 9).addBox(2.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribCenterRightRear = bodyUpper.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(24, 18).addBox(-5.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9f, (float)-13.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)-0.2094f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(54, 37).addBox(-6.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(0, 4).addBox(-5.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribCenterLeftRear = bodyUpper.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(56, 51).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1f, (float)-13.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)0.2094f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(56, 0).addBox(5.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(32, 57).addBox(2.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribLowerCenterLeftRear = bodyUpper.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(22, 6).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1f, (float)-12.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)0.3142f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(48, 25).addBox(5.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(0, 2).addBox(2.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ribLowerLeftRear = bodyUpper.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(57, 21).addBox(1.0f, 3.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)-11.2f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(42, 56).addBox(5.0f, 5.0f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(58, 8).addBox(2.0f, 7.0f, -2.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        bodyUpper.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(46, 2).addBox(-2.0f, 3.5f, -2.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-16.2f, (float)-0.3f));
        PartDefinition robeUpper = bodyUpper.addOrReplaceChild("robeUpper", CubeListBuilder.create().texOffs(28, 18).addBox(1.0f, 0.5f, -4.0f, 3.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)-14.2f, (float)-0.1f));
        robeUpper.addOrReplaceChild("robeLeft", CubeListBuilder.create().texOffs(0, 38).addBox(4.0f, 0.1f, -3.4f, 3.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition robeRightUpper = robeUpper.addOrReplaceChild("robeRightUpper", CubeListBuilder.create().texOffs(22, 36).addBox(-4.0f, 4.5f, -3.3f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        robeRightUpper.addOrReplaceChild("robeRightLower", CubeListBuilder.create().texOffs(24, 8).addBox(-3.9f, -1.1f, -3.4f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition robeCenter = robeUpper.addOrReplaceChild("robeCenter", CubeListBuilder.create().texOffs(0, 14).addBox(-4.5f, 9.5f, -3.5f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        robeCenter.addOrReplaceChild("robeLower", CubeListBuilder.create().texOffs(0, 25).addBox(-4.5f, 14.5f, -3.0f, 9.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(22, 2).addBox(-4.0f, -15.2f, 1.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(22, 4).addBox(-3.5f, 19.8f, -1.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-34.0f, (float)0.0f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(18, 38).addBox(-3.8f, 0.5f, -1.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(42, 46).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)1.2f, (float)0.1f, (float)-0.3142f, (float)0.3142f, (float)-0.0436f));
        thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(50, 42).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(54, 25).addBox(1.8f, 0.5f, -1.0f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        PartDefinition thighLeft = pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(0, 55).addBox(-0.6f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)1.2f, (float)0.1f, (float)-0.3142f, (float)-0.3142f, (float)0.0436f));
        thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(8, 55).addBox(-0.6f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

