/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.CrawlerRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrawlerRevenantModel
extends HierarchicalModel<CrawlerRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart headMain;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;

    public CrawlerRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.headMain = this.bodyUpper.getChild("headMain");
        this.shoulderMain = this.bodyUpper.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
    }

    public void setupAnim(CrawlerRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, -1.2625f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f - 0.0242f, 0.0395f);
        this.setRotateAngles(this.armRightUpper, -1.8284f, 0.0873f, 0.0f);
        this.setRotateAngles(this.armRightLower, -0.9879f, -0.011f, -0.01f);
        this.setRotateAngles(this.armLeftUpper, -1.6408f, -0.6545f, -0.1745f);
        this.setRotateAngles(this.armLeftLower, -1.1985f, 0.1268f, 0.0036f);
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.root.y -= (float)(pEntity.getTick() - pEntity.maxTick);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void attackAnim() {
        this.armRightUpper.xRot -= Mth.sin((float)(this.attackTime * (float)Math.PI));
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.zRot -= IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing + (float)Math.PI)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing + (float)Math.PI)) * pLimbSwingAmount * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)pLimbSwing) * pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)pLimbSwing) * pLimbSwingAmount * pLimbSwingAmount;
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(32, 9).addBox(-0.9999f, -14.9948f, -1.1447f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2125f, (float)19.4625f, (float)7.925f, (float)1.3659f, (float)0.0f, (float)0.0911f));
        PartDefinition headMain = bodyUpper.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(24, 28).addBox(-3.427f, -5.0496f, -7.9019f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0344f, (float)-14.071f, (float)-0.1688f, (float)-1.2625f, (float)-0.0242f, (float)0.0395f));
        headMain.addOrReplaceChild("jawMain", CubeListBuilder.create().texOffs(32, 2).addBox(-2.5f, 0.0f, -5.9875f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.073f, (float)0.9504f, (float)-1.4144f));
        PartDefinition shoulderMain = bodyUpper.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(28, 0).addBox(-6.5f, -0.5f, -0.5f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1366f, (float)-11.9549f, (float)-1.0262f, (float)-0.0024f, (float)-0.0853f, (float)0.0186f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(16, 36).addBox(-2.1693f, -1.2826f, -1.3431f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.9942f, (float)0.0103f, (float)-0.0887f, (float)-1.8284f, (float)0.0873f, (float)0.0f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(0, 40).addBox(-0.9975f, -0.0375f, -1.4519f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1818f, (float)5.7299f, (float)-0.5681f, (float)-0.9879f, (float)-0.011f, (float)-0.01f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(24, 42).addBox(-0.6185f, -0.002f, -1.0082f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0058f, (float)0.0353f, (float)0.2614f, (float)-1.6408f, (float)-0.6545f, (float)-0.1745f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(32, 42).addBox(-1.0043f, -1.0351f, -7.0E-4f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.394f, (float)5.8855f, (float)-1.0207f, (float)-1.1985f, (float)0.1268f, (float)0.0036f));
        PartDefinition ribUpperRightRear = bodyUpper.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(50, 47).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9229f, (float)-12.0555f, (float)-0.4963f, (float)-0.0024f, (float)-0.0853f, (float)0.0186f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(46, 23).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(9, 53).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperLeftRear = bodyUpper.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(50, 13).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0097f, (float)-11.8544f, (float)0.427f, (float)-0.0024f, (float)-0.0853f, (float)0.0186f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(40, 21).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(51, 52).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperCenterRightRear = bodyUpper.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(24, 51).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8436f, (float)-10.0023f, (float)-0.4908f, (float)0.0065f, (float)-0.0851f, (float)-0.0865f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(48, 2).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(43, 52).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribUpperCenterLeftRear = bodyUpper.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(34, 51).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.832f, (float)-9.8293f, (float)0.4012f, (float)-0.0113f, (float)-0.0846f, (float)0.1237f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(48, 17).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(23, 53).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterRightRear = bodyUpper.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(52, 24).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.444f, (float)-8.5505f, (float)-0.434f, (float)0.0154f, (float)-0.0839f, (float)-0.1916f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(0, 49).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(0, 54).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterLeftRear = bodyUpper.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(28, 2).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.387f, (float)-8.4287f, (float)0.3358f, (float)-0.0201f, (float)-0.0829f, (float)0.2288f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(46, 29).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(52, 29).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerCenterLeftRear = bodyUpper.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(46, 34).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.9131f, (float)-7.1718f, (float)0.2585f, (float)-0.0287f, (float)-0.0804f, (float)0.3338f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(44, 47).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(52, 31).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerLeftRear = bodyUpper.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(52, 22).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2432f, (float)-6.1471f, (float)0.1497f, (float)-0.037f, (float)-0.0769f, (float)0.4388f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(48, 42).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(31, 53).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        bodyUpper.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(40, 9).addBox(-2.0f, -3.0f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2782f, (float)-9.4571f, (float)-3.2242f, (float)-0.0024f, (float)-0.0853f, (float)0.0186f));
        bodyUpper.addOrReplaceChild("coatMain", CubeListBuilder.create().texOffs(0, 0).addBox(-6.05f, 0.0f, 0.5f, 12.0f, 32.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1987f, (float)-13.9564f, (float)-1.03f, (float)-0.1085f, (float)-0.0853f, (float)0.0186f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(0, 36).addBox(-3.9804f, -0.551f, -0.549f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2536f, (float)19.542f, (float)7.9619f, (float)1.3659f, (float)0.0f, (float)0.0911f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(0, 38).addBox(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0538f, (float)0.6912f, (float)-2.8355f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(50, 9).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8575f, (float)-0.4258f, (float)1.4005f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(40, 42).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3889f, (float)0.1658f, (float)0.037f, (float)-0.2487f, (float)-0.0911f, (float)0.0f));
        thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(16, 45).addBox(-1.4f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0125f, (float)7.0f, (float)0.0f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(6, 49).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8575f, (float)-0.4258f, (float)1.4005f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(8, 40).addBox(-0.6f, 0.0625f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.3736f, (float)-0.0342f, (float)0.3995f, (float)-0.2979f, (float)0.0911f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

