/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.CrocottaEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrocottaModel
extends HierarchicalModel<CrocottaEntity> {
    public ModelPart root;
    public ModelPart body;
    public ModelPart bodyFront;
    public ModelPart neckRear;
    public ModelPart neckCenter;
    public ModelPart neckFront;
    public ModelPart head;
    public ModelPart maneRear;
    public ModelPart maneCenter;
    public ModelPart maneFront;
    public ModelPart thighRightFront;
    public ModelPart legRightFront;
    public ModelPart pawRightFront;
    public ModelPart thighLeftFront;
    public ModelPart legLeftFront;
    public ModelPart pawLeftFront;
    public ModelPart bodyRear;
    public ModelPart thighRightRear;
    public ModelPart legRightRear;
    public ModelPart pawRightRear;
    public ModelPart thighLeftRear;
    public ModelPart legLeftRear;
    public ModelPart pawLeftRear;

    public CrocottaModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.bodyFront = this.body.getChild("bodyFront");
        this.neckRear = this.bodyFront.getChild("neckRear");
        this.neckCenter = this.neckRear.getChild("neckCenter");
        this.neckFront = this.neckCenter.getChild("neckFront");
        this.head = this.neckFront.getChild("head");
        this.maneRear = this.body.getChild("maneRear");
        this.maneCenter = this.maneRear.getChild("maneCenter");
        this.maneFront = this.maneCenter.getChild("maneFront");
        this.thighRightFront = this.bodyFront.getChild("thighRightFront");
        this.legRightFront = this.thighRightFront.getChild("legRightFront");
        this.pawRightFront = this.legRightFront.getChild("pawRightFront");
        this.thighLeftFront = this.bodyFront.getChild("thighLeftFront");
        this.legLeftFront = this.thighLeftFront.getChild("legLeftFront");
        this.pawLeftFront = this.legLeftFront.getChild("pawLeftFront");
        this.bodyRear = this.body.getChild("bodyRear");
        this.thighRightRear = this.bodyRear.getChild("thighRightRear");
        this.legRightRear = this.thighRightRear.getChild("legRightRear");
        this.pawRightRear = this.legRightRear.getChild("pawRightRear");
        this.thighLeftRear = this.bodyRear.getChild("thighLeftRear");
        this.legLeftRear = this.thighLeftRear.getChild("legLeftRear");
        this.pawLeftRear = this.legLeftRear.getChild("pawLeftRear");
    }

    public void setupAnim(CrocottaEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.CROCOTTA_ATTACK, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        float xRot = IcariaMath.rad(pHeadPitch) / 1.5f;
        float yRot = IcariaMath.rad(pNetHeadYaw) / 3.0f;
        this.maneFront.xRot = xRot + 0.2182f;
        this.maneFront.yRot = yRot;
        this.neckCenter.xRot = xRot + 0.0873f;
        this.neckCenter.yRot = yRot;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)(pLimbSwing *= 1.375f)) * (pLimbSwingAmount *= 0.875f) * 0.5f;
        this.thighRightFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * 0.6f * pLimbSwingAmount + 0.3054f;
        this.legRightFront.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.pawRightFront.xRot = -Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.0f))) * 0.5f + 0.0f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0436f;
        this.thighLeftFront.xRot = -Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * 0.6f * pLimbSwingAmount + 0.3054f;
        this.legLeftFront.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.pawLeftFront.xRot = -Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 1.5707964f))) * 0.5f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0436f;
        this.thighRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * 1.2f * pLimbSwingAmount + 0.0436f;
        this.legRightRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2182f;
        this.pawRightRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 2.3561945f))) * 0.5f + 4.712389f)) * pLimbSwingAmount + pLimbSwingAmount - 0.1309f;
        this.thighLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * 1.2f * pLimbSwingAmount + 0.0436f;
        this.legLeftRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount + 0.2182f;
        this.pawLeftRear.xRot = Mth.sin((float)((pLimbSwing + Mth.sin((float)(pLimbSwing + 0.7853982f))) * 0.5f + 1.5707964f)) * pLimbSwingAmount + pLimbSwingAmount - 0.1309f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -18.0f, 0.0f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition maneRear = body.addOrReplaceChild("maneRear", CubeListBuilder.create().texOffs(8, 47).addBox(-0.5f, 0.0031f, -3.6945f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-18.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition maneCenter = maneRear.addOrReplaceChild("maneCenter", CubeListBuilder.create().texOffs(14, 38).addBox(-0.5f, 0.0069f, -5.9922f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.7f, (float)0.2182f, (float)0.0f, (float)0.0f));
        maneCenter.addOrReplaceChild("maneFront", CubeListBuilder.create().texOffs(0, 38).addBox(-0.5f, -2.6051f, -6.004f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.546f, (float)-5.415f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFront = body.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(50, 0).addBox(-3.0f, -8.0114f, -4.8698f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.75f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neckRear = bodyFront.addOrReplaceChild("neckRear", CubeListBuilder.create().texOffs(20, 15).addBox(-2.5f, -6.0f, -3.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.2614f, (float)-4.8698f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neckCenter = neckRear.addOrReplaceChild("neckCenter", CubeListBuilder.create().texOffs(28, 27).addBox(-2.0f, -0.0192f, -2.9998f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.9886f, (float)-3.0002f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neckFront = neckCenter.addOrReplaceChild("neckFront", CubeListBuilder.create().texOffs(42, 38).addBox(-2.5f, -0.5f, -2.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0114f, (float)-1.9998f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neckFront.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 0).addBox(-3.0f, -0.9f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(40, 69).addBox(-4.25f, -1.1f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.1309f));
        head.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(46, 69).addBox(2.25f, -1.1f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)-0.1309f));
        PartDefinition noseRearUpper = head.addOrReplaceChild("noseRearUpper", CubeListBuilder.create().texOffs(0, 58).addBox(-2.0f, -1.9743f, -2.5381f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0364f, (float)-6.0002f, (float)0.1745f, (float)0.0f, (float)0.0f));
        noseRearUpper.addOrReplaceChild("noseFrontUpper", CubeListBuilder.create().texOffs(32, 69).addBox(-1.5f, 0.0011f, -1.0004f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.9754f, (float)-2.5377f));
        PartDefinition noseRearLower = head.addOrReplaceChild("noseRearLower", CubeListBuilder.create().texOffs(22, 58).addBox(-2.0f, 0.0247f, -2.5387f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0364f, (float)-6.0002f, (float)0.2618f, (float)0.0f, (float)0.0f));
        noseRearLower.addOrReplaceChild("noseFrontLower", CubeListBuilder.create().texOffs(32, 72).addBox(-1.5f, -1.0003f, -0.9992f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.025f, (float)-2.5395f));
        PartDefinition thighRightFront = bodyFront.addOrReplaceChild("thighRightFront", CubeListBuilder.create().texOffs(38, 15).addBox(-1.5f, -0.0186f, -2.0319f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-4.9525f, (float)-3.7875f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = thighRightFront.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(20, 47).addBox(-1.0f, -1.1696f, -0.9602f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.966f, (float)-0.071f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        legRightFront.addOrReplaceChild("pawRightFront", CubeListBuilder.create().texOffs(36, 58).addBox(-1.5f, -0.0087f, -1.7609f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.393f, (float)0.0535f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition thighLeftFront = bodyFront.addOrReplaceChild("thighLeftFront", CubeListBuilder.create().texOffs(0, 27).addBox(-1.5f, -0.0173f, -2.0237f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-4.9525f, (float)-3.7875f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftFront = thighLeftFront.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(14, 58).addBox(-1.0f, -1.1651f, -0.952f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.966f, (float)-0.071f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        legLeftFront.addOrReplaceChild("pawLeftFront", CubeListBuilder.create().texOffs(12, 69).addBox(-1.5f, -0.0076f, -1.7528f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.393f, (float)0.0535f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = body.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)6.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tail = bodyRear.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(28, 38).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)4.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition tailFront = tail.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(36, 47).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        tailFront.addOrReplaceChild("tailRear", CubeListBuilder.create().texOffs(24, 69).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.0f, (float)-0.1963f, (float)0.0f, (float)0.0f));
        PartDefinition thighRightRear = bodyRear.addOrReplaceChild("thighRightRear", CubeListBuilder.create().texOffs(44, 27).addBox(-1.5f, -0.0129f, -1.9996f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)2.7305f, (float)2.7385f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition legRightRear = thighRightRear.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(28, 47).addBox(-1.0f, -1.3816f, -0.9823f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.979f, (float)-0.023f, (float)0.2182f, (float)0.0f, (float)0.0f));
        legRightRear.addOrReplaceChild("pawRightRear", CubeListBuilder.create().texOffs(0, 69).addBox(-1.5f, -0.0059f, -1.6865f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.04f, (float)0.0295f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition thighLeftRear = bodyRear.addOrReplaceChild("thighLeftRear", CubeListBuilder.create().texOffs(14, 27).addBox(-1.5f, -0.0129f, -1.9996f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)2.7305f, (float)2.7385f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition legLeftRear = thighLeftRear.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(0, 47).addBox(-1.0f, -1.3816f, -0.9823f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.979f, (float)-0.023f, (float)0.2182f, (float)0.0f, (float)0.0f));
        legLeftRear.addOrReplaceChild("pawLeftRear", CubeListBuilder.create().texOffs(22, 62).addBox(-1.5f, -0.0059f, -1.6865f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.04f, (float)0.0295f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)80, (int)80);
    }

    public ModelPart root() {
        return this.root;
    }
}

