/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.SlugEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrystalSlugModel
extends HierarchicalModel<SlugEntity> {
    public ModelPart root;
    public ModelPart bodyFront;
    public ModelPart neck;
    public ModelPart neckCrystalCenter;
    public ModelPart head;
    public ModelPart feelerRight;
    public ModelPart feelerLeft;
    public ModelPart bodyCenter;
    public ModelPart bodyCenterCrystal;
    public ModelPart bodyRear;
    public ModelPart bodyRearCrystal;

    public CrystalSlugModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyFront = this.root.getChild("bodyFront");
        this.neck = this.bodyFront.getChild("neck");
        this.neckCrystalCenter = this.neck.getChild("neckCrystalCenter");
        this.head = this.neck.getChild("head");
        this.feelerRight = this.head.getChild("feelerRight");
        this.feelerLeft = this.head.getChild("feelerLeft");
        this.bodyCenter = this.root.getChild("bodyCenter");
        this.bodyCenterCrystal = this.root.getChild("bodyCenterCrystal");
        this.bodyRear = this.root.getChild("bodyRear");
        this.bodyRearCrystal = this.root.getChild("bodyRearCrystal");
    }

    public void setupAnim(SlugEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idleAnim(pAgeInTicks);
        this.animate(pEntity.hideAnimationState, IcariaAnimations.CRYSTAL_SLUG_HIDE, pAgeInTicks);
        this.animate(pEntity.hurtAnimationState, IcariaAnimations.CRYSTAL_SLUG_HURT, pAgeInTicks);
        this.animate(pEntity.moveAnimationState, IcariaAnimations.CRYSTAL_SLUG_MOVE, pAgeInTicks);
        this.animate(pEntity.showAnimationState, IcariaAnimations.CRYSTAL_SLUG_SHOW, pAgeInTicks);
    }

    public void idleAnim(float pAgeInTicks) {
        this.feelerRight.xRot = Mth.sin((float)(pAgeInTicks * 0.05f + 1.0f)) * 0.075f + 0.2618f;
        this.feelerRight.zRot = Mth.cos((float)(pAgeInTicks * 0.075f + 2.0f)) * 0.075f + 0.7854f;
        this.feelerLeft.xRot = -Mth.sin((float)(pAgeInTicks * 0.05f + 3.0f)) * 0.075f + 0.2618f;
        this.feelerLeft.zRot = -Mth.cos((float)(pAgeInTicks * 0.075f + 4.0f)) * 0.075f - 0.7854f;
    }

    public void translateToNeck(PoseStack pPoseStack) {
        this.bodyFront.translateAndRotate(pPoseStack);
        this.neck.translateAndRotate(pPoseStack);
        this.neckCrystalCenter.translateAndRotate(pPoseStack);
    }

    public void translateToCenter(PoseStack pPoseStack) {
        this.bodyCenterCrystal.translateAndRotate(pPoseStack);
    }

    public void translateToRear(PoseStack pPoseStack) {
        this.bodyRearCrystal.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyFront = partDefinition.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(0, 20).addBox(-3.5f, -5.0f, -6.0f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)-12.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodyFront.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 10).addBox(-3.0f, -5.0f, -5.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neckCrystalCenter = neck.addOrReplaceChild("neckCrystalCenter", CubeListBuilder.create().texOffs(0, 44).addBox(-0.5f, -1.0f, -4.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.1963f));
        neckCrystalCenter.addOrReplaceChild("neckCrystalNorth", CubeListBuilder.create().texOffs(0, 38).addBox(-0.5f, -3.5f, -5.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)-0.3054f, (float)0.1091f));
        neckCrystalCenter.addOrReplaceChild("neckCrystalEast", CubeListBuilder.create().texOffs(18, 52).addBox(-1.5f, 0.0f, -4.5f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)-0.1963f));
        neckCrystalCenter.addOrReplaceChild("neckCrystalSouth", CubeListBuilder.create().texOffs(0, 52).addBox(0.5f, -1.0f, -0.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.1745f, (float)0.1963f));
        neckCrystalCenter.addOrReplaceChild("neckCrystalWest", CubeListBuilder.create().texOffs(12, 37).addBox(3.5f, -1.0f, -2.5f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1963f, (float)0.1745f, (float)0.1963f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -5.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("mandibleRight", CubeListBuilder.create().texOffs(20, 20).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)-0.5f, (float)0.1963f, (float)0.0f, (float)0.1963f));
        head.addOrReplaceChild("mandibleLeft", CubeListBuilder.create().texOffs(20, 20).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)-0.5f, (float)0.1963f, (float)0.0f, (float)-0.1963f));
        PartDefinition feelerRight = head.addOrReplaceChild("feelerRight", CubeListBuilder.create().texOffs(21, 1).addBox(-0.5f, -0.5f, -4.75f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.7854f));
        feelerRight.addOrReplaceChild("eyeRight", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -1.0f, -6.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition feelerLeft = head.addOrReplaceChild("feelerLeft", CubeListBuilder.create().texOffs(20, 0).addBox(-0.5f, -0.5f, -5.75f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)-0.7854f));
        feelerLeft.addOrReplaceChild("eyeLeft", CubeListBuilder.create().texOffs(28, 0).addBox(-1.0f, -1.0f, -7.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 59).addBox(-4.0f, -5.0f, -16.0f, 8.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)4.0f));
        PartDefinition bodyCenterCrystal = partDefinition.addOrReplaceChild("bodyCenterCrystal", CubeListBuilder.create().texOffs(56, 7).addBox(-4.0f, -1.0f, -8.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)19.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        bodyCenterCrystal.addOrReplaceChild("bodyCenterCrystalNorth", CubeListBuilder.create().texOffs(64, 0).addBox(-2.5f, -2.25f, -5.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        bodyCenterCrystal.addOrReplaceChild("bodyCenterCrystalEast", CubeListBuilder.create().texOffs(48, 17).addBox(-5.0f, -2.35f, -2.75f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        bodyCenterCrystal.addOrReplaceChild("bodyCenterCrystalSouth", CubeListBuilder.create().texOffs(64, 17).addBox(-4.5f, -3.25f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        bodyCenterCrystal.addOrReplaceChild("bodyCenterCrystalWest", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, -0.5f, -1.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition bodyRear = partDefinition.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(32, 61).addBox(-3.5f, -4.0f, 0.0f, 7.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)4.0f));
        PartDefinition tailFront = bodyRear.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(56, 62).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)10.0f));
        tailFront.addOrReplaceChild("tailRear", CubeListBuilder.create().texOffs(62, 74).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition bodyRearCrystal = partDefinition.addOrReplaceChild("bodyRearCrystal", CubeListBuilder.create().texOffs(60, 43).addBox(-1.0f, -1.0f, 0.1f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)20.0f, (float)10.0f, (float)-0.1963f, (float)0.0f, (float)-0.0873f));
        bodyRearCrystal.addOrReplaceChild("bodyRearCrystalNorth", CubeListBuilder.create().texOffs(72, 39).addBox(0.5f, -0.9f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)-0.7854f, (float)0.2618f));
        bodyRearCrystal.addOrReplaceChild("bodyRearCrystalEast", CubeListBuilder.create().texOffs(56, 51).addBox(-2.0f, 1.1f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.1963f, (float)0.0f));
        bodyRearCrystal.addOrReplaceChild("bodyRearCrystalSouth", CubeListBuilder.create().texOffs(68, 51).addBox(0.5f, -0.9f, 4.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.1963f, (float)0.2618f));
        bodyRearCrystal.addOrReplaceChild("bodyRearCrystalWest", CubeListBuilder.create().texOffs(62, 37).addBox(2.5f, -0.88f, 1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0654f, (float)0.3054f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)80, (int)80);
    }

    public ModelPart root() {
        return this.root;
    }
}

