/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CypressForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyBase;
    public ModelPart bodyMain;
    public ModelPart bodyLower;
    public ModelPart bodyCenter;
    public ModelPart bodyUpper;
    public ModelPart neckMain;
    public ModelPart headMain;
    public ModelPart headBranchRightLower;
    public ModelPart headBranchRightUpper;
    public ModelPart headBranchLeftLower;
    public ModelPart headBranchLeftUpper;
    public ModelPart neckShroom;
    public ModelPart shoulderRight;
    public ModelPart armRight;
    public ModelPart shoulderLeft;
    public ModelPart armLeft;
    public ModelPart bodyUpperBranchLower;
    public ModelPart bodyUpperTwigLower;
    public ModelPart bodyUpperTwigUpper;
    public ModelPart bodyUpperBranchCenter;
    public ModelPart bodyUpperBranchUpper;
    public ModelPart bodyUpperTwigFront;
    public ModelPart bodyUpperTwigRight;
    public ModelPart bodyUpperTwigLeft;
    public ModelPart bodyRump;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;
    public ModelPart footLeft;

    public CypressForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyBase = this.root.getChild("bodyBase");
        this.bodyMain = this.bodyBase.getChild("bodyMain");
        this.bodyLower = this.bodyMain.getChild("bodyLower");
        this.bodyCenter = this.bodyLower.getChild("bodyCenter");
        this.bodyUpper = this.bodyCenter.getChild("bodyUpper");
        this.neckMain = this.bodyUpper.getChild("neckMain");
        this.headMain = this.neckMain.getChild("headMain");
        this.headBranchRightLower = this.headMain.getChild("headBranchRightLower");
        this.headBranchRightUpper = this.headBranchRightLower.getChild("headBranchRightUpper");
        this.headBranchLeftLower = this.headMain.getChild("headBranchLeftLower");
        this.headBranchLeftUpper = this.headBranchLeftLower.getChild("headBranchLeftUpper");
        this.neckShroom = this.bodyUpper.getChild("neckShroom");
        this.shoulderRight = this.bodyUpper.getChild("shoulderRight");
        this.armRight = this.shoulderRight.getChild("armRight");
        this.shoulderLeft = this.bodyUpper.getChild("shoulderLeft");
        this.armLeft = this.shoulderLeft.getChild("armLeft");
        this.bodyUpperBranchLower = this.bodyUpper.getChild("bodyUpperBranchLower");
        this.bodyUpperTwigLower = this.bodyUpperBranchLower.getChild("bodyUpperTwigLower");
        this.bodyUpperTwigUpper = this.bodyUpperTwigLower.getChild("bodyUpperTwigUpper");
        this.bodyUpperBranchCenter = this.bodyUpperBranchLower.getChild("bodyUpperBranchCenter");
        this.bodyUpperBranchUpper = this.bodyUpperBranchCenter.getChild("bodyUpperBranchUpper");
        this.bodyUpperTwigFront = this.bodyUpperBranchUpper.getChild("bodyUpperTwigFront");
        this.bodyUpperTwigRight = this.bodyUpperBranchUpper.getChild("bodyUpperTwigRight");
        this.bodyUpperTwigLeft = this.bodyUpperBranchUpper.getChild("bodyUpperTwigLeft");
        this.bodyRump = this.bodyBase.getChild("bodyRump");
        this.thighRight = this.bodyBase.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyBase.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
        this.footLeft = this.legLeft.getChild("footLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.shoulderRight.xRot = -0.1745f;
        this.shoulderRight.zRot = 0.4427f;
        this.shoulderLeft.xRot = -0.3927f;
        this.shoulderLeft.zRot = -0.1373f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.shoulderRight.zRot -= f;
            this.shoulderLeft.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.shoulderRight.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.shoulderRight.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.shoulderLeft.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.shoulderLeft.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyMain, 0.015f, -0.0873f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLower, 0.1023f, -0.0873f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenter, 0.1023f, -0.0873f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpper, 0.1023f, -0.0873f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, 0.6259f, 0.1745f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.headBranchRightLower, 0.015f, -0.4098f, -0.5613f, pAgeInTicks);
        this.wiggleRotateAngles(this.headBranchRightUpper, 0.2881f, 0.2276f, 0.3037f, pAgeInTicks);
        this.wiggleRotateAngles(this.headBranchLeftLower, 0.015f, 0.3927f, 0.5086f, pAgeInTicks);
        this.wiggleRotateAngles(this.headBranchLeftUpper, 0.2881f, 0.2276f, -0.2881f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckShroom, 0.1023f, -0.0873f, 0.1595f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchLower, 0.4248f, 0.7854f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigLower, -0.3948f, 1.7301f, -0.0606f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigUpper, -0.4404f, 3.1416f, 1.1233f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchCenter, 0.4077f, -0.1745f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchUpper, 0.4077f, 0.2618f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigFront, 0.3793f, -0.9105f, 1.442f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigRight, 0.1061f, 0.8652f, 3.081f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigLeft, -0.9411f, 0.0456f, -0.5159f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyRump, 0.015f, -0.0873f, -0.4077f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) - 0.6109f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw) + 0.1745f;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.shoulderRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.1745f;
        this.armRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.0873f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.shoulderLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.3927f;
        this.armLeft.zRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.footLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyBase = partDefinition.addOrReplaceChild("bodyBase", CubeListBuilder.create().texOffs(0, 35).addBox(-5.5f, 0.0f, -2.5f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodyMain = bodyBase.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(36, 15).addBox(-4.5f, -3.5f, -2.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.015f, (float)-0.0873f, (float)-0.015f));
        bodyMain.addOrReplaceChild("bodyMainShroomLower", CubeListBuilder.create().texOffs(12, 31).addBox(0.0f, -1.8f, -3.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition bodyLower = bodyMain.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(35, 6).addBox(-5.0f, -3.5f, -2.5f, 10.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.1023f, (float)-0.0873f, (float)-0.015f));
        bodyLower.addOrReplaceChild("bodyMainShroomCenter", CubeListBuilder.create().texOffs(0, 31).addBox(1.5f, -1.5f, -3.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition bodyCenter = bodyLower.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 11).addBox(-6.0f, -3.5f, -3.0f, 12.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.1023f, (float)-0.0873f, (float)-0.015f));
        bodyCenter.addOrReplaceChild("bodyMainShroomUpper", CubeListBuilder.create().texOffs(55, 0).addBox(1.5f, -1.5f, -4.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition bodyUpper = bodyCenter.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-6.5f, -3.5f, -3.5f, 13.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.1023f, (float)-0.0873f, (float)-0.015f));
        PartDefinition neckMain = bodyUpper.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(20, 59).addBox(-2.0f, -8.0f, -1.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-0.5f, (float)0.6259f, (float)0.1745f, (float)-0.015f));
        PartDefinition headMain = neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 44).addBox(-3.0f, -8.0f, -4.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-5.0f, (float)0.0f, (float)-0.6109f, (float)0.1745f, (float)0.0873f));
        PartDefinition headBranchLeavesLower = headMain.addOrReplaceChild("headBranchLeavesLower", CubeListBuilder.create().texOffs(26, 23).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.65f, (float)-10.0f, (float)-0.5f));
        headBranchLeavesLower.addOrReplaceChild("headBranchLeavesUpper", CubeListBuilder.create().texOffs(57, 59).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.1f));
        PartDefinition headBranchRightLower = headMain.addOrReplaceChild("headBranchRightLower", CubeListBuilder.create().texOffs(26, 21).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-6.4f, (float)-2.5f, (float)0.015f, (float)-0.4098f, (float)-0.5613f));
        headBranchRightLower.addOrReplaceChild("headBranchRightUpper", CubeListBuilder.create().texOffs(0, 11).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.2881f, (float)0.2276f, (float)0.3037f));
        PartDefinition headBranchLeftLower = headMain.addOrReplaceChild("headBranchLeftLower", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -3.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-6.4f, (float)0.5f, (float)0.015f, (float)0.3927f, (float)0.5086f));
        headBranchLeftLower.addOrReplaceChild("headBranchLeftUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.2881f, (float)0.2276f, (float)-0.2881f));
        PartDefinition neckShroom = bodyUpper.addOrReplaceChild("neckShroom", CubeListBuilder.create().texOffs(0, 21).addBox(-9.5f, -2.0f, -3.5f, 9.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.1023f, (float)-0.0873f, (float)0.1595f));
        neckShroom.addOrReplaceChild("neckVine", CubeListBuilder.create().texOffs(46, 48).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)4.55f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition shoulderRight = bodyUpper.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(62, 48).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.4f, (float)-4.3f, (float)-0.5f, (float)-0.1745f, (float)0.1745f, (float)0.4427f));
        shoulderRight.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(56, 66).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.1f, (float)-0.0873f, (float)-0.3927f, (float)-0.1745f));
        PartDefinition shoulderLeft = bodyUpper.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(61, 11).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-3.0f, (float)-1.0f, (float)-0.3927f, (float)-0.7854f, (float)-0.1373f));
        shoulderLeft.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(36, 59).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)-2.5f, (float)0.0f, (float)-0.3927f, (float)0.0873f));
        PartDefinition bodyUpperBranchLower = bodyUpper.addOrReplaceChild("bodyUpperBranchLower", CubeListBuilder.create().texOffs(24, 48).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.4f, (float)-2.5f, (float)0.5f, (float)0.4248f, (float)0.7854f, (float)-0.015f));
        PartDefinition bodyUpperTwigLower = bodyUpperBranchLower.addOrReplaceChild("bodyUpperTwigLower", CubeListBuilder.create().texOffs(67, 19).addBox(-2.0f, -1.0f, -5.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)2.0f, (float)2.0f, (float)-0.3948f, (float)1.7301f, (float)-0.0606f));
        bodyUpperTwigLower.addOrReplaceChild("bodyUpperTwigUpper", CubeListBuilder.create().texOffs(72, 54).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.1f, (float)-4.5f, (float)-0.4404f, (float)3.1416f, (float)1.1233f));
        PartDefinition bodyUpperLeavesLeft = bodyUpperTwigLower.addOrReplaceChild("bodyUpperLeavesLeft", CubeListBuilder.create().texOffs(0, 58).addBox(-3.5f, -3.5f, -3.0f, 7.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-4.0f));
        bodyUpperLeavesLeft.addOrReplaceChild("bodyUpperLeavesRight", CubeListBuilder.create().texOffs(0, 68).addBox(-2.5f, -2.5f, -2.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition bodyUpperBranchCenter = bodyUpperBranchLower.addOrReplaceChild("bodyUpperBranchCenter", CubeListBuilder.create().texOffs(60, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)5.5f, (float)0.4077f, (float)-0.1745f, (float)-0.015f));
        PartDefinition bodyUpperBranchUpper = bodyUpperBranchCenter.addOrReplaceChild("bodyUpperBranchUpper", CubeListBuilder.create().texOffs(64, 66).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.8f, (float)4.0f, (float)0.4077f, (float)0.2618f, (float)-0.015f));
        bodyUpperBranchUpper.addOrReplaceChild("bodyUpperTwigFront", CubeListBuilder.create().texOffs(71, 3).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.9f, (float)0.1f, (float)2.5f, (float)0.3793f, (float)-0.9105f, (float)1.442f));
        bodyUpperBranchUpper.addOrReplaceChild("bodyUpperTwigRight", CubeListBuilder.create().texOffs(71, 43).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)1.1f, (float)4.5f, (float)0.1061f, (float)0.8652f, (float)3.081f));
        bodyUpperBranchUpper.addOrReplaceChild("bodyUpperTwigLeft", CubeListBuilder.create().texOffs(49, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)1.1f, (float)4.5f, (float)-0.9411f, (float)0.0456f, (float)-0.5159f));
        PartDefinition bodyUpperLeavesLower = bodyUpperBranchUpper.addOrReplaceChild("bodyUpperLeavesLower", CubeListBuilder.create().texOffs(32, 35).addBox(-4.5f, -4.5f, 4.0f, 9.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)0.0f));
        bodyUpperLeavesLower.addOrReplaceChild("bodyUpperLeavesUpper", CubeListBuilder.create().texOffs(58, 39).addBox(-3.0f, -3.0f, 8.0f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bodyBase.addOrReplaceChild("bodyRump", CubeListBuilder.create().texOffs(50, 23).addBox(-1.5f, 0.0f, -1.6f, 7.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)3.0f, (float)0.0f, (float)0.015f, (float)-0.0873f, (float)-0.4077f));
        PartDefinition thighRight = bodyBase.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(14, 69).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)3.2f, (float)-0.5f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(69, 27).addBox(-1.5f, -0.2f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0873f, (float)-0.0873f, (float)0.0f));
        PartDefinition footRight = legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(33, 0).addBox(-2.0f, -0.4f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0873f));
        footRight.addOrReplaceChild("soleRight", CubeListBuilder.create().texOffs(54, 30).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)-0.0873f));
        PartDefinition thighLeft = bodyBase.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(18, 44).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.4f, (float)3.7f, (float)-0.5f, (float)0.0f, (float)-0.2731f, (float)0.0f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(22, 71).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        legLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(44, 64).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0873f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

