/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DroughtrootForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyBase;
    public ModelPart bodyLower;
    public ModelPart bodyCenter;
    public ModelPart bodyCenterLeavesMain;
    public ModelPart bodyUpper;
    public ModelPart neckMain;
    public ModelPart headMain;
    public ModelPart shoulderRight;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart shoulderLeft;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart bodyUpperBranchLower;
    public ModelPart bodyUpperBranchCenter;
    public ModelPart bodyUpperLeavesLower;
    public ModelPart bodyUpperTwigMain;
    public ModelPart bodyUpperBranchUpper;
    public ModelPart bodyUpperLeavesCenter;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;

    public DroughtrootForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyBase = this.root.getChild("bodyBase");
        this.bodyLower = this.bodyBase.getChild("bodyLower");
        this.bodyCenter = this.bodyLower.getChild("bodyCenter");
        this.bodyCenterLeavesMain = this.bodyCenter.getChild("bodyCenterLeavesMain");
        this.bodyUpper = this.bodyCenter.getChild("bodyUpper");
        this.neckMain = this.bodyUpper.getChild("neckMain");
        this.headMain = this.neckMain.getChild("headMain");
        this.shoulderRight = this.bodyUpper.getChild("shoulderRight");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.shoulderLeft = this.bodyUpper.getChild("shoulderLeft");
        this.armLeftUpper = this.shoulderLeft.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.bodyUpperBranchLower = this.bodyUpper.getChild("bodyUpperBranchLower");
        this.bodyUpperBranchCenter = this.bodyUpperBranchLower.getChild("bodyUpperBranchCenter");
        this.bodyUpperLeavesLower = this.bodyUpperBranchCenter.getChild("bodyUpperLeavesLower");
        this.bodyUpperTwigMain = this.bodyUpperBranchCenter.getChild("bodyUpperTwigMain");
        this.bodyUpperBranchUpper = this.bodyUpperBranchCenter.getChild("bodyUpperBranchUpper");
        this.bodyUpperLeavesCenter = this.bodyUpperBranchUpper.getChild("bodyUpperLeavesCenter");
        this.thighRight = this.bodyBase.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyBase.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.armRightUpper.xRot = -0.3491f;
        this.armRightUpper.zRot = 0.4427f;
        this.armLeftUpper.xRot = -0.1745f;
        this.armLeftUpper.zRot = -0.1745f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.armRightUpper.zRot -= f;
            this.armLeftUpper.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyLower, 0.1023f, 0.0873f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenter, 0.1023f, 0.0873f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenterLeavesMain, -0.0761f, 0.0873f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpper, 0.1895f, 0.082f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, -0.6831f, -0.0698f, 0.1595f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRight, 0.1895f, -0.1396f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderLeft, 0.1895f, 0.082f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchLower, 0.015f, -0.0698f, 0.1595f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchCenter, 0.2768f, 0.0f, -0.1023f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperTwigMain, -0.8955f, -0.5463f, -0.197f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeavesLower, 0.015f, 0.7854f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperBranchUpper, 0.2768f, 0.0f, -0.1023f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeavesCenter, 0.015f, 0.7854f, -0.015f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) + 0.4363f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw) - 0.0873f;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.3491f;
        this.armRightLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.armLeftUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.1745f;
        this.armLeftLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.3491f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.legLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyBase = partDefinition.addOrReplaceChild("bodyBase", CubeListBuilder.create().texOffs(34, 46).addBox(-5.5f, 0.0f, -2.5f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)3.5f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)-0.0873f));
        PartDefinition bodyLower = bodyBase.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(56, 32).addBox(-4.7f, 0.0f, -2.5f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-3.7f, (float)0.2f, (float)0.1023f, (float)0.0873f, (float)0.0286f));
        PartDefinition bodyCenter = bodyLower.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 52).addBox(-5.5f, 0.0f, -3.5f, 10.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-3.5f, (float)0.2f, (float)0.1023f, (float)0.0873f, (float)0.0286f));
        bodyCenter.addOrReplaceChild("bodyCenterLeavesMain", CubeListBuilder.create().texOffs(0, 61).addBox(-1.0f, -7.0f, 0.0f, 2.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)2.5f, (float)-1.0f, (float)-0.0761f, (float)0.0873f, (float)0.0286f));
        PartDefinition bodyUpper = bodyCenter.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(0, 42).addBox(-5.5f, 0.0f, -3.0f, 11.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2f, (float)-3.3f, (float)-1.7f, (float)0.1895f, (float)0.082f, (float)0.0286f));
        PartDefinition neckMain = bodyUpper.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(54, 19).addBox(-1.5f, 0.0f, -7.0f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.7f, (float)0.3f, (float)-0.6831f, (float)-0.0698f, (float)0.1595f));
        neckMain.addOrReplaceChild("neckLeaves", CubeListBuilder.create().texOffs(58, 5).addBox(-0.5f, -1.0f, -7.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.3f));
        neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(24, 55).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-5.0f, (float)0.4363f, (float)-0.0873f, (float)0.0f));
        PartDefinition shoulderRight = bodyUpper.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(34, 0).addBox(-5.5f, 0.0f, -3.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6f, (float)-4.0f, (float)-2.1f, (float)0.1895f, (float)-0.1396f, (float)0.0286f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(45, 67).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)4.0f, (float)1.5f, (float)-0.3491f, (float)-0.1396f, (float)0.4427f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)0.0f, (float)-0.1745f, (float)0.1745f, (float)-0.1745f));
        PartDefinition shoulderLeft = bodyUpper.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(0, 29).addBox(-5.5f, 0.0f, -3.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-1.0f, (float)-2.0f, (float)0.1895f, (float)0.082f, (float)0.0286f));
        shoulderLeft.addOrReplaceChild("shoulderVine", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, 3.0f, -3.0f, 8.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.01f, (float)0.0f, (float)0.01f));
        PartDefinition armLeftUpper = shoulderLeft.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(28, 69).addBox(0.0f, 0.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.45f, (float)2.225f, (float)2.0f, (float)-0.1745f, (float)-0.1745f, (float)-0.1745f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(28, 69).addBox(-0.4875f, -0.0875f, -0.825f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)8.0f, (float)0.3f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition bodyUpperBranchLower = bodyUpper.addOrReplaceChild("bodyUpperBranchLower", CubeListBuilder.create().texOffs(12, 65).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.7f, (float)0.9f, (float)0.015f, (float)-0.0698f, (float)0.1595f));
        PartDefinition bodyUpperBranchCenter = bodyUpperBranchLower.addOrReplaceChild("bodyUpperBranchCenter", CubeListBuilder.create().texOffs(57, 67).addBox(-1.5f, -6.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.4f, (float)0.2f, (float)0.2768f, (float)0.0f, (float)-0.1023f));
        bodyUpperBranchCenter.addOrReplaceChild("bodyUpperTwigMain", CubeListBuilder.create().texOffs(0, 42).addBox(-0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.0f, (float)-0.8955f, (float)-0.5463f, (float)-0.197f));
        bodyUpperBranchCenter.addOrReplaceChild("bodyUpperLeavesLower", CubeListBuilder.create().texOffs(29, 33).addBox(-6.0f, -6.0f, -3.0f, 9.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.015f, (float)0.7854f, (float)-0.015f));
        PartDefinition bodyUpperBranchUpper = bodyUpperBranchCenter.addOrReplaceChild("bodyUpperBranchUpper", CubeListBuilder.create().texOffs(54, 14).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.4f, (float)0.2f, (float)0.2768f, (float)0.0f, (float)-0.1023f));
        PartDefinition bodyUpperLeavesCenter = bodyUpperBranchUpper.addOrReplaceChild("bodyUpperLeavesCenter", CubeListBuilder.create().texOffs(48, 55).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.4f, (float)-1.8f, (float)0.015f, (float)0.7854f, (float)-0.015f));
        bodyUpperLeavesCenter.addOrReplaceChild("bodyUpperLeavesUpper", CubeListBuilder.create().texOffs(24, 15).addBox(-5.0f, -6.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition thighRight = bodyBase.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(25, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.2f, (float)2.7875f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0873f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(28, 29).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.4f, (float)0.0f, (float)0.0873f, (float)-0.0873f, (float)0.0f));
        PartDefinition footRight = legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(68, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        footRight.addOrReplaceChild("soleRight", CubeListBuilder.create().texOffs(61, 42).addBox(-3.0f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.1f, (float)0.0f, (float)0.0f, (float)-1.7453f, (float)0.0f));
        PartDefinition thighLeft = bodyBase.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(66, 50).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8f, (float)3.4f, (float)-0.5f, (float)0.0f, (float)-0.0873f, (float)-0.0873f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)4.5f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0436f));
        PartDefinition footLeft = legLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(37, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.2f, (float)0.0f, (float)0.0873f, (float)0.0873f, (float)0.0873f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(42, 55).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.3f, (float)0.0f, (float)0.0873f, (float)0.0873f, (float)0.0436f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

