/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.JellyfishEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnderJellyfishModel
extends HierarchicalModel<JellyfishEntity> {
    public ModelPart root;
    public ModelPart body;
    public ModelPart bell;
    public ModelPart bellNorth;
    public ModelPart tentacleNorth;
    public ModelPart tentacleEast;
    public ModelPart bellSouth;
    public ModelPart tentacleSouth;
    public ModelPart tentacleWest;
    public ModelPart head;
    public ModelPart armOuterNorthEastUpper;
    public ModelPart armOuterNorthEastLower;
    public ModelPart armOuterSouthEastUpper;
    public ModelPart armOuterSouthEastLower;
    public ModelPart armOuterSouthWestUpper;
    public ModelPart armOuterSouthWestLower;
    public ModelPart armOuterNorthWestUpper;
    public ModelPart armOuterNorthWestLower;

    public EnderJellyfishModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.bell = this.body.getChild("bell");
        this.bellNorth = this.bell.getChild("bellNorth");
        this.tentacleNorth = this.bellNorth.getChild("tentacleNorth");
        this.tentacleEast = this.bell.getChild("tentacleEast");
        this.bellSouth = this.bell.getChild("bellSouth");
        this.tentacleSouth = this.bellSouth.getChild("tentacleSouth");
        this.tentacleWest = this.bell.getChild("tentacleWest");
        this.head = this.body.getChild("head");
        this.armOuterNorthEastUpper = this.head.getChild("armOuterNorthEastUpper");
        this.armOuterNorthEastLower = this.armOuterNorthEastUpper.getChild("armOuterNorthEastLower");
        this.armOuterSouthEastUpper = this.head.getChild("armOuterSouthEastUpper");
        this.armOuterSouthEastLower = this.armOuterSouthEastUpper.getChild("armOuterSouthEastLower");
        this.armOuterSouthWestUpper = this.head.getChild("armOuterSouthWestUpper");
        this.armOuterSouthWestLower = this.armOuterSouthWestUpper.getChild("armOuterSouthWestLower");
        this.armOuterNorthWestUpper = this.head.getChild("armOuterNorthWestUpper");
        this.armOuterNorthWestLower = this.armOuterNorthWestUpper.getChild("armOuterNorthWestLower");
    }

    public void setupAnim(JellyfishEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.swimAnim(pAgeInTicks);
    }

    public void swimAnim(float pAgeInTicks) {
        this.root.xScale = pAgeInTicks / 5.0f + 0.85f;
        this.root.yScale = -pAgeInTicks / 7.5f + 1.15f;
        this.root.zScale = pAgeInTicks / 5.0f + 0.85f;
        this.tentacleNorth.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.tentacleEast.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
        this.tentacleSouth.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
        this.tentacleWest.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.armOuterNorthEastUpper.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.armOuterNorthEastLower.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
        this.armOuterSouthEastUpper.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.armOuterSouthEastLower.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
        this.armOuterSouthWestUpper.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.armOuterSouthWestLower.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
        this.armOuterNorthWestUpper.xRot = -pAgeInTicks * IcariaMath.rad(11.25f) - IcariaMath.rad(11.25f);
        this.armOuterNorthWestLower.xRot = pAgeInTicks * IcariaMath.rad(11.25f) + IcariaMath.rad(11.25f);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition bell = body.addOrReplaceChild("bell", CubeListBuilder.create().texOffs(0, 30).addBox(-5.0f, -26.0f, -4.0f, 10.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)26.0f, (float)0.0f));
        PartDefinition bellNorth = bell.addOrReplaceChild("bellNorth", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -5.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-26.0f, (float)0.0f));
        bellNorth.addOrReplaceChild("tentacleNorth", CubeListBuilder.create().texOffs(32, 3).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)-4.5f));
        bell.addOrReplaceChild("tentacleEast", CubeListBuilder.create().texOffs(0, 3).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-24.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition bellSouth = bell.addOrReplaceChild("bellSouth", CubeListBuilder.create().texOffs(18, 0).addBox(-4.0f, 0.0f, 4.0f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-26.0f, (float)0.0f));
        bellSouth.addOrReplaceChild("tentacleSouth", CubeListBuilder.create().texOffs(48, 3).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)4.5f));
        bell.addOrReplaceChild("tentacleWest", CubeListBuilder.create().texOffs(16, 3).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-24.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 9).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition torso = head.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        torso.addOrReplaceChild("armInnerNorth", CubeListBuilder.create().texOffs(20, 20).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.2007f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("armInnerEast", CubeListBuilder.create().texOffs(8, 20).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2007f));
        torso.addOrReplaceChild("armInnerSouth", CubeListBuilder.create().texOffs(16, 20).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.2007f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("armInnerWest", CubeListBuilder.create().texOffs(12, 20).addBox(0.0f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0175f, (float)-0.2007f));
        PartDefinition armOuterNorthEastUpper = head.addOrReplaceChild("armOuterNorthEastUpper", CubeListBuilder.create().texOffs(0, 51).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)-0.1963f, (float)0.7854f, (float)0.0f));
        armOuterNorthEastUpper.addOrReplaceChild("armOuterNorthEastLower", CubeListBuilder.create().texOffs(0, 40).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.9f, (float)-1.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        PartDefinition armOuterSouthEastUpper = head.addOrReplaceChild("armOuterSouthEastUpper", CubeListBuilder.create().texOffs(4, 51).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.1963f, (float)2.3562f, (float)0.0f));
        armOuterSouthEastUpper.addOrReplaceChild("armOuterSouthEastLower", CubeListBuilder.create().texOffs(4, 40).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.9f, (float)-1.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        PartDefinition armOuterSouthWestUpper = head.addOrReplaceChild("armOuterSouthWestUpper", CubeListBuilder.create().texOffs(8, 51).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.1963f, (float)-2.3562f, (float)0.0f));
        armOuterSouthWestUpper.addOrReplaceChild("armOuterSouthWestLower", CubeListBuilder.create().texOffs(8, 40).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)11.9f, (float)-1.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        PartDefinition armOuterNorthWestUpper = head.addOrReplaceChild("armOuterNorthWestUpper", CubeListBuilder.create().texOffs(12, 51).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.1963f, (float)-0.7854f, (float)0.0f));
        armOuterNorthWestUpper.addOrReplaceChild("armOuterNorthWestLower", CubeListBuilder.create().texOffs(12, 40).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.9f, (float)-1.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

