/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FirForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyBase;
    public ModelPart bodyMain;
    public ModelPart bodyMainShroomLower;
    public ModelPart bodyLower;
    public ModelPart bodyMainShroomCenter;
    public ModelPart bodyCenter;
    public ModelPart bodyMainShroomUpper;
    public ModelPart bodyUpper;
    public ModelPart shoulderRight;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart shoulderLeft;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart neckMain;
    public ModelPart neckShroom;
    public ModelPart headMain;
    public ModelPart beardMain;
    public ModelPart beardUpper;
    public ModelPart beardCenter;
    public ModelPart beardLower;
    public ModelPart beardTip;
    public ModelPart shroomRightStem;
    public ModelPart shroomRightHead;
    public ModelPart shroomCenterStem;
    public ModelPart shroomCenterHead;
    public ModelPart shroomLeftStem;
    public ModelPart shroomLeftHead;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;
    public ModelPart kneeLeft;

    public FirForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyBase = this.root.getChild("bodyBase");
        this.bodyMain = this.bodyBase.getChild("bodyMain");
        this.bodyMainShroomLower = this.bodyMain.getChild("bodyMainShroomLower");
        this.bodyLower = this.bodyMain.getChild("bodyLower");
        this.bodyMainShroomCenter = this.bodyLower.getChild("bodyMainShroomCenter");
        this.bodyCenter = this.bodyLower.getChild("bodyCenter");
        this.bodyMainShroomUpper = this.bodyCenter.getChild("bodyMainShroomUpper");
        this.bodyUpper = this.bodyCenter.getChild("bodyUpper");
        this.shoulderRight = this.bodyUpper.getChild("shoulderRight");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.shoulderLeft = this.bodyUpper.getChild("shoulderLeft");
        this.armLeftUpper = this.shoulderLeft.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.neckMain = this.bodyUpper.getChild("neckMain");
        this.neckShroom = this.neckMain.getChild("neckShroom");
        this.headMain = this.neckMain.getChild("headMain");
        this.beardMain = this.headMain.getChild("beardMain");
        this.beardUpper = this.beardMain.getChild("beardUpper");
        this.beardCenter = this.beardUpper.getChild("beardCenter");
        this.beardLower = this.beardCenter.getChild("beardLower");
        this.beardTip = this.beardLower.getChild("beardTip");
        this.shroomRightStem = this.bodyUpper.getChild("shroomRightStem");
        this.shroomRightHead = this.shroomRightStem.getChild("shroomRightHead");
        this.shroomCenterStem = this.bodyUpper.getChild("shroomCenterStem");
        this.shroomCenterHead = this.shroomCenterStem.getChild("shroomCenterHead");
        this.shroomLeftStem = this.bodyUpper.getChild("shroomLeftStem");
        this.shroomLeftHead = this.shroomLeftStem.getChild("shroomLeftHead");
        this.thighRight = this.bodyBase.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyBase.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
        this.kneeLeft = this.legLeft.getChild("kneeLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.armRightUpper.xRot = -0.5236f;
        this.armRightUpper.zRot = 0.4427f;
        this.armLeftUpper.xRot = -0.3491f;
        this.armLeftUpper.zRot = -0.1373f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.armRightUpper.zRot -= f;
            this.armLeftUpper.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyMain, 0.1023f, 0.0436f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMainShroomLower, 0.015f, 0.7854f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLower, 0.1023f, 0.0436f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMainShroomCenter, 0.015f, -0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenter, 0.2768f, 0.0436f, -0.1023f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMainShroomUpper, 0.015f, 0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpper, 0.1895f, 0.0436f, -0.1023f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRight, 0.015f, -0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderLeft, 0.015f, 0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, -0.7704f, 0.0873f, -0.1895f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckShroom, 0.015f, 0.2276f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.beardUpper, 0.0586f, -0.1745f, -0.0586f, pAgeInTicks);
        this.wiggleRotateAngles(this.beardCenter, 0.0586f, -0.0873f, -0.0586f, pAgeInTicks);
        this.wiggleRotateAngles(this.beardLower, 0.0586f, -0.1745f, -0.0586f, pAgeInTicks);
        this.wiggleRotateAngles(this.beardTip, -0.0286f, -0.1745f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomRightStem, -0.5959f, -0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomRightHead, 0.015f, 0.2618f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomCenterStem, 0.015f, 0.3927f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomCenterHead, 0.015f, -0.1745f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomLeftStem, -0.1595f, 0.1745f, 0.3777f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomLeftHead, 0.015f, 0.7854f, -0.015f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) + 0.3491f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw) - 0.4363f;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.5236f;
        this.armRightLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.1023f;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.armLeftUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.3491f;
        this.armLeftLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.1023f;
        this.kneeLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyBase = partDefinition.addOrReplaceChild("bodyBase", CubeListBuilder.create().texOffs(42, 40).addBox(-6.5f, -1.0f, -2.5f, 13.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)4.0f, (float)1.7f, (float)-0.1595f, (float)0.0436f, (float)0.0723f));
        PartDefinition bodyMain = bodyBase.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(0, 66).addBox(-5.5f, -1.0f, -2.0f, 11.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)-4.0f, (float)-0.2f, (float)0.1023f, (float)0.0436f, (float)0.0723f));
        bodyMain.addOrReplaceChild("bodyMainShroomLower", CubeListBuilder.create().texOffs(73, 45).addBox(-2.5f, -1.0f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)2.0f, (float)0.0f, (float)0.015f, (float)0.7854f, (float)-0.015f));
        PartDefinition bodyLower = bodyMain.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(48, 51).addBox(-6.0f, -1.0f, -2.5f, 12.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)-5.0f, (float)-0.2f, (float)0.1023f, (float)0.0436f, (float)0.0723f));
        bodyLower.addOrReplaceChild("bodyMainShroomCenter", CubeListBuilder.create().texOffs(24, 57).addBox(-9.0f, -1.0f, -4.5f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)4.0f, (float)2.5f, (float)0.015f, (float)-0.3927f, (float)-0.015f));
        PartDefinition bodyCenter = bodyLower.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(32, 28).addBox(-6.5f, -1.0f, -3.0f, 13.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)-2.2f, (float)-1.5f, (float)0.2768f, (float)0.0436f, (float)-0.1023f));
        bodyCenter.addOrReplaceChild("bodyMainShroomUpper", CubeListBuilder.create().texOffs(50, 0).addBox(-9.0f, -1.0f, -4.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)-1.0f, (float)0.015f, (float)0.3927f, (float)-0.015f));
        bodyCenter.addOrReplaceChild("bodyMainVineMain", CubeListBuilder.create().texOffs(0, 14).addBox(-6.5f, -1.0f, -3.0f, 9.0f, 24.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.05f, (float)0.0f, (float)0.05f));
        PartDefinition bodyUpper = bodyCenter.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, -4.0f, 16.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4f, (float)-4.0f, (float)-0.5f, (float)0.1895f, (float)0.0436f, (float)-0.1023f));
        PartDefinition shoulderRight = bodyUpper.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(32, 14).addBox(-9.0f, -3.0f, -6.0f, 13.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)3.5f, (float)2.0f, (float)0.015f, (float)-0.3927f, (float)-0.015f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(54, 72).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-1.0f, (float)-2.0f, (float)-0.5236f, (float)0.0873f, (float)0.4427f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(40, 80).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)11.0f, (float)0.0f, (float)-0.1745f, (float)-0.0873f, (float)-0.1745f));
        PartDefinition shoulderLeft = bodyUpper.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(0, 45).addBox(0.0f, -3.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)4.0f, (float)0.5f, (float)0.015f, (float)0.3927f, (float)-0.015f));
        PartDefinition armLeftUpper = shoulderLeft.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(12, 75).addBox(-1.0f, 0.0f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.5f, (float)0.0f, (float)-0.3491f, (float)-0.5236f, (float)-0.1373f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(32, 80).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)7.0f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)0.1745f));
        PartDefinition neckMain = bodyUpper.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(21, 40).addBox(-2.5f, -5.0f, -9.5f, 5.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)5.0f, (float)-2.0f, (float)-0.7704f, (float)0.0873f, (float)-0.1895f));
        neckMain.addOrReplaceChild("neckShroom", CubeListBuilder.create().texOffs(68, 62).addBox(0.0f, -1.0f, -9.5f, 3.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-2.9f, (float)0.0f, (float)0.015f, (float)0.2276f, (float)-0.015f));
        PartDefinition headMain = neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(30, 66).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-6.5f, (float)0.3491f, (float)-0.4363f, (float)0.1745f));
        PartDefinition beardMain = headMain.addOrReplaceChild("beardMain", CubeListBuilder.create().texOffs(48, 62).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)4.05f, (float)-3.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition beardUpper = beardMain.addOrReplaceChild("beardUpper", CubeListBuilder.create().texOffs(72, 28).addBox(-3.0f, 0.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)1.0f, (float)0.0f, (float)0.0586f, (float)-0.1745f, (float)-0.0586f));
        PartDefinition beardCenter = beardUpper.addOrReplaceChild("beardCenter", CubeListBuilder.create().texOffs(79, 81).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1f, (float)2.0f, (float)0.0f, (float)0.0586f, (float)-0.0873f, (float)-0.0586f));
        PartDefinition beardLower = beardCenter.addOrReplaceChild("beardLower", CubeListBuilder.create().texOffs(32, 20).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)3.0f, (float)0.0f, (float)0.0586f, (float)-0.1745f, (float)-0.0586f));
        beardLower.addOrReplaceChild("beardTip", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)2.2f, (float)0.0f, (float)-0.0286f, (float)-0.1745f, (float)0.0286f));
        PartDefinition shroomRightStem = bodyUpper.addOrReplaceChild("shroomRightStem", CubeListBuilder.create().texOffs(82, 51).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)1.0f, (float)4.0f, (float)-0.5959f, (float)-0.3927f, (float)-0.015f));
        shroomRightStem.addOrReplaceChild("shroomRightHead", CubeListBuilder.create().texOffs(69, 10).addBox(-3.5f, -1.0f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.015f, (float)0.2618f, (float)-0.015f));
        PartDefinition shroomCenterStem = bodyUpper.addOrReplaceChild("shroomCenterStem", CubeListBuilder.create().texOffs(24, 78).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-1.0f, (float)0.015f, (float)0.3927f, (float)-0.015f));
        shroomCenterStem.addOrReplaceChild("shroomCenterHead", CubeListBuilder.create().texOffs(0, 56).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.015f, (float)-0.1745f, (float)-0.015f));
        PartDefinition shroomLeftStem = bodyUpper.addOrReplaceChild("shroomLeftStem", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)1.5f, (float)-1.0f, (float)-0.1595f, (float)0.1745f, (float)0.3777f));
        shroomLeftStem.addOrReplaceChild("shroomLeftHead", CubeListBuilder.create().texOffs(69, 18).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.015f, (float)0.7854f, (float)-0.015f));
        PartDefinition thighRight = bodyBase.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(0, 75).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0375f, (float)2.4125f, (float)0.025f, (float)-0.1023f, (float)0.0436f, (float)-0.0723f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(0, 53).addBox(-3.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)7.0f, (float)0.0f, (float)0.0873f, (float)-0.0873f, (float)0.0f));
        PartDefinition footRight = legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(15, 45).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)7.5f, (float)-0.5f, (float)0.1745f, (float)0.1745f, (float)0.0f));
        footRight.addOrReplaceChild("soleRight", CubeListBuilder.create().texOffs(73, 37).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition thighLeft = bodyBase.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(66, 74).addBox(0.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5125f, (float)2.9f, (float)-0.125f, (float)-0.1023f, (float)-0.1309f, (float)-0.0723f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(77, 0).addBox(0.0f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)5.0f, (float)0.0f, (float)0.0873f, (float)0.0873f, (float)0.0f));
        PartDefinition kneeLeft = legLeft.addOrReplaceChild("kneeLeft", CubeListBuilder.create().texOffs(24, 56).addBox(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)3.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft = kneeLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(41, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)4.4f, (float)0.0f, (float)0.0873f, (float)0.0873f, (float)0.0f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(25, 14).addBox(-2.0f, 0.0f, -1.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.7f, (float)3.0f, (float)-2.0f, (float)0.0f, (float)0.1745f, (float)0.0175f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

