/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.JellyfishEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FireJellyfishModel
extends HierarchicalModel<JellyfishEntity> {
    public ModelPart root;
    public ModelPart body;
    public ModelPart head;
    public ModelPart tentacleInnerSouthEastUpper;
    public ModelPart tentacleInnerNorthUpper;
    public ModelPart tentacleInnerSouthWestUpper;
    public ModelPart tentacleCenterNorthEastUpper;
    public ModelPart tentacleCenterSouthUpper;
    public ModelPart tentacleCenterNorthWestUpper;
    public ModelPart tentacleOuterNorthUpper;
    public ModelPart tentacleOuterNorthEastUpper;
    public ModelPart tentacleOuterSouthEastUpper;
    public ModelPart tentacleOuterSouthUpper;
    public ModelPart tentacleOuterSouthWestUpper;
    public ModelPart tentacleOuterNorthWestUpper;

    public FireJellyfishModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.tentacleInnerSouthEastUpper = this.head.getChild("tentacleInnerSouthEastUpper");
        this.tentacleInnerNorthUpper = this.head.getChild("tentacleInnerNorthUpper");
        this.tentacleInnerSouthWestUpper = this.head.getChild("tentacleInnerSouthWestUpper");
        this.tentacleCenterNorthEastUpper = this.head.getChild("tentacleCenterNorthEastUpper");
        this.tentacleCenterSouthUpper = this.head.getChild("tentacleCenterSouthUpper");
        this.tentacleCenterNorthWestUpper = this.head.getChild("tentacleCenterNorthWestUpper");
        this.tentacleOuterNorthUpper = this.head.getChild("tentacleOuterNorthUpper");
        this.tentacleOuterNorthEastUpper = this.head.getChild("tentacleOuterNorthEastUpper");
        this.tentacleOuterSouthEastUpper = this.head.getChild("tentacleOuterSouthEastUpper");
        this.tentacleOuterSouthUpper = this.head.getChild("tentacleOuterSouthUpper");
        this.tentacleOuterSouthWestUpper = this.head.getChild("tentacleOuterSouthWestUpper");
        this.tentacleOuterNorthWestUpper = this.head.getChild("tentacleOuterNorthWestUpper");
    }

    public void setupAnim(JellyfishEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.swimAnim(pAgeInTicks);
    }

    public void swimAnim(float pAgeInTicks) {
        this.root.xScale = pAgeInTicks / 5.0f + 0.85f;
        this.root.yScale = -pAgeInTicks / 7.5f + 1.15f;
        this.root.zScale = pAgeInTicks / 5.0f + 0.85f;
        this.tentacleInnerSouthEastUpper.xRot = pAgeInTicks * IcariaMath.rad(10.0f) + IcariaMath.rad(10.0f);
        this.tentacleInnerNorthUpper.xRot = pAgeInTicks * IcariaMath.rad(10.0f) + IcariaMath.rad(10.0f);
        this.tentacleInnerSouthWestUpper.xRot = pAgeInTicks * IcariaMath.rad(10.0f) + IcariaMath.rad(10.0f);
        this.tentacleCenterNorthEastUpper.xRot = pAgeInTicks * IcariaMath.rad(15.0f) + IcariaMath.rad(15.0f);
        this.tentacleCenterSouthUpper.xRot = pAgeInTicks * IcariaMath.rad(15.0f) + IcariaMath.rad(15.0f);
        this.tentacleCenterNorthWestUpper.xRot = pAgeInTicks * IcariaMath.rad(15.0f) + IcariaMath.rad(15.0f);
        this.tentacleOuterNorthUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
        this.tentacleOuterNorthEastUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
        this.tentacleOuterSouthEastUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
        this.tentacleOuterSouthUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
        this.tentacleOuterSouthWestUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
        this.tentacleOuterNorthWestUpper.xRot = pAgeInTicks * IcariaMath.rad(20.0f) + IcariaMath.rad(20.0f);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bell = body.addOrReplaceChild("bell", CubeListBuilder.create().texOffs(0, 34).addBox(-6.0f, -26.0f, -6.0f, 12.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bell.addOrReplaceChild("bellNorth", CubeListBuilder.create().texOffs(16, 24).addBox(-5.5f, 0.0f, -0.5f, 11.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-24.0f, (float)-5.5f));
        bell.addOrReplaceChild("bellEast", CubeListBuilder.create().texOffs(0, 16).addBox(-5.5f, 0.0f, -0.5f, 11.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)-24.0f, (float)0.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        bell.addOrReplaceChild("bellSouth", CubeListBuilder.create().texOffs(16, 10).addBox(-5.5f, 0.0f, -0.5f, 11.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-24.0f, (float)5.5f));
        bell.addOrReplaceChild("bellWest", CubeListBuilder.create().texOffs(32, 16).addBox(-5.5f, 0.0f, -0.5f, 11.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-24.0f, (float)-0.5f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(48, 48).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition tentacleInnerSouthEastUpper = head.addOrReplaceChild("tentacleInnerSouthEastUpper", CubeListBuilder.create().texOffs(4, 48).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)4.9742f, (float)0.0f));
        tentacleInnerSouthEastUpper.addOrReplaceChild("tentacleInnerSouthEastLower", CubeListBuilder.create().texOffs(4, 56).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleInnerNorthUpper = head.addOrReplaceChild("tentacleInnerNorthUpper", CubeListBuilder.create().texOffs(2, 48).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)2.8798f, (float)0.0f));
        tentacleInnerNorthUpper.addOrReplaceChild("tentacleInnerNorthLower", CubeListBuilder.create().texOffs(2, 56).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleInnerSouthWestUpper = head.addOrReplaceChild("tentacleInnerSouthWestUpper", CubeListBuilder.create().texOffs(0, 48).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.7854f, (float)0.0f));
        tentacleInnerSouthWestUpper.addOrReplaceChild("tentacleInnerSouthWestLower", CubeListBuilder.create().texOffs(0, 56).addBox(-0.5f, 0.0f, 0.5f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleCenterNorthEastUpper = head.addOrReplaceChild("tentacleCenterNorthEastUpper", CubeListBuilder.create().texOffs(10, 48).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)-2.3562f, (float)0.0f));
        tentacleCenterNorthEastUpper.addOrReplaceChild("tentacleCenterNorthEastLower", CubeListBuilder.create().texOffs(10, 55).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleCenterSouthUpper = head.addOrReplaceChild("tentacleCenterSouthUpper", CubeListBuilder.create().texOffs(6, 48).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)-0.2618f, (float)0.0f));
        tentacleCenterSouthUpper.addOrReplaceChild("tentacleCenterSouthLower", CubeListBuilder.create().texOffs(6, 55).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleCenterNorthWestUpper = head.addOrReplaceChild("tentacleCenterNorthWestUpper", CubeListBuilder.create().texOffs(8, 48).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)1.8326f, (float)0.0f));
        tentacleCenterNorthWestUpper.addOrReplaceChild("tentacleCenterNorthWestLower", CubeListBuilder.create().texOffs(8, 55).addBox(-0.5f, 0.0f, 0.75f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterNorthUpper = head.addOrReplaceChild("tentacleOuterNorthUpper", CubeListBuilder.create().texOffs(18, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-3.0107f, (float)0.0f));
        tentacleOuterNorthUpper.addOrReplaceChild("tentacleOuterNorthLower", CubeListBuilder.create().texOffs(18, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterNorthEastUpper = head.addOrReplaceChild("tentacleOuterNorthEastUpper", CubeListBuilder.create().texOffs(20, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-1.7017f, (float)0.0f));
        tentacleOuterNorthEastUpper.addOrReplaceChild("tentacleOuterNorthEastLower", CubeListBuilder.create().texOffs(20, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterSouthEastUpper = head.addOrReplaceChild("tentacleOuterSouthEastUpper", CubeListBuilder.create().texOffs(22, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.9163f, (float)0.0f));
        tentacleOuterSouthEastUpper.addOrReplaceChild("tentacleOuterSouthEastLower", CubeListBuilder.create().texOffs(22, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterSouthUpper = head.addOrReplaceChild("tentacleOuterSouthUpper", CubeListBuilder.create().texOffs(12, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.3927f, (float)0.0f));
        tentacleOuterSouthUpper.addOrReplaceChild("tentacleOuterSouthLower", CubeListBuilder.create().texOffs(12, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterSouthWestUpper = head.addOrReplaceChild("tentacleOuterSouthWestUpper", CubeListBuilder.create().texOffs(14, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)1.1781f, (float)0.0f));
        tentacleOuterSouthWestUpper.addOrReplaceChild("tentacleOuterSouthWestLower", CubeListBuilder.create().texOffs(14, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleOuterNorthWestUpper = head.addOrReplaceChild("tentacleOuterNorthWestUpper", CubeListBuilder.create().texOffs(16, 48).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)2.4871f, (float)0.0f));
        tentacleOuterNorthWestUpper.addOrReplaceChild("tentacleOuterNorthWestLower", CubeListBuilder.create().texOffs(16, 54).addBox(-0.5f, 0.0f, 1.0f, 1.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

