/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.SnullEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForestSnullModel
extends HierarchicalModel<SnullEntity> {
    public ModelPart root;
    public ModelPart bodyFront;
    public ModelPart bodyFrontLower;
    public ModelPart bodyFrontCenter;
    public ModelPart bodyFrontUpper;
    public ModelPart head;
    public ModelPart headFeelerRight;
    public ModelPart headFeelerLeft;
    public ModelPart bodySkull;
    public ModelPart skullFeelerRight;
    public ModelPart skullFeelerLeft;

    public ForestSnullModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyFront = this.root.getChild("bodyFront");
        this.bodyFrontLower = this.bodyFront.getChild("bodyFrontLower");
        this.bodyFrontCenter = this.bodyFrontLower.getChild("bodyFrontCenter");
        this.bodyFrontUpper = this.bodyFrontCenter.getChild("bodyFrontUpper");
        this.head = this.bodyFrontUpper.getChild("head");
        this.headFeelerRight = this.head.getChild("headFeelerRight");
        this.headFeelerLeft = this.head.getChild("headFeelerLeft");
        this.bodySkull = this.root.getChild("bodySkull");
        this.skullFeelerRight = this.bodySkull.getChild("skullFeelerRight");
        this.skullFeelerLeft = this.bodySkull.getChild("skullFeelerLeft");
    }

    public void setupAnim(SnullEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idleAnim(pAgeInTicks);
        this.animate(pEntity.hideAnimationState, IcariaAnimations.FOREST_SNULL_HIDE, pAgeInTicks);
        this.animate(pEntity.hurtAnimationState, IcariaAnimations.FOREST_SNULL_HURT, pAgeInTicks);
        this.animate(pEntity.idleAnimationState, IcariaAnimations.FOREST_SNULL_IDLE, pAgeInTicks);
        this.animate(pEntity.moveAnimationState, IcariaAnimations.FOREST_SNULL_MOVE, pAgeInTicks);
        this.animate(pEntity.showAnimationState, IcariaAnimations.FOREST_SNULL_SHOW, pAgeInTicks);
    }

    public void idleAnim(float pAgeInTicks) {
        this.headFeelerRight.xRot = Mth.sin((float)(pAgeInTicks * 0.05f + 1.0f)) * 0.075f + 0.2618f;
        this.headFeelerRight.zRot = Mth.cos((float)(pAgeInTicks * 0.075f + 2.0f)) * 0.075f + 0.7854f;
        this.headFeelerLeft.xRot = -Mth.sin((float)(pAgeInTicks * 0.05f + 3.0f)) * 0.075f + 0.2618f;
        this.headFeelerLeft.zRot = -Mth.cos((float)(pAgeInTicks * 0.075f + 4.0f)) * 0.075f - 0.7854f;
        this.skullFeelerRight.xRot = Mth.sin((float)(pAgeInTicks * 0.05f + 1.0f)) * 0.075f - 0.2618f;
        this.skullFeelerRight.yRot = Mth.cos((float)(pAgeInTicks * 0.075f + 2.0f)) * 0.075f + 0.1745f;
        this.skullFeelerLeft.xRot = -Mth.sin((float)(pAgeInTicks * 0.05f + 3.0f)) * 0.075f - 0.2618f;
        this.skullFeelerLeft.yRot = -Mth.cos((float)(pAgeInTicks * 0.075f + 4.0f)) * 0.075f - 0.1745f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyFront = partDefinition.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(0, 28).addBox(-2.5f, -4.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-4.0f));
        PartDefinition bodyFrontLower = bodyFront.addOrReplaceChild("bodyFrontLower", CubeListBuilder.create().texOffs(33, 38).addBox(-2.49f, -4.0f, -3.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFrontCenter = bodyFrontLower.addOrReplaceChild("bodyFrontCenter", CubeListBuilder.create().texOffs(36, 31).addBox(-2.48f, -4.0f, -3.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFrontUpper = bodyFrontCenter.addOrReplaceChild("bodyFrontUpper", CubeListBuilder.create().texOffs(0, 36).addBox(-2.47f, -4.0f, -3.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        bodyFrontUpper.addOrReplaceChild("bodyFrontShroomLower", CubeListBuilder.create().texOffs(40, 17).addBox(-6.47f, -2.5f, -1.0f, 7.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.1745f));
        bodyFrontUpper.addOrReplaceChild("bodyFrontShroomCenter", CubeListBuilder.create().texOffs(20, 10).addBox(-7.77f, -2.5f, -1.0f, 8.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.3927f, (float)0.0873f));
        bodyFrontUpper.addOrReplaceChild("bodyFrontShroomUpper", CubeListBuilder.create().texOffs(42, 8).addBox(-6.97f, -2.5f, -1.0f, 7.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition head = bodyFrontUpper.addOrReplaceChild("head", CubeListBuilder.create().texOffs(27, 0).addBox(-2.46f, 0.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-3.0f, (float)0.1963f, (float)0.0f, (float)0.0f));
        PartDefinition headFeelerRight = head.addOrReplaceChild("headFeelerRight", CubeListBuilder.create().texOffs(46, 23).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)3.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.7854f));
        headFeelerRight.addOrReplaceChild("headEyeRight", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headFeelerLeft = head.addOrReplaceChild("headFeelerLeft", CubeListBuilder.create().texOffs(12, 46).addBox(-0.5f, -0.5f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)3.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)-0.7854f));
        headFeelerLeft.addOrReplaceChild("headEyeLeft", CubeListBuilder.create().texOffs(0, 10).addBox(-1.0f, -1.0f, -5.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenter = partDefinition.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 10).addBox(-3.0f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bodyCenter.addOrReplaceChild("vine", CubeListBuilder.create().texOffs(0, 15).addBox(-3.01f, -5.0f, -1.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenterShroomFront = partDefinition.addOrReplaceChild("bodyCenterShroomFront", CubeListBuilder.create().texOffs(24, 39).addBox(-2.5f, 0.0f, -1.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)19.25f, (float)-4.0f));
        bodyCenterShroomFront.addOrReplaceChild("bodyCenterShroomFrontTip", CubeListBuilder.create().texOffs(20, 16).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition bodyCenterShroomRight = partDefinition.addOrReplaceChild("bodyCenterShroomRight", CubeListBuilder.create().texOffs(18, 29).addBox(0.0f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)22.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        bodyCenterShroomRight.addOrReplaceChild("bodyCenterShroomRightHat", CubeListBuilder.create().texOffs(0, 43).addBox(-2.25f, -5.5f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.1745f));
        PartDefinition bodyCenterShroomLeftFront = partDefinition.addOrReplaceChild("bodyCenterShroomLeftFront", CubeListBuilder.create().texOffs(44, 40).addBox(2.5f, -2.5f, -6.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bodyCenterShroomLeftFront.addOrReplaceChild("bodyCenterShroomLeftFrontTip", CubeListBuilder.create().texOffs(41, 0).addBox(4.5f, -2.5f, -5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bodyCenterShroomLeftFront.addOrReplaceChild("bodyCenterShroomLeftFrontTop", CubeListBuilder.create().texOffs(18, 46).addBox(2.5f, -3.5f, -5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenterShroomLeftRear = partDefinition.addOrReplaceChild("bodyCenterShroomLeftRear", CubeListBuilder.create().texOffs(32, 10).addBox(2.0f, -2.0f, 0.0f, 2.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bodyCenterShroomLeftRear.addOrReplaceChild("bodyCenterShroomLeftRearTip", CubeListBuilder.create().texOffs(40, 46).addBox(4.0f, -2.0f, 1.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bodyCenterShroomLeftRear.addOrReplaceChild("bodyCenterShroomLeftRearTop", CubeListBuilder.create().texOffs(0, 59).addBox(2.0f, -3.0f, 1.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodySkull = partDefinition.addOrReplaceChild("bodySkull", CubeListBuilder.create().texOffs(22, 17).addBox(-2.99f, -9.0f, 0.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition skullFeelerRight = bodySkull.addOrReplaceChild("skullFeelerRight", CubeListBuilder.create().texOffs(34, 45).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-4.5f, (float)0.0f, (float)-0.2618f, (float)0.1745f, (float)0.0f));
        skullFeelerRight.addOrReplaceChild("skullEyeRight", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition skullFeelerLeft = bodySkull.addOrReplaceChild("skullFeelerLeft", CubeListBuilder.create().texOffs(45, 0).addBox(-0.5f, -0.5f, -3.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.5f, (float)0.0f, (float)-0.2618f, (float)-0.1745f, (float)0.0f));
        skullFeelerLeft.addOrReplaceChild("skullEyeLeft", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -5.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = partDefinition.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(18, 31).addBox(-2.5f, -4.0f, 0.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)4.0f));
        PartDefinition bodyRearFront = bodyRear.addOrReplaceChild("bodyRearFront", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, -3.99f, 0.0f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)0.0f, (float)4.0f));
        PartDefinition bodyRearCenter = bodyRearFront.addOrReplaceChild("bodyRearCenter", CubeListBuilder.create().texOffs(12, 39).addBox(-2.0f, -3.01f, -0.2f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0087f, (float)0.0f));
        bodyRearCenter.addOrReplaceChild("bodyRearTail", CubeListBuilder.create().texOffs(46, 46).addBox(-1.6f, -2.0f, 0.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition bodyRearShroom = partDefinition.addOrReplaceChild("bodyRearShroom", CubeListBuilder.create().texOffs(26, 44).addBox(-0.5f, -10.8f, 0.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)6.0f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        bodyRearShroom.addOrReplaceChild("bodyRearShroomHat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -1.0f, -4.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-10.8f, (float)1.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

