/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LaurelForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyMain;
    public ModelPart bodyMainLeavesMain;
    public ModelPart bodyLower;
    public ModelPart bodyCenter;
    public ModelPart bodyUpper;
    public ModelPart bodyUpperLeavesUpper;
    public ModelPart bodyUpperLeavesLower;
    public ModelPart shoulderRight;
    public ModelPart shoulderVine;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart shoulderLeft;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart neckMain;
    public ModelPart headMain;
    public ModelPart headMainLeavesLower;
    public ModelPart headMainLeavesUpper;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;

    public LaurelForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyMain = this.root.getChild("bodyMain");
        this.bodyMainLeavesMain = this.bodyMain.getChild("bodyMainLeavesMain");
        this.bodyLower = this.bodyMain.getChild("bodyLower");
        this.bodyCenter = this.bodyLower.getChild("bodyCenter");
        this.bodyUpper = this.bodyCenter.getChild("bodyUpper");
        this.bodyUpperLeavesUpper = this.bodyUpper.getChild("bodyUpperLeavesUpper");
        this.bodyUpperLeavesLower = this.bodyUpperLeavesUpper.getChild("bodyUpperLeavesLower");
        this.shoulderRight = this.bodyUpper.getChild("shoulderRight");
        this.shoulderVine = this.shoulderRight.getChild("shoulderVine");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.shoulderLeft = this.bodyUpper.getChild("shoulderLeft");
        this.armLeftUpper = this.shoulderLeft.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.neckMain = this.bodyUpper.getChild("neckMain");
        this.headMain = this.neckMain.getChild("headMain");
        this.headMainLeavesLower = this.headMain.getChild("headMainLeavesLower");
        this.headMainLeavesUpper = this.headMainLeavesLower.getChild("headMainLeavesUpper");
        this.thighRight = this.bodyMain.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyMain.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.armRightUpper.xRot = -0.2731f;
        this.armRightUpper.zRot = 0.1867f;
        this.armLeftUpper.xRot = -0.1499f;
        this.armLeftUpper.zRot = -0.7481f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.armRightUpper.zRot -= f;
            this.armLeftUpper.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyMainLeavesMain, 0.1061f, 0.0f, 0.7591f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLower, 0.015f, 0.0698f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenter, 0.1023f, 0.0698f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpper, 0.1023f, 0.0698f, 0.0286f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeavesUpper, 0.2768f, -0.0785f, 0.1159f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeavesLower, 0.3641f, -0.0349f, 0.5313f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRight, 0.0499f, -0.0456f, -0.0586f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderLeft, 0.0812f, 0.0767f, 0.2951f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, 0.9319f, -0.2191f, -0.0826f, pAgeInTicks);
        this.wiggleRotateAngles(this.headMainLeavesLower, 0.015f, 0.0f, 0.0548f, pAgeInTicks);
        this.wiggleRotateAngles(this.headMainLeavesUpper, 0.1517f, 0.0f, -0.1517f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) - 0.9163f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.2731f;
        this.armRightLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.1367f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.0873f;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.armLeftUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.1499f;
        this.armLeftLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.182f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.0873f;
        this.legLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyMain = partDefinition.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(38, 0).addBox(-5.5f, 0.0f, -2.5f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        bodyMain.addOrReplaceChild("bodyMainLeavesMain", CubeListBuilder.create().texOffs(24, 51).addBox(-5.0f, -4.0f, -3.75f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.8f, (float)0.7f, (float)0.1061f, (float)0.0f, (float)0.7591f));
        PartDefinition bodyLower = bodyMain.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(52, 32).addBox(-5.0f, -4.0f, -2.0f, 10.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)0.015f, (float)0.0698f, (float)0.0286f));
        PartDefinition bodyCenter = bodyLower.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(23, 42).addBox(-5.5f, -4.0f, -2.5f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.1023f, (float)0.0698f, (float)0.0286f));
        PartDefinition bodyUpper = bodyCenter.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(24, 22).addBox(-6.0f, -4.0f, -3.0f, 12.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.1023f, (float)0.0698f, (float)0.0286f));
        PartDefinition bodyUpperLeavesUpper = bodyUpper.addOrReplaceChild("bodyUpperLeavesUpper", CubeListBuilder.create().texOffs(0, 12).addBox(1.5f, -4.0f, -4.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0375f, (float)-5.8125f, (float)-0.8125f, (float)0.2768f, (float)-0.0785f, (float)0.1159f));
        bodyUpperLeavesUpper.addOrReplaceChild("bodyUpperLeavesLower", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, -4.0f, -4.0f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.2f, (float)-1.0f, (float)-1.5f, (float)0.3641f, (float)-0.0349f, (float)0.5313f));
        PartDefinition shoulderRight = bodyUpper.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -4.0f, -3.5f, 12.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)0.2f, (float)0.0499f, (float)-0.0456f, (float)-0.0586f));
        PartDefinition shoulderRightShroomBase = shoulderRight.addOrReplaceChild("shoulderRightShroomBase", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-25.0f, (float)10.525f, (float)-6.55f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition shoulderRightShroomMain = shoulderRightShroomBase.addOrReplaceChild("shoulderRightShroomMain", CubeListBuilder.create().texOffs(59, 9).addBox(-9.5f, -14.0f, 12.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        shoulderRightShroomMain.addOrReplaceChild("shoulderRightShroomFront", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        shoulderRightShroomMain.addOrReplaceChild("shoulderRightShroomRear", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(46, 59).addBox(-2.0219f, -0.0499f, -1.4592f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.8625f, (float)-2.6f, (float)0.0875f, (float)-0.2731f, (float)-0.1367f, (float)0.1867f));
        PartDefinition armRightShroomBase = armRightUpper.addOrReplaceChild("armRightShroomBase", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-18.0219f, (float)18.4876f, (float)-6.7592f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition armRightShroomMain = armRightShroomBase.addOrReplaceChild("armRightShroomMain", CubeListBuilder.create().texOffs(65, 0).addBox(-8.8f, -13.0f, 14.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armRightShroomMain.addOrReplaceChild("armRightShroomFront", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armRightShroomMain.addOrReplaceChild("armRightShroomRear", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(14, 75).addBox(-0.975f, -1.0f, -1.5625f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5219f, (float)13.2501f, (float)0.5408f, (float)-0.1367f, (float)-0.0456f, (float)-0.182f));
        shoulderRight.addOrReplaceChild("shoulderVine", CubeListBuilder.create().texOffs(0, 51).addBox(-7.0f, 0.0f, 0.0f, 12.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)3.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition shoulderLeft = bodyUpper.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(30, 12).addBox(-2.0f, -4.0f, -2.5f, 12.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.4311f, (float)-3.2741f, (float)0.237f, (float)0.0812f, (float)0.0767f, (float)0.2951f));
        PartDefinition armLeftUpper = shoulderLeft.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(33, 72).addBox(-1.6843f, -1.5413f, -1.3765f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.8561f, (float)-1.8509f, (float)-0.162f, (float)-0.1499f, (float)0.0246f, (float)-0.7481f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(22, 75).addBox(0.25f, 0.0f, -1.2375f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.1843f, (float)6.4587f, (float)0.6235f, (float)-0.182f, (float)0.0911f, (float)0.2731f));
        PartDefinition neckMain = bodyUpper.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(20, 65).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0739f, (float)-6.4566f, (float)-0.6978f, (float)0.9319f, (float)-0.2191f, (float)-0.0826f));
        PartDefinition headMain = neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(49, 45).addBox(-3.0f, -3.5f, -6.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition headMainLeavesLower = headMain.addOrReplaceChild("headMainLeavesLower", CubeListBuilder.create().texOffs(28, 32).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.2f, (float)-3.0f, (float)0.015f, (float)0.0f, (float)0.0548f));
        headMainLeavesLower.addOrReplaceChild("headMainLeavesUpper", CubeListBuilder.create().texOffs(58, 15).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.1f, (float)0.0f, (float)0.1517f, (float)0.0f, (float)-0.1517f));
        PartDefinition thighRight = bodyMain.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(67, 40).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)3.7f, (float)0.0f, (float)-0.0873f, (float)0.0911f, (float)0.0f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(73, 48).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.9f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition footRight = legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(0, 67).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.6f, (float)0.0f, (float)0.0873f, (float)-0.0911f, (float)0.0f));
        footRight.addOrReplaceChild("soleRight", CubeListBuilder.create().texOffs(0, 43).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.1f, (float)0.0f, (float)0.0f, (float)0.1367f, (float)0.0f));
        PartDefinition thighLeft = bodyMain.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(58, 66).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)3.7f, (float)0.0f, (float)-0.0873f, (float)-0.0911f, (float)-0.0873f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(71, 73).addBox(-1.5f, 0.5f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition footLeft = legLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(60, 23).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.6f, (float)0.0f, (float)0.0873f, (float)-0.0911f, (float)0.0436f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(58, 59).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.1f, (float)0.0f, (float)0.0f, (float)0.1367f, (float)0.0436f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

