/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.MyrmekeQueenEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MyrmekeQueenModel
extends HierarchicalModel<MyrmekeQueenEntity> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart body;
    public ModelPart legRightFront;
    public ModelPart legLeftFront;
    public ModelPart legRightCenter;
    public ModelPart legLeftCenter;
    public ModelPart legRightRear;
    public ModelPart legLeftRear;

    public MyrmekeQueenModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legRightCenter = this.root.getChild("legRightCenter");
        this.legLeftCenter = this.root.getChild("legLeftCenter");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legLeftRear = this.root.getChild("legLeftRear");
    }

    public void setupAnim(MyrmekeQueenEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = IcariaMath.rad(pHeadPitch) + 0.2618f;
        this.head.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float f0 = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 0.0f)) * 0.4f * pLimbSwingAmount;
        float f1 = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + (float)Math.PI)) * 0.4f * pLimbSwingAmount;
        float f2 = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 1.5707964f)) * 0.4f * pLimbSwingAmount;
        float f3 = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 4.712389f)) * 0.4f * pLimbSwingAmount;
        float f4 = Mth.abs((float)(Mth.sin((float)(pLimbSwing * 0.6f + 0.0f)) * 0.4f)) * pLimbSwingAmount;
        float f5 = Mth.abs((float)(Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.4f)) * pLimbSwingAmount;
        float f6 = Mth.abs((float)(Mth.sin((float)(pLimbSwing * 0.6f + 1.5707964f)) * 0.4f)) * pLimbSwingAmount;
        float f7 = Mth.abs((float)(Mth.sin((float)(pLimbSwing * 0.6f + 4.712389f)) * 0.4f)) * pLimbSwingAmount;
        this.legRightFront.yRot = f3 + 2.2253f;
        this.legLeftFront.yRot = -f4 + 0.829f;
        this.legRightCenter.yRot = f1 + 3.1416f;
        this.legLeftCenter.yRot = -f2;
        this.legRightRear.yRot = f0 - 2.618f;
        this.legLeftRear.yRot = -f1 - 0.4363f;
        this.legRightFront.zRot = f7;
        this.legLeftFront.zRot = -f0;
        this.legRightCenter.zRot = f5;
        this.legLeftCenter.zRot = -f6;
        this.legRightRear.zRot = f4;
        this.legLeftRear.zRot = -f5;
    }

    public void translateToHead(PoseStack pPoseStack) {
        this.head.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 21).addBox(-3.0f, -1.0f, -2.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(42, 15).addBox(-2.99f, 0.0f, -6.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 26).addBox(-3.5f, -0.5f, -4.0f, 7.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-6.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("forehead", CubeListBuilder.create().texOffs(44, 10).addBox(-3.01f, -1.9201f, -0.897f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.01f)).texOffs(50, 5).addBox(-1.0f, -1.9093f, -1.3681f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3033f, (float)-3.6881f, (float)-1.3526f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("toothRight", CubeListBuilder.create().texOffs(36, 27).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)1.3f, (float)-6.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        head.addOrReplaceChild("toothLeft", CubeListBuilder.create().texOffs(23, 37).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)1.3f, (float)-6.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        head.addOrReplaceChild("antennaRight", CubeListBuilder.create().texOffs(19, 37).addBox(-0.5f, -4.5f, -1.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 17).addBox(-0.5f, -4.5f, -5.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.3f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)-0.4363f));
        head.addOrReplaceChild("antennaLeft", CubeListBuilder.create().texOffs(15, 37).addBox(-0.5f, -4.5f, -1.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 26).addBox(-0.5f, -4.5f, -5.5f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.3f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.4363f));
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(42, 5).addBox(-1.5f, -1.7f, -1.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 36).addBox(-2.0f, -2.2f, 0.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(13, 8).addBox(-3.0f, -0.5f, 0.2f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(13, 0).addBox(-3.0f, -0.5f, 2.5f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 17).addBox(-2.5f, -0.701f, 4.8f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 29).addBox(-1.5f, -1.7f, 4.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.2f, (float)-4.0f));
        body.addOrReplaceChild("neckUpper", CubeListBuilder.create().texOffs(22, 32).addBox(-1.999f, 0.8727f, -1.5469f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.9539f, (float)-0.6313f, (float)0.2182f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("neckLower", CubeListBuilder.create().texOffs(32, 16).addBox(-2.001f, 1.6481f, -0.0735f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-1.9539f, (float)-0.6313f, (float)-0.7418f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("shoulderRightFront", CubeListBuilder.create().texOffs(57, 0).addBox(-2.9517f, -2.5942f, -5.2266f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.999f, (float)0.6942f, (float)-0.2048f, (float)0.0f, (float)1.0908f, (float)0.0f));
        body.addOrReplaceChild("shoulderLeftFront", CubeListBuilder.create().texOffs(53, 0).addBox(-1.7414f, -2.5942f, 1.8677f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.999f, (float)0.6942f, (float)-0.2048f, (float)0.0f, (float)-1.0908f, (float)0.0f));
        body.addOrReplaceChild("shoulderRightRear", CubeListBuilder.create().texOffs(47, 0).addBox(0.9597f, -2.5942f, 6.2627f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.999f, (float)0.6942f, (float)-0.2048f, (float)0.0f, (float)-1.0908f, (float)0.0f));
        body.addOrReplaceChild("shoulderLeftRear", CubeListBuilder.create().texOffs(41, 0).addBox(-6.6527f, -2.5942f, -0.8316f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.999f, (float)0.6942f, (float)-0.2048f, (float)0.0f, (float)1.0908f, (float)0.0f));
        body.addOrReplaceChild("back", CubeListBuilder.create().texOffs(21, 23).addBox(-1.499f, -5.8955f, -6.9095f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.8f, (float)10.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 33).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 46).addBox(-3.001f, 1.7929f, 1.2929f, 6.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-3.0f, -1.9142f, 0.3f, 6.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.3f, (float)7.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(23, 41).addBox(-3.002f, 0.4142f, -1.2929f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)2.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tailRearUpper", CubeListBuilder.create().texOffs(21, 47).addBox(-2.997f, -4.3f, 2.1922f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)5.5f, (float)-0.48f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tailRearLower", CubeListBuilder.create().texOffs(21, 43).addBox(-2.978f, -2.0698f, 3.0742f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.02f, (float)1.1921f, (float)4.5831f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFront = partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)19.7f, (float)-2.8f, (float)0.0f, (float)2.2253f, (float)0.0f));
        PartDefinition legRightFrontUpper = legRightFront.addOrReplaceChild("legRightFrontUpper", CubeListBuilder.create().texOffs(27, 7).addBox(-0.5f, -0.3f, -0.3f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legRightFrontCenter = legRightFrontUpper.addOrReplaceChild("legRightFrontCenter", CubeListBuilder.create().texOffs(27, 0).addBox(0.6025f, -0.614f, -0.301f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legRightFrontCenter.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(7, 35).addBox(-0.2889f, -0.8f, -0.298f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition legLeftFront = partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create(), PartPose.offsetAndRotation((float)3.0f, (float)19.7f, (float)-2.8f, (float)0.0f, (float)0.829f, (float)0.0f));
        PartDefinition legLeftFrontUpper = legLeftFront.addOrReplaceChild("legLeftFrontUpper", CubeListBuilder.create().texOffs(0, 31).addBox(-0.5f, -0.3f, -0.3f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legLeftFrontCenter = legLeftFrontUpper.addOrReplaceChild("legLeftFrontCenter", CubeListBuilder.create().texOffs(29, 30).addBox(0.6025f, -0.614f, -0.301f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legLeftFrontCenter.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(7, 37).addBox(-0.2889f, -0.8f, -0.298f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition legRightCenter = partDefinition.addOrReplaceChild("legRightCenter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)19.7f, (float)-0.5f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition legRightCenterUpper = legRightCenter.addOrReplaceChild("legRightCenterUpper", CubeListBuilder.create().texOffs(30, 4).addBox(-0.5f, -0.3f, 0.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legRightCenterCenter = legRightCenterUpper.addOrReplaceChild("legRightCenterCenter", CubeListBuilder.create().texOffs(18, 29).addBox(0.6025f, -0.614f, -0.001f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legRightCenterCenter.addOrReplaceChild("legRightCenterLower", CubeListBuilder.create().texOffs(31, 35).addBox(-0.2889f, -0.8f, 0.002f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition legLeftCenter = partDefinition.addOrReplaceChild("legLeftCenter", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)19.7f, (float)-0.5f));
        PartDefinition legLeftCenterUpper = legLeftCenter.addOrReplaceChild("legLeftCenterUpper", CubeListBuilder.create().texOffs(30, 24).addBox(-0.5f, -0.3f, 0.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legLeftCenterCenter = legLeftCenterUpper.addOrReplaceChild("legLeftCenterCenter", CubeListBuilder.create().texOffs(30, 22).addBox(0.6025f, -0.614f, -0.001f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legLeftCenterCenter.addOrReplaceChild("legLeftCenterLower", CubeListBuilder.create().texOffs(0, 36).addBox(-0.2889f, -0.8f, 0.002f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition legRightRear = partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)19.7f, (float)1.7f, (float)0.0f, (float)-2.618f, (float)0.0f));
        PartDefinition legRightRearUpper = legRightRear.addOrReplaceChild("legRightRearUpper", CubeListBuilder.create().texOffs(26, 27).addBox(-0.5f, -0.3f, 0.2f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.7f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legRightRearCenter = legRightRearUpper.addOrReplaceChild("legRightRearCenter", CubeListBuilder.create().texOffs(14, 27).addBox(0.6025f, -0.614f, 0.21f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legRightRearCenter.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(15, 35).addBox(-0.2889f, -0.8f, 0.202f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition legLeftRear = partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)19.7f, (float)1.7f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition legLeftRearUpper = legLeftRear.addOrReplaceChild("legLeftRearUpper", CubeListBuilder.create().texOffs(29, 14).addBox(-0.5f, -0.3f, 0.2f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.2f, (float)-0.7f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition legLeftRearCenter = legLeftRearUpper.addOrReplaceChild("legLeftRearCenter", CubeListBuilder.create().texOffs(29, 2).addBox(0.6025f, -0.614f, 0.21f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f));
        legLeftRearCenter.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(23, 35).addBox(-0.2889f, -0.8f, 0.202f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.4894f, (float)0.2291f, (float)-0.002f, (float)0.0f, (float)0.0f, (float)0.48f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

