/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.JellyfishEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NatureJellyfishModel
extends HierarchicalModel<JellyfishEntity> {
    public ModelPart root;
    public ModelPart body;
    public ModelPart bell;
    public ModelPart tentacleNorth;
    public ModelPart tentacleEast;
    public ModelPart tentacleSouth;
    public ModelPart tentacleWest;
    public ModelPart head;
    public ModelPart armNorthEast;
    public ModelPart armSouthEast;
    public ModelPart armSouth;
    public ModelPart armSouthWest;
    public ModelPart armNorthWest;

    public NatureJellyfishModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.bell = this.body.getChild("bell");
        this.tentacleNorth = this.bell.getChild("tentacleNorth");
        this.tentacleEast = this.bell.getChild("tentacleEast");
        this.tentacleSouth = this.bell.getChild("tentacleSouth");
        this.tentacleWest = this.bell.getChild("tentacleWest");
        this.head = this.body.getChild("head");
        this.armNorthEast = this.head.getChild("armNorthEast");
        this.armSouthEast = this.head.getChild("armSouthEast");
        this.armSouth = this.head.getChild("armSouth");
        this.armSouthWest = this.head.getChild("armSouthWest");
        this.armNorthWest = this.head.getChild("armNorthWest");
    }

    public void setupAnim(JellyfishEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.swimAnim(pAgeInTicks);
    }

    public void swimAnim(float pAgeInTicks) {
        this.root.xScale = pAgeInTicks / 5.0f + 0.85f;
        this.root.yScale = -pAgeInTicks / 7.5f + 1.15f;
        this.root.zScale = pAgeInTicks / 5.0f + 0.85f;
        this.tentacleNorth.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.tentacleEast.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.tentacleSouth.xRot = pAgeInTicks * IcariaMath.rad(22.5f) + IcariaMath.rad(22.5f);
        this.tentacleWest.xRot = pAgeInTicks * IcariaMath.rad(22.5f) + IcariaMath.rad(22.5f);
        this.armNorthEast.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.armSouthEast.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.armSouth.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.armSouthWest.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
        this.armNorthWest.xRot = -pAgeInTicks * IcariaMath.rad(22.5f) - IcariaMath.rad(22.5f);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -1.0f, -3.5f, 7.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bell = body.addOrReplaceChild("bell", CubeListBuilder.create().texOffs(0, 22).addBox(-6.5f, -24.0f, -6.5f, 13.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bell.addOrReplaceChild("tentacleNorth", CubeListBuilder.create().texOffs(13, 47).addBox(-6.5f, 0.0f, 0.0f, 13.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)-6.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        bell.addOrReplaceChild("tentacleEast", CubeListBuilder.create().texOffs(13, 47).addBox(-6.5f, 0.0f, 0.0f, 13.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.5f, (float)-22.0f, (float)0.0f, (float)-0.3927f, (float)1.5708f, (float)0.0f));
        bell.addOrReplaceChild("tentacleSouth", CubeListBuilder.create().texOffs(0, 38).addBox(-6.5f, 0.0f, 0.0f, 13.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-22.0f, (float)6.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        bell.addOrReplaceChild("tentacleWest", CubeListBuilder.create().texOffs(0, 38).addBox(-6.5f, 0.0f, 0.0f, 13.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)-22.0f, (float)0.0f, (float)0.3927f, (float)1.5708f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(37, 38).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        head.addOrReplaceChild("shoulderNorth", CubeListBuilder.create().texOffs(48, 50).addBox(-3.0f, -2.0f, -1.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-3.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("shoulderEast", CubeListBuilder.create().texOffs(46, 56).addBox(-2.0f, -1.0f, -3.0f, 3.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        head.addOrReplaceChild("shoulderSouth", CubeListBuilder.create().texOffs(30, 50).addBox(-3.0f, -1.0f, -1.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)3.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("shoulderWest", CubeListBuilder.create().texOffs(30, 55).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        head.addOrReplaceChild("armNorthEast", CubeListBuilder.create().texOffs(0, 50).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.3927f, (float)0.5236f, (float)0.0f));
        head.addOrReplaceChild("armSouthEast", CubeListBuilder.create().texOffs(6, 50).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.3927f, (float)1.7802f, (float)0.0f));
        head.addOrReplaceChild("armSouth", CubeListBuilder.create().texOffs(12, 50).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.3927f, (float)3.0369f, (float)0.0f));
        head.addOrReplaceChild("armSouthWest", CubeListBuilder.create().texOffs(24, 50).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.3927f, (float)-1.9897f, (float)0.0f));
        head.addOrReplaceChild("armNorthWest", CubeListBuilder.create().texOffs(18, 50).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.3927f, (float)-0.733f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

