/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.NetherPyromancerRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NetherPyromancerRevenantModel
extends HierarchicalModel<NetherPyromancerRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart headMain;
    public ModelPart jawUpper;
    public ModelPart jawLower;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart bodyLower;
    public ModelPart pelvisMain;
    public ModelPart pelvisRight;
    public ModelPart pelvisLeft;
    public ModelPart thighRight;
    public ModelPart thighLeft;
    public ModelPart legRight;
    public ModelPart legLeft;

    public NetherPyromancerRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.headMain = this.bodyUpper.getChild("headMain");
        this.jawUpper = this.headMain.getChild("jawUpper");
        this.jawLower = this.jawUpper.getChild("jawLower");
        this.shoulderMain = this.bodyUpper.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.bodyLower = this.root.getChild("bodyLower");
        this.pelvisMain = this.bodyLower.getChild("pelvisMain");
        this.pelvisRight = this.pelvisMain.getChild("pelvisRight");
        this.pelvisLeft = this.pelvisMain.getChild("pelvisLeft");
        this.thighRight = this.pelvisRight.getChild("thighRight");
        this.thighLeft = this.pelvisLeft.getChild("thighLeft");
        this.legRight = this.thighRight.getChild("legRight");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(NetherPyromancerRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, 0.0f, 0.0f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f);
        this.setRotateAngles(this.jawLower, 0.1047f, 0.0f, 0.0f);
        this.setRotateAngles(this.armRightUpper, 0.0f, 0.0f, 0.3927f);
        this.setRotateAngles(this.armRightLower, -0.1047f, 0.0f, -0.3927f);
        this.setRotateAngles(this.armLeftUpper, 0.0f, 0.0f, -0.1047f);
        this.setRotateAngles(this.armLeftLower, -0.1047f, 0.0f, 0.1047f);
        this.setRotateAngles(this.thighRight, -0.3142f, 0.3142f, -0.0436f);
        this.setRotateAngles(this.thighLeft, -0.3142f, -0.3142f, 0.0436f);
        this.setRotateAngles(this.legRight, 0.2094f, 0.0f, 0.0f);
        this.setRotateAngles(this.legLeft, 0.2094f, 0.0f, 0.0f);
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.reloadAnimationState, IcariaAnimations.PYROMANCER_REVENANT_RELOAD, pAgeInTicks);
        this.animate(pEntity.thrownAnimationState, IcariaAnimations.PYROMANCER_REVENANT_THROWN, pAgeInTicks);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.zRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.jawLower.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.thighRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        this.thighLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.5f * pLimbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(0, 42).addBox(-1.0f, -15.5f, -0.975f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.5f, (float)1.375f));
        PartDefinition headMain = bodyUpper.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 12).addBox(-3.5f, -8.0f, -5.4125f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.5f, (float)0.0375f));
        headMain.addOrReplaceChild("headWear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.5f, -4.5f, 8.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0561f, (float)-8.4279f, (float)-1.2536f, (float)-0.0785f, (float)0.0f, (float)0.0785f));
        PartDefinition jawUpper = headMain.addOrReplaceChild("jawUpper", CubeListBuilder.create().texOffs(30, 14).addBox(-2.5f, 0.0f, -6.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0875f));
        jawUpper.addOrReplaceChild("jawLower", CubeListBuilder.create().texOffs(36, 33).addBox(-2.5f, 0.0068f, -6.0171f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.9875f, (float)0.0125f, (float)0.1047f, (float)0.0f, (float)0.0f));
        PartDefinition shoulderMain = bodyUpper.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(22, 12).addBox(-6.5f, -0.5f, -0.5f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.5f, (float)-0.875f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(36, 50).addBox(-1.0609f, -0.3061f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(8, 44).addBox(-1.0655f, -0.0389f, -0.8434f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0109f, (float)6.3438f, (float)-0.1625f, (float)-0.1047f, (float)0.0f, (float)-0.3927f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(25, 0).addBox(-0.6973f, -0.0523f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(52, 0).addBox(-0.9832f, -0.0672f, -0.9762f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2902f, (float)6.9477f, (float)-0.0125f, (float)-0.1047f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperRightRear = bodyUpper.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(53, 25).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-11.5f, (float)0.125f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(22, 14).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperLeftRear = bodyUpper.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(52, 51).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-11.5f, (float)0.125f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(30, 33).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(0, 18).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperCenterRightRear = bodyUpper.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(55, 42).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9177f, (float)-9.7056f, (float)0.125f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(50, 46).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(0, 28).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribUpperCenterLeftRear = bodyUpper.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(22, 55).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9177f, (float)-9.7056f, (float)0.125f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(49, 40).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(28, 14).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterRightRear = bodyUpper.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(53, 28).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6067f, (float)-8.4528f, (float)0.125f, (float)0.0f, (float)0.0f, (float)-0.2094f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(50, 9).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(28, 16).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterLeftRear = bodyUpper.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(52, 54).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6067f, (float)-8.4528f, (float)0.125f, (float)0.0f, (float)0.0f, (float)0.2094f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(33, 0).addBox(-0.5f, -0.5f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-0.5f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(0, 26).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-2.5f));
        PartDefinition ribLowerCenterLeftRear = bodyUpper.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(56, 9).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.1716f, (float)-7.2443f, (float)0.125f, (float)0.0f, (float)0.0f, (float)0.3142f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(0, 30).addBox(-0.5f, -0.5f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-0.5f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(33, 3).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-2.5f));
        PartDefinition ribLowerLeftRear = bodyUpper.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(55, 40).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6171f, (float)-6.0824f, (float)0.125f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(0, 12).addBox(-0.5f, -0.5f, -1.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.0f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(22, 33).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-2.0f));
        bodyUpper.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(14, 26).addBox(-2.0f, -3.0f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)-3.075f));
        PartDefinition bandUpper = bodyUpper.addOrReplaceChild("bandUpper", CubeListBuilder.create().texOffs(22, 33).addBox(-0.5f, -8.0f, -3.0f, 1.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.451f, (float)-6.2278f, (float)-1.375f, (float)0.0f, (float)0.0f, (float)0.589f));
        bandUpper.addOrReplaceChild("bandLower", CubeListBuilder.create().texOffs(0, 26).addBox(-1.5f, -4.0f, -4.0f, 3.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.4695f, (float)8.9925f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.589f));
        PartDefinition robeUpper = bodyUpper.addOrReplaceChild("robeUpper", CubeListBuilder.create().texOffs(34, 0).addBox(-2.0f, -3.0f, -2.5f, 4.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.9f, (float)-10.0f, (float)-1.175f));
        PartDefinition robeCenter = robeUpper.addOrReplaceChild("robeCenter", CubeListBuilder.create().texOffs(36, 40).addBox(-2.0f, -2.5f, -2.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.7992f, (float)4.5318f, (float)0.03f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        robeCenter.addOrReplaceChild("robeLower", CubeListBuilder.create().texOffs(25, 21).addBox(-4.5f, -3.5f, -2.5f, 9.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3038f, (float)4.9901f, (float)-0.066f, (float)-0.0785f, (float)0.0f, (float)0.3927f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(46, 14).addBox(-4.0f, -0.5f, -0.4f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.3f, (float)1.4f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(6, 42).addBox(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-2.4f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(52, 30).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8575f, (float)-0.4258f, (float)1.4005f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(52, 16).addBox(-1.1664f, 0.6062f, -0.5989f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0125f, (float)-0.4875f, (float)-0.5125f, (float)-0.3142f, (float)0.3142f, (float)-0.0436f));
        thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(44, 50).addBox(-0.975f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1789f, (float)7.6062f, (float)0.4012f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(52, 34).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.858f, (float)-0.401f, (float)1.4049f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        PartDefinition thighLeft = pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(14, 51).addBox(-0.8025f, 0.4022f, -0.579f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-0.5125f, (float)-0.3142f, (float)-0.3142f, (float)0.0436f));
        thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0125f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1975f, (float)7.4022f, (float)0.421f, (float)0.2094f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

