/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OliveForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyBase;
    public ModelPart bodyMain;
    public ModelPart bodyLower;
    public ModelPart bodyCenter;
    public ModelPart bodyUpper;
    public ModelPart shoulderRight;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart neckMain;
    public ModelPart headMain;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;
    public ModelPart footLeft;

    public OliveForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyBase = this.root.getChild("bodyBase");
        this.bodyMain = this.bodyBase.getChild("bodyMain");
        this.bodyLower = this.bodyMain.getChild("bodyLower");
        this.bodyCenter = this.bodyLower.getChild("bodyCenter");
        this.bodyUpper = this.bodyCenter.getChild("bodyUpper");
        this.shoulderRight = this.bodyUpper.getChild("shoulderRight");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.bodyUpper.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.neckMain = this.bodyUpper.getChild("neckMain");
        this.headMain = this.neckMain.getChild("headMain");
        this.thighRight = this.bodyBase.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyBase.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
        this.footLeft = this.legLeft.getChild("footLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.armRightUpper.xRot = -0.5918f;
        this.armRightUpper.zRot = 0.4427f;
        this.armLeftUpper.xRot = -0.1784f;
        this.armLeftUpper.zRot = -0.3193f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.armRightUpper.zRot -= f;
            this.armLeftUpper.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyBase, -0.167f, 0.0f, -0.1061f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMain, -0.167f, 0.0f, -0.1061f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLower, 0.1061f, 0.0f, 0.0761f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenter, 0.197f, 0.0f, 0.0761f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpper, 0.197f, 0.0f, 0.0761f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRight, 0.4077f, 0.0f, -0.4077f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, 0.8004f, 0.0f, -0.015f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) - 0.8727f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.5918f;
        this.armRightLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.182f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + 0.0759f;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0911f;
        this.armLeftUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.1784f;
        this.armLeftLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.182f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + 0.0759f;
        this.footLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0911f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyBase = partDefinition.addOrReplaceChild("bodyBase", CubeListBuilder.create().texOffs(32, 10).addBox(-5.9599f, -4.2017f, -2.5084f, 13.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2125f, (float)8.2625f, (float)0.0f, (float)-0.167f, (float)0.0f, (float)-0.1061f));
        PartDefinition bodyMain = bodyBase.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(32, 19).addBox(-5.8246f, -2.8478f, -2.2689f, 12.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1901f, (float)-4.1267f, (float)0.2666f, (float)-0.167f, (float)0.0f, (float)-0.1061f));
        PartDefinition bodyLower = bodyMain.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(48, 27).addBox(-5.9577f, -3.8032f, -1.564f, 11.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5504f, (float)-3.1228f, (float)-0.3064f, (float)0.1061f, (float)0.0f, (float)0.0761f));
        PartDefinition bodyCenter = bodyLower.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(44, 44).addBox(-5.9924f, -3.5181f, -1.7566f, 12.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2327f, (float)-3.2782f, (float)-0.314f, (float)0.197f, (float)0.0f, (float)0.0761f));
        PartDefinition bodyUpper = bodyCenter.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(0, 0).addBox(-7.3716f, -4.7791f, -2.546f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5076f, (float)-2.6306f, (float)0.2434f, (float)0.197f, (float)0.0f, (float)0.0761f));
        bodyUpper.addOrReplaceChild("bodyUpperLeavesLeft", CubeListBuilder.create().texOffs(40, 52).addBox(-1.0298f, 0.0087f, -1.9945f, 2.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.6284f, (float)-4.7791f, (float)-0.046f, (float)0.0112f, (float)0.0f, (float)-0.3337f));
        bodyUpper.addOrReplaceChild("bodyUpperLeavesRear", CubeListBuilder.create().texOffs(0, 10).addBox(-7.0f, 0.0f, 0.0f, 14.0f, 20.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6284f, (float)-4.7791f, (float)2.454f, (float)0.0436f, (float)0.0f, (float)0.0f));
        bodyUpper.addOrReplaceChild("bodyUpperSaplingX", CubeListBuilder.create().texOffs(0, 20).addBox(0.0137f, -16.0191f, -5.9837f, 0.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6284f, (float)-4.7791f, (float)0.454f, (float)0.015f, (float)1.1781f, (float)-0.015f));
        bodyUpper.addOrReplaceChild("bodyUpperSaplingZ", CubeListBuilder.create().texOffs(24, 20).addBox(0.016f, -16.0196f, -6.0134f, 0.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6284f, (float)-4.7791f, (float)0.454f, (float)0.015f, (float)-0.3927f, (float)-0.015f));
        PartDefinition shoulderRight = bodyUpper.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(46, 0).addBox(-11.8005f, -4.2922f, -1.2377f, 12.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0466f, (float)-4.2416f, (float)0.079f, (float)0.4077f, (float)0.0f, (float)-0.4077f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(64, 62).addBox(-0.8689f, 0.3634f, -1.3015f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.913f, (float)-2.2922f, (float)0.2623f, (float)-0.5918f, (float)0.0436f, (float)0.4427f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(52, 62).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1311f, (float)9.8634f, (float)-0.3015f, (float)-0.182f, (float)0.0f, (float)-0.0911f));
        PartDefinition armLeftUpper = bodyUpper.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(0, 62).addBox(-1.1868f, -0.4039f, -1.4712f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.6409f, (float)-2.7791f, (float)-0.071f, (float)-0.1784f, (float)0.0f, (float)-0.3193f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(12, 62).addBox(-1.4564f, 0.1309f, -1.4759f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2757f, (float)9.0961f, (float)0.0288f, (float)-0.182f, (float)0.0f, (float)0.0911f));
        PartDefinition neckMain = bodyUpper.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(52, 52).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.1284f, (float)-3.2791f, (float)-0.046f, (float)0.8004f, (float)0.0f, (float)-0.015f));
        PartDefinition headMain = neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 48).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)0.2f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        headMain.addOrReplaceChild("headLeaves", CubeListBuilder.create().texOffs(24, 48).addBox(-1.0386f, -0.1621f, -2.9875f, 2.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9875f, (float)-4.825f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.167f));
        PartDefinition thighRight = bodyBase.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(64, 35).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5849f, (float)-1.5517f, (float)-0.3834f, (float)0.0759f, (float)0.182f, (float)0.1309f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(44, 68).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0911f, (float)-0.0911f, (float)0.0f));
        legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(48, 35).addBox(-2.5f, 0.0f, -2.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.5f, (float)0.0f, (float)0.0f, (float)-0.0911f, (float)0.0f));
        PartDefinition thighLeft = bodyBase.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(63, 8).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5526f, (float)-0.9142f, (float)-0.0709f, (float)0.0759f, (float)-0.0948f, (float)0.048f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(24, 66).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)-0.0911f, (float)-0.0911f, (float)0.0f));
        PartDefinition footLeft = legLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(36, 68).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0911f, (float)0.0911f, (float)0.0f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(64, 15).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.2f, (float)0.0f, (float)0.0911f, (float)0.0911f, (float)0.0456f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

