/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.google.common.collect.ImmutableList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OrichalcumHelmetModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public ModelPart helmet;

    public OrichalcumHelmetModel(ModelPart pModelPart) {
        super(pModelPart);
        this.helmet = pModelPart.getChild("helmet");
    }

    public Iterable<ModelPart> headParts() {
        this.helmet.copyFrom(this.head);
        return ImmutableList.of((Object)this.helmet);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition helmet = partDefinition.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        helmet.addOrReplaceChild("00", CubeListBuilder.create().texOffs(25, 4).addBox(-1.0f, -12.0f, -2.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("01", CubeListBuilder.create().texOffs(57, 19).addBox(-1.0f, -12.0f, 4.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("02", CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, -9.5f, -3.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("03", CubeListBuilder.create().texOffs(2, 2).addBox(0.5f, -9.5f, 4.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("04", CubeListBuilder.create().texOffs(2, 2).addBox(-1.5f, -9.5f, 4.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("05", CubeListBuilder.create().texOffs(2, 6).addBox(-0.5f, -5.5f, 4.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("06", CubeListBuilder.create().texOffs(2, 6).addBox(0.5f, -9.5f, -2.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("07", CubeListBuilder.create().texOffs(1, 5).addBox(-1.5f, -9.5f, 2.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("08", CubeListBuilder.create().texOffs(2, 6).addBox(-1.5f, -9.5f, -2.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("09", CubeListBuilder.create().texOffs(1, 5).addBox(0.5f, -9.5f, 2.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("10", CubeListBuilder.create().texOffs(1, 5).addBox(0.5f, -9.5f, 0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("11", CubeListBuilder.create().texOffs(1, 5).addBox(0.5f, -9.5f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("12", CubeListBuilder.create().texOffs(1, 5).addBox(-1.5f, -9.5f, 0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("13", CubeListBuilder.create().texOffs(1, 5).addBox(-1.5f, -9.5f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("14", CubeListBuilder.create().texOffs(57, 20).addBox(-1.0f, -12.0f, -1.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("15", CubeListBuilder.create().texOffs(57, 28).addBox(-1.0f, -12.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("16", CubeListBuilder.create().texOffs(25, 4).addBox(-1.0f, -12.0f, 0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("17", CubeListBuilder.create().texOffs(57, 20).addBox(-1.0f, -12.0f, 1.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("18", CubeListBuilder.create().texOffs(57, 28).addBox(-1.0f, -12.0f, 2.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("19", CubeListBuilder.create().texOffs(25, 4).addBox(-1.0f, -12.0f, 3.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("20", CubeListBuilder.create().texOffs(57, 26).addBox(-1.0f, -12.0f, 5.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("21", CubeListBuilder.create().texOffs(25, 1).addBox(-1.0f, -12.0f, 6.5f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("22", CubeListBuilder.create().texOffs(25, 6).addBox(-1.0f, -7.0f, 5.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        helmet.addOrReplaceChild("23", CubeListBuilder.create().texOffs(56, 21).addBox(-1.0f, -6.0f, 5.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }
}

