/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.OvergrownRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OvergrownRevenantModel
extends HierarchicalModel<OvergrownRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart spineMain;
    public ModelPart headMain;
    public ModelPart jawUpper;
    public ModelPart jawLower;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart bodyLower;
    public ModelPart pelvisMain;
    public ModelPart pelvisRight;
    public ModelPart pelvisLeft;
    public ModelPart thighRight;
    public ModelPart thighLeft;
    public ModelPart legRight;
    public ModelPart legLeft;

    public OvergrownRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.spineMain = this.bodyUpper.getChild("spineMain");
        this.headMain = this.spineMain.getChild("headMain");
        this.jawUpper = this.headMain.getChild("jawUpper");
        this.jawLower = this.jawUpper.getChild("jawLower");
        this.shoulderMain = this.spineMain.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.bodyLower = this.root.getChild("bodyLower");
        this.pelvisMain = this.bodyLower.getChild("pelvisMain");
        this.pelvisRight = this.pelvisMain.getChild("pelvisRight");
        this.pelvisLeft = this.pelvisMain.getChild("pelvisLeft");
        this.thighRight = this.pelvisRight.getChild("thighRight");
        this.thighLeft = this.pelvisLeft.getChild("thighLeft");
        this.legRight = this.thighRight.getChild("legRight");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(OvergrownRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, -0.2721f, 0.0f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f);
        this.setRotateAngles(this.jawLower, 0.1047f, 0.0f, 0.0f);
        this.setRotateAngles(this.armRightUpper, -0.2731f, 0.0f, 0.2047f);
        this.setRotateAngles(this.armRightLower, -0.1047f, 0.0f, -0.1047f);
        this.setRotateAngles(this.armLeftUpper, -0.2731f, 0.0f, -0.2047f);
        this.setRotateAngles(this.armLeftLower, -0.1047f, 0.0f, 0.1047f);
        this.setRotateAngles(this.thighRight, -0.3142f, 0.3142f, -0.0436f);
        this.setRotateAngles(this.thighLeft, -0.3142f, -0.3142f, 0.0436f);
        this.setRotateAngles(this.legRight, 0.2094f, 0.0f, 0.0f);
        this.setRotateAngles(this.legLeft, 0.2094f, 0.0f, 0.0f);
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void attackAnim() {
        this.armRightUpper.xRot -= Mth.sin((float)(this.attackTime * (float)Math.PI));
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.zRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.jawLower.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.thighRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        this.thighLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.5f * pLimbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
    }

    public void translateToBiceps(PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.spineMain.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armLeftUpper.translateAndRotate(pPoseStack);
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.spineMain.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public void translateToHead(PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.spineMain.translateAndRotate(pPoseStack);
        this.headMain.translateAndRotate(pPoseStack);
    }

    public void translateToFoot(PoseStack pPoseStack) {
        this.bodyLower.translateAndRotate(pPoseStack);
        this.pelvisMain.translateAndRotate(pPoseStack);
        this.pelvisLeft.translateAndRotate(pPoseStack);
        this.thighLeft.translateAndRotate(pPoseStack);
        this.legLeft.translateAndRotate(pPoseStack);
    }

    public void translateToPelvis(PoseStack pPoseStack) {
        this.bodyLower.translateAndRotate(pPoseStack);
        this.pelvisMain.translateAndRotate(pPoseStack);
    }

    public void translateToShoulder(PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.spineMain.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(8, 35).addBox(-1.0f, -7.05f, -1.0375f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.02f, (float)9.9641f, (float)0.4459f));
        PartDefinition spineMain = bodyUpper.addOrReplaceChild("spineMain", CubeListBuilder.create().texOffs(34, 7).addBox(-1.0f, -9.7498f, -1.0076f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.02f, (float)-7.0813f, (float)2.0E-4f, (float)0.2731f, (float)0.0f, (float)0.0f));
        PartDefinition headMain = spineMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 21).addBox(-3.6196f, -5.9487f, -5.5416f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.025f, (float)-8.6576f, (float)-0.0411f, (float)-0.2721f, (float)0.0f, (float)0.0f));
        headMain.addOrReplaceChild("crystalsHead", CubeListBuilder.create().texOffs(46, 43).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.3997f, (float)-8.9487f, (float)-3.583f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        headMain.addOrReplaceChild("crystalHeadNorthEast", CubeListBuilder.create().texOffs(30, 45).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3856f, (float)-7.7017f, (float)-5.5961f, (float)2.3662f, (float)0.7746f, (float)3.087f));
        headMain.addOrReplaceChild("crystalHeadSouthEast", CubeListBuilder.create().texOffs(56, 31).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.239f, (float)-7.0377f, (float)-1.988f, (float)-0.8166f, (float)0.4979f, (float)-0.119f));
        headMain.addOrReplaceChild("crystalHeadSouthWest", CubeListBuilder.create().texOffs(0, 35).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0075f, (float)-8.534f, (float)-0.8102f, (float)-0.7917f, (float)-0.6517f, (float)-0.0365f));
        headMain.addOrReplaceChild("crystalHeadNorthWest", CubeListBuilder.create().texOffs(52, 7).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.3055f, (float)-7.1138f, (float)-5.3879f, (float)2.326f, (float)-0.7815f, (float)3.1204f));
        PartDefinition jawUpper = headMain.addOrReplaceChild("jawUpper", CubeListBuilder.create().texOffs(34, 0).addBox(-2.575f, -0.0375f, -6.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0446f, (float)0.0888f, (float)0.9584f));
        jawUpper.addOrReplaceChild("jawLower", CubeListBuilder.create().texOffs(24, 29).addBox(-2.5875f, -0.0275f, -5.9955f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0125f, (float)0.9875f, (float)0.0f, (float)0.1047f, (float)0.0f, (float)0.0f));
        spineMain.addOrReplaceChild("crystalsShoulder", CubeListBuilder.create().texOffs(56, 24).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-6.6655f, (float)0.2993f, (float)2.679f, (float)-0.0065f, (float)-0.0771f));
        spineMain.addOrReplaceChild("crystalsShoulderSouthEast", CubeListBuilder.create().texOffs(54, 41).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.7981f, (float)-5.6865f, (float)1.6598f, (float)1.998f, (float)-0.2142f, (float)0.6763f));
        spineMain.addOrReplaceChild("crystalsShoulderSouthWest", CubeListBuilder.create().texOffs(44, 51).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.5144f, (float)-5.5917f, (float)1.5682f, (float)1.3855f, (float)-0.5424f, (float)0.9187f));
        spineMain.addOrReplaceChild("crystalsShoulderNorthWest", CubeListBuilder.create().texOffs(8, 51).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5929f, (float)-6.6957f, (float)-2.5497f, (float)-2.3419f, (float)0.6238f, (float)-0.0054f));
        PartDefinition shoulderMain = spineMain.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(22, 21).addBox(-6.5f, -0.5f, -0.5f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.7553f, (float)-0.9128f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(32, 36).addBox(-0.9968f, 0.0078f, -1.0041f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8125f, (float)0.0228f, (float)0.0466f, (float)-0.2731f, (float)0.0f, (float)0.2047f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(40, 23).addBox(-1.0044f, -0.0619f, -1.0134f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0032f, (float)7.0078f, (float)0.0209f, (float)-0.1047f, (float)0.0f, (float)-0.1047f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(24, 36).addBox(-1.0154f, 0.002f, -0.9927f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.825f, (float)0.2103f, (float)-0.0784f, (float)-0.2731f, (float)0.0f, (float)-0.2047f));
        armLeftUpper.addOrReplaceChild("crystalArm", CubeListBuilder.create().texOffs(22, 45).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3073f, (float)3.0215f, (float)-1.3569f, (float)-2.2852f, (float)-0.7854f, (float)0.0f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(16, 35).addBox(-1.0054f, -0.0399f, -0.9733f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0029f, (float)6.977f, (float)-0.0052f, (float)-0.1047f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperRightRear = spineMain.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(56, 47).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.7498f, (float)0.0924f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(44, 28).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(18, 58).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperLeftRear = spineMain.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(34, 57).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-5.7498f, (float)0.0924f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(46, 12).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(58, 36).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperCenterRightRear = spineMain.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(58, 20).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9177f, (float)-3.9554f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(52, 52).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(58, 59).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribUpperCenterLeftRear = spineMain.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(22, 27).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9177f, (float)-3.9554f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(29, 0).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(32, 27).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterRightRear = spineMain.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(8, 58).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6067f, (float)-2.7025f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)-0.2094f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(34, 52).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(58, 54).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterLeftRear = spineMain.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(56, 5).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6067f, (float)-2.7025f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)0.2094f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(38, 16).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(44, 18).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerCenterRightRear = spineMain.addOrReplaceChild("ribLowerCenterRightRear", CubeListBuilder.create().texOffs(58, 7).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1716f, (float)-1.4941f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)-0.3142f));
        PartDefinition ribLowerCenterRightSide = ribLowerCenterRightRear.addOrReplaceChild("ribLowerCenterRightSide", CubeListBuilder.create().texOffs(50, 47).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribLowerCenterRightSide.addOrReplaceChild("ribLowerCenterRightFront", CubeListBuilder.create().texOffs(58, 52).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerCenterLeftRear = spineMain.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(56, 57).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.1716f, (float)-1.4941f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)0.3142f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(50, 26).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(58, 38).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerRightRear = spineMain.addOrReplaceChild("ribLowerRightRear", CubeListBuilder.create().texOffs(58, 22).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6171f, (float)-0.3322f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        PartDefinition ribLowerRightSide = ribLowerRightRear.addOrReplaceChild("ribLowerRightSide", CubeListBuilder.create().texOffs(16, 53).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribLowerRightSide.addOrReplaceChild("ribLowerRightFront", CubeListBuilder.create().texOffs(0, 60).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerLeftRear = spineMain.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(56, 18).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6171f, (float)-0.3322f, (float)0.0924f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(50, 0).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(6, 45).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        spineMain.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(40, 36).addBox(-2.0f, -3.0f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.267f, (float)-3.1357f));
        spineMain.addOrReplaceChild("vineMain", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -2.5f, 12.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.03f, (float)0.8747f, (float)-1.2077f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(22, 23).addBox(-4.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.9248f, (float)0.4112f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(22, 25).addBox(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.75f, (float)-2.4625f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(56, 14).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8575f, (float)-0.4258f, (float)1.4005f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        pelvisRight.addOrReplaceChild("crystalPelvisNorthEast", CubeListBuilder.create().texOffs(0, 54).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.3501f, (float)-1.2906f, (float)-0.109f, (float)2.7819f, (float)1.3183f, (float)-1.1125f));
        pelvisRight.addOrReplaceChild("crystalPelvisSouthWest", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6616f, (float)-1.3742f, (float)2.2081f, (float)1.0802f, (float)-0.3143f, (float)3.0875f));
        pelvisRight.addOrReplaceChild("crystalPelvisNorthWest", CubeListBuilder.create().texOffs(50, 34).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8095f, (float)-1.6998f, (float)-1.2475f, (float)-2.552f, (float)-0.5066f, (float)0.1371f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(42, 7).addBox(-0.9657f, 0.1285f, -1.1001f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0012f, (float)0.0765f, (float)0.5268f, (float)-0.3142f, (float)0.3142f, (float)-0.0436f));
        thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(38, 43).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0218f, (float)7.1285f, (float)-0.1001f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8575f, (float)-0.4258f, (float)1.4005f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        PartDefinition thighLeft = pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(14, 44).addBox(-1.0165f, 0.1732f, -1.0778f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0091f, (float)0.0425f, (float)0.5056f, (float)-0.3142f, (float)-0.3142f, (float)0.0436f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(0, 45).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.004f, (float)7.1732f, (float)-0.0778f, (float)0.2094f, (float)0.0f, (float)0.0f));
        legLeft.addOrReplaceChild("crystalLegNorthWest", CubeListBuilder.create().texOffs(50, 18).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.3868f, (float)2.9524f, (float)-1.3821f, (float)-2.2808f, (float)-0.8073f, (float)-0.0218f));
        legLeft.addOrReplaceChild("crystalLegSouthWest", CubeListBuilder.create().texOffs(26, 53).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.659f, (float)3.4421f, (float)1.2911f, (float)0.8669f, (float)-0.4904f, (float)3.1221f));
        legLeft.addOrReplaceChild("crystalLegNorthEast", CubeListBuilder.create().texOffs(50, 57).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.9325f, (float)3.9966f, (float)-0.9238f, (float)-2.0048f, (float)0.8001f, (float)0.0125f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

