/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlaneForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyBase;
    public ModelPart bodyMain;
    public ModelPart bodyLower;
    public ModelPart bodyCenterRight;
    public ModelPart bodyUpperRight;
    public ModelPart bodyCenterLeft;
    public ModelPart bodyUpperLeft;
    public ModelPart shoulderMain;
    public ModelPart shoulderRight;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart shoulderLeft;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart neckMain;
    public ModelPart neckLeavesUpper;
    public ModelPart neckLeavesLower;
    public ModelPart headMain;
    public ModelPart shoulderMainLeavesMain;
    public ModelPart bodyMainWoodMain;
    public ModelPart bodyMainLeavesMain;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart kneeRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;
    public ModelPart kneeLeftRight;
    public ModelPart kneeLeftLeft;
    public ModelPart kneeLeftRear;

    public PlaneForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyBase = this.root.getChild("bodyBase");
        this.bodyMain = this.bodyBase.getChild("bodyMain");
        this.bodyLower = this.bodyMain.getChild("bodyLower");
        this.bodyCenterRight = this.bodyLower.getChild("bodyCenterRight");
        this.bodyUpperRight = this.bodyCenterRight.getChild("bodyUpperRight");
        this.bodyCenterLeft = this.bodyLower.getChild("bodyCenterLeft");
        this.bodyUpperLeft = this.bodyCenterLeft.getChild("bodyUpperLeft");
        this.shoulderMain = this.bodyUpperLeft.getChild("shoulderMain");
        this.shoulderRight = this.shoulderMain.getChild("shoulderRight");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.shoulderLeft = this.shoulderMain.getChild("shoulderLeft");
        this.armLeftUpper = this.shoulderLeft.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.neckMain = this.shoulderMain.getChild("neckMain");
        this.neckLeavesUpper = this.neckMain.getChild("neckLeavesUpper");
        this.neckLeavesLower = this.neckLeavesUpper.getChild("neckLeavesLower");
        this.headMain = this.neckMain.getChild("headMain");
        this.shoulderMainLeavesMain = this.shoulderMain.getChild("shoulderMainLeavesMain");
        this.bodyMainWoodMain = this.bodyMain.getChild("bodyMainWoodMain");
        this.bodyMainLeavesMain = this.bodyMainWoodMain.getChild("bodyMainLeavesMain");
        this.thighRight = this.bodyBase.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.kneeRight = this.legRight.getChild("kneeRight");
        this.thighLeft = this.bodyBase.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
        this.kneeLeftRight = this.legLeft.getChild("kneeLeftRight");
        this.kneeLeftLeft = this.legLeft.getChild("kneeLeftLeft");
        this.kneeLeftRear = this.legLeft.getChild("kneeLeftRear");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.shoulderRight.xRot = -0.4554f;
        this.shoulderRight.zRot = -0.0411f;
        this.shoulderLeft.xRot = -0.5009f;
        this.shoulderLeft.zRot = -0.5054f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.shoulderRight.zRot -= f;
            this.shoulderLeft.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.shoulderRight.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.shoulderRight.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.shoulderLeft.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.shoulderLeft.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyMain, -0.0723f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLower, 0.015f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenterRight, 0.1023f, 0.0f, -0.2881f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperRight, 0.1023f, 0.0f, 0.1595f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenterLeft, 0.1023f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeft, 0.1023f, 0.0f, -0.3641f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderMain, 0.1023f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.armRightUpper, 0.015f, 0.7854f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.armLeftUpper, -0.0723f, 0.5812f, -0.1546f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, 0.8877f, 0.0873f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckLeavesUpper, 0.015f, 0.0f, 0.0306f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckLeavesLower, -0.8955f, 0.0f, -0.0606f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderMainLeavesMain, 0.0831f, 0.0911f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMainWoodMain, 0.0586f, 0.0f, -0.1459f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyMainLeavesMain, 0.015f, 0.0f, -0.015f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) - 0.8727f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw) - 0.0911f;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.shoulderRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.4554f;
        this.armRightLower.zRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.0873f;
        this.kneeRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.shoulderLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.5009f;
        this.armLeftLower.zRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.1745f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.0873f;
        this.kneeLeftRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.kneeLeftLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.kneeLeftRear.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyBase = partDefinition.addOrReplaceChild("bodyBase", CubeListBuilder.create().texOffs(21, 25).addBox(-5.5f, 0.0f, -2.5f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodyMain = bodyBase.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(48, 20).addBox(-4.6f, 0.0f, -1.7f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.4f, (float)0.0f, (float)-0.0723f, (float)0.0f, (float)0.0723f));
        PartDefinition bodyLower = bodyMain.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(11, 50).addBox(-3.9f, 0.0f, -1.2f, 9.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.4f, (float)0.0f, (float)0.015f, (float)0.0f, (float)0.0723f));
        PartDefinition bodyCenterRight = bodyLower.addOrReplaceChild("bodyCenterRight", CubeListBuilder.create().texOffs(0, 56).addBox(-5.2f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.1023f, (float)0.0f, (float)-0.2881f));
        bodyCenterRight.addOrReplaceChild("bodyUpperRight", CubeListBuilder.create().texOffs(50, 12).addBox(-5.3f, 0.0f, -2.8f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.0f, (float)0.1023f, (float)0.0f, (float)0.1595f));
        PartDefinition bodyCenterLeft = bodyLower.addOrReplaceChild("bodyCenterLeft", CubeListBuilder.create().texOffs(31, 52).addBox(0.6f, 0.0f, -2.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.9f, (float)0.0f, (float)0.1023f, (float)0.0f, (float)0.0723f));
        PartDefinition bodyUpperLeft = bodyCenterLeft.addOrReplaceChild("bodyUpperLeft", CubeListBuilder.create().texOffs(47, 47).addBox(0.5f, 0.0f, -2.8f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.3f, (float)-1.3f, (float)0.0f, (float)0.1023f, (float)0.0f, (float)-0.3641f));
        PartDefinition shoulderMain = bodyUpperLeft.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(0, 0).addBox(-5.7f, 0.0f, -3.0f, 13.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.6f, (float)-0.7f, (float)0.1023f, (float)0.0f, (float)0.0723f));
        PartDefinition shoulderRight = shoulderMain.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(52, 29).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.4f, (float)0.3f, (float)0.1f, (float)-0.4554f, (float)0.7854f, (float)-0.0411f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(16, 64).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)3.5f, (float)-0.8f, (float)0.015f, (float)0.7854f, (float)-0.015f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(0, 64).addBox(-0.9875f, 0.0f, -1.0125f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0125f, (float)7.65f, (float)0.525f, (float)0.1745f, (float)0.0f, (float)-0.1745f));
        PartDefinition shoulderLeft = shoulderMain.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(44, 0).addBox(-2.5f, 0.0f, -2.5f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.5f, (float)-1.0f, (float)0.8f, (float)-0.5009f, (float)0.7854f, (float)-0.5054f));
        PartDefinition armLeftUpper = shoulderLeft.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(24, 64).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.7f, (float)5.5f, (float)0.8f, (float)-0.0723f, (float)0.5812f, (float)-0.1546f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(8, 64).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.5f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)-0.1745f));
        PartDefinition neckMain = shoulderMain.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(32, 60).addBox(-1.5f, -6.4f, -1.5f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)0.8f, (float)-0.5f, (float)0.8877f, (float)0.0873f, (float)-0.015f));
        PartDefinition neckLeavesUpper = neckMain.addOrReplaceChild("neckLeavesUpper", CubeListBuilder.create().texOffs(14, 34).addBox(-3.5f, -6.4f, -1.5f, 7.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.4f, (float)2.7f, (float)0.015f, (float)0.0f, (float)0.0306f));
        neckLeavesUpper.addOrReplaceChild("neckLeavesLower", CubeListBuilder.create().texOffs(34, 34).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)1.2f, (float)-0.8955f, (float)0.0f, (float)-0.0606f));
        neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(26, 10).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.8727f, (float)-0.0911f, (float)0.1367f));
        shoulderMain.addOrReplaceChild("shoulderMainLeavesMain", CubeListBuilder.create().texOffs(0, 10).addBox(-4.8f, 0.0f, 0.0f, 11.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.1f, (float)2.5f, (float)0.0831f, (float)0.0911f, (float)-0.015f));
        PartDefinition bodyMainWoodMain = bodyMain.addOrReplaceChild("bodyMainWoodMain", CubeListBuilder.create().texOffs(44, 63).addBox(-5.3f, -7.2f, -1.5f, 1.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.2f, (float)0.0f, (float)0.0586f, (float)0.0f, (float)-0.1459f));
        bodyMainWoodMain.addOrReplaceChild("bodyMainLeavesMain", CubeListBuilder.create().texOffs(0, 30).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-11.0f, (float)0.0f, (float)0.015f, (float)0.0f, (float)-0.015f));
        PartDefinition thighRight = bodyBase.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(57, 59).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)3.5f, (float)0.0f, (float)-0.0873f, (float)0.0436f, (float)0.0436f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(32, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.8f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0436f));
        PartDefinition kneeRight = legRight.addOrReplaceChild("kneeRight", CubeListBuilder.create().texOffs(52, 66).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.7f, (float)0.0f, (float)0.0873f, (float)-0.0436f, (float)0.0f));
        PartDefinition footRight = kneeRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(65, 9).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.8f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-0.0436f));
        footRight.addOrReplaceChild("soleRight", CubeListBuilder.create().texOffs(16, 56).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)0.0873f, (float)-0.0436f, (float)-0.0436f));
        PartDefinition thighLeft = bodyBase.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(52, 38).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)3.5f, (float)0.0f, (float)-0.0873f, (float)-0.0436f, (float)-0.0436f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(62, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0436f));
        PartDefinition kneeLeftRight = legLeft.addOrReplaceChild("kneeLeftRight", CubeListBuilder.create().texOffs(64, 66).addBox(-1.3f, 0.0f, -1.2f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.7f, (float)0.0f, (float)0.0873f, (float)-0.0873f, (float)0.0f));
        legLeft.addOrReplaceChild("kneeLeftLeft", CubeListBuilder.create().texOffs(0, 52).addBox(0.3f, 0.0f, -0.9f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.7f, (float)0.0f, (float)0.0873f, (float)-0.0436f, (float)0.0f));
        legLeft.addOrReplaceChild("kneeLeftRear", CubeListBuilder.create().texOffs(60, 66).addBox(-0.7f, 0.0f, 0.3f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.7f, (float)0.0f, (float)0.0873f, (float)-0.0436f, (float)0.0f));
        PartDefinition footLeft = kneeLeftRight.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(64, 46).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.8f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(45, 56).addBox(-2.0f, 0.0f, -2.2f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)0.0873f, (float)0.0436f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

