/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PopulusForestHagModel
extends HierarchicalModel<ForestHagEntity> {
    public ModelPart root;
    public ModelPart bodyMainRight;
    public ModelPart bodyLowerRight;
    public ModelPart bodyLowerLeft;
    public ModelPart bodyCenterRight;
    public ModelPart bodyCenterLeft;
    public ModelPart bodyUpperRight;
    public ModelPart bodyUpperLeft;
    public ModelPart shoulderRight;
    public ModelPart neckMain;
    public ModelPart headMain;
    public ModelPart shoulderLeft;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart shroomStem;
    public ModelPart shroomRing;
    public ModelPart shroomHead;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart shoulderRightLeavesUpper;
    public ModelPart shoulderRightLeavesCenter;
    public ModelPart shoulderRightLeavesLower;
    public ModelPart bodyLowerTwigUpper;
    public ModelPart bodyLowerTwigLower;
    public ModelPart thighRight;
    public ModelPart legRight;
    public ModelPart thighLeft;
    public ModelPart legLeft;
    public ModelPart kneeLeft;

    public PopulusForestHagModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyMainRight = this.root.getChild("bodyMainRight");
        this.bodyLowerRight = this.bodyMainRight.getChild("bodyLowerRight");
        this.bodyLowerLeft = this.bodyLowerRight.getChild("bodyLowerLeft");
        this.bodyCenterRight = this.bodyLowerRight.getChild("bodyCenterRight");
        this.bodyCenterLeft = this.bodyCenterRight.getChild("bodyCenterLeft");
        this.bodyUpperRight = this.bodyCenterRight.getChild("bodyUpperRight");
        this.bodyUpperLeft = this.bodyUpperRight.getChild("bodyUpperLeft");
        this.shoulderRight = this.bodyUpperRight.getChild("shoulderRight");
        this.neckMain = this.shoulderRight.getChild("neckMain");
        this.headMain = this.neckMain.getChild("headMain");
        this.shoulderLeft = this.shoulderRight.getChild("shoulderLeft");
        this.armLeftUpper = this.shoulderLeft.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.shroomStem = this.shoulderLeft.getChild("shroomStem");
        this.shroomRing = this.shroomStem.getChild("shroomRing");
        this.shroomHead = this.shroomStem.getChild("shroomHead");
        this.armRightUpper = this.shoulderRight.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.shoulderRightLeavesUpper = this.shoulderRight.getChild("shoulderRightLeavesUpper");
        this.shoulderRightLeavesCenter = this.shoulderRightLeavesUpper.getChild("shoulderRightLeavesCenter");
        this.shoulderRightLeavesLower = this.shoulderRightLeavesCenter.getChild("shoulderRightLeavesLower");
        this.bodyLowerTwigUpper = this.bodyLowerRight.getChild("bodyLowerTwigUpper");
        this.bodyLowerTwigLower = this.bodyLowerRight.getChild("bodyLowerTwigLower");
        this.thighRight = this.bodyMainRight.getChild("thighRight");
        this.legRight = this.thighRight.getChild("legRight");
        this.thighLeft = this.bodyMainRight.getChild("thighLeft");
        this.legLeft = this.thighLeft.getChild("legLeft");
        this.kneeLeft = this.legLeft.getChild("kneeLeft");
    }

    public void setupAnim(ForestHagEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.armRightUpper.xRot = -0.3927f;
        this.armRightUpper.zRot = 0.1373f;
        this.armLeftUpper.xRot = -0.3927f;
        this.armLeftUpper.zRot = -0.1896f;
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim() {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        if (this.attackTime > 0.0f) {
            this.armRightUpper.zRot -= f;
            this.armLeftUpper.zRot += f;
        }
    }

    public void idleAnim(float pAgeInTicks) {
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f;
        this.wiggleRotateAngles(this.bodyLowerRight, 0.1023f, 0.0f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLowerLeft, 0.015f, 0.0f, 0.0897f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenterRight, 0.1023f, 0.0f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyCenterLeft, 0.015f, 0.0f, 0.0374f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperRight, 0.1023f, 0.0f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyUpperLeft, 0.015f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRight, 0.1023f, 0.0f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.neckMain, 0.8004f, 0.0873f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderLeft, 0.015f, 0.0f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomStem, 0.015f, 0.0f, -0.1895f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomRing, 0.015f, 0.182f, -0.015f, pAgeInTicks);
        this.wiggleRotateAngles(this.shroomHead, 0.015f, -0.0456f, 0.0723f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRightLeavesUpper, 0.1023f, 0.0f, 0.0199f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRightLeavesCenter, -0.1246f, 0.0f, -0.0237f, pAgeInTicks);
        this.wiggleRotateAngles(this.shoulderRightLeavesLower, -0.1246f, 0.0f, -0.0237f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLowerTwigUpper, 0.1023f, -0.4098f, -0.6068f, pAgeInTicks);
        this.wiggleRotateAngles(this.bodyLowerTwigLower, 0.1023f, -0.1047f, 0.9866f, pAgeInTicks);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot = IcariaMath.rad(pHeadPitch) - 0.9599f;
        this.headMain.yRot = IcariaMath.rad(pNetHeadYaw) + 0.0873f;
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.3927f;
        this.armRightLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - pLimbSwingAmount - 0.3927f;
        this.thighRight.xRot = Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount - 0.0873f;
        this.legRight.xRot = Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
        this.armLeftUpper.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.3927f;
        this.armLeftLower.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - pLimbSwingAmount - 0.3927f;
        this.thighLeft.xRot = Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount - 0.0873f;
        this.kneeLeft.xRot = Mth.sin((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount + 0.0873f;
    }

    public void wiggleRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ, float pAgeInTicks) {
        pModelPart.xRot = Mth.cos((float)(pAgeInTicks * 0.045f)) * 0.015f + pX;
        pModelPart.yRot = Mth.sin((float)(pAgeInTicks * 0.035f)) * 0.015f + pY;
        pModelPart.zRot = -Mth.cos((float)(pAgeInTicks * 0.04f)) * 0.015f + pZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyMainRight = partDefinition.addOrReplaceChild("bodyMainRight", CubeListBuilder.create().texOffs(66, 35).addBox(-6.5f, 0.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.8f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        bodyMainRight.addOrReplaceChild("bodyMainLeft", CubeListBuilder.create().texOffs(0, 58).addBox(0.0f, 0.5f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.7f, (float)-0.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition bodyLowerRight = bodyMainRight.addOrReplaceChild("bodyLowerRight", CubeListBuilder.create().texOffs(44, 69).addBox(-6.0f, 0.0f, -1.5f, 8.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)-3.2f, (float)-0.2f, (float)0.1023f, (float)0.0f, (float)0.0199f));
        bodyLowerRight.addOrReplaceChild("bodyLowerLeft", CubeListBuilder.create().texOffs(73, 43).addBox(0.0f, 0.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8f, (float)-0.4f, (float)-0.3f, (float)0.015f, (float)0.0f, (float)0.0897f));
        PartDefinition bodyCenterRight = bodyLowerRight.addOrReplaceChild("bodyCenterRight", CubeListBuilder.create().texOffs(24, 78).addBox(-5.9f, 0.0f, -1.0f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)-3.2f, (float)-0.3f, (float)0.1023f, (float)0.0f, (float)0.0199f));
        bodyCenterRight.addOrReplaceChild("bodyCenterLeft", CubeListBuilder.create().texOffs(40, 76).addBox(0.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8f, (float)-0.4f, (float)-0.2f, (float)0.015f, (float)0.0f, (float)0.0374f));
        PartDefinition bodyUpperRight = bodyCenterRight.addOrReplaceChild("bodyUpperRight", CubeListBuilder.create().texOffs(64, 52).addBox(-7.5f, 0.0f, -1.5f, 9.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)-3.5f, (float)-0.3f, (float)0.1023f, (float)0.0f, (float)0.0199f));
        bodyUpperRight.addOrReplaceChild("bodyUpperLeft", CubeListBuilder.create().texOffs(73, 9).addBox(0.0f, -0.1f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8f, (float)-0.4f, (float)-0.2f, (float)0.015f, (float)0.0f, (float)0.0723f));
        PartDefinition shoulderRight = bodyUpperRight.addOrReplaceChild("shoulderRight", CubeListBuilder.create().texOffs(20, 39).addBox(-10.0f, 0.0f, -2.0f, 12.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6f, (float)-3.3f, (float)-0.3f, (float)0.1023f, (float)0.0f, (float)0.0199f));
        PartDefinition neckMain = shoulderRight.addOrReplaceChild("neckMain", CubeListBuilder.create().texOffs(0, 36).addBox(-1.5f, -7.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.4f, (float)1.8f, (float)-0.4f, (float)0.8004f, (float)0.0873f, (float)0.0199f));
        neckMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(56, 20).addBox(-3.0f, -5.0f, -1.5f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.2f, (float)-8.0f, (float)-3.4f, (float)-0.9599f, (float)0.0873f, (float)0.0349f));
        PartDefinition shoulderLeft = shoulderRight.addOrReplaceChild("shoulderLeft", CubeListBuilder.create().texOffs(45, 40).addBox(0.0f, 0.2f, -3.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3f, (float)-1.5f, (float)-0.2f, (float)0.015f, (float)0.0f, (float)0.0723f));
        PartDefinition armLeftUpper = shoulderLeft.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(78, 75).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.6f, (float)1.8f, (float)-0.3f, (float)-0.3927f, (float)0.0f, (float)-0.1896f));
        armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(54, 82).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.4f, (float)0.1f, (float)-0.3927f, (float)0.0f, (float)0.0873f));
        PartDefinition shroomStem = shoulderLeft.addOrReplaceChild("shroomStem", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-0.2f, (float)0.015f, (float)0.0f, (float)-0.1895f));
        shroomStem.addOrReplaceChild("shroomRing", CubeListBuilder.create().texOffs(0, 69).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.015f, (float)0.182f, (float)-0.015f));
        PartDefinition shroomHead = shroomStem.addOrReplaceChild("shroomHead", CubeListBuilder.create().texOffs(0, 20).addBox(-6.0f, -13.0f, -6.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.5f, (float)0.0f, (float)0.015f, (float)-0.0456f, (float)0.0723f));
        shroomHead.addOrReplaceChild("shroomHeadMain", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -13.0f, -9.0f, 18.0f, 2.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.98f, (float)0.0f));
        shroomHead.addOrReplaceChild("shroomHeadNorth", CubeListBuilder.create().texOffs(0, 51).addBox(-6.0f, -10.0f, -10.0f, 12.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        shroomHead.addOrReplaceChild("shroomHeadEast", CubeListBuilder.create().texOffs(36, 24).addBox(-10.0f, -10.0f, -6.0f, 4.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        shroomHead.addOrReplaceChild("shroomHeadSouth", CubeListBuilder.create().texOffs(32, 52).addBox(-6.0f, -10.0f, 6.0f, 12.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        shroomHead.addOrReplaceChild("shroomHeadWest", CubeListBuilder.create().texOffs(0, 36).addBox(6.0f, -10.0f, -6.0f, 4.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition armRightUpper = shoulderRight.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(82, 59).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.8f, (float)0.7f, (float)-0.3f, (float)-0.3927f, (float)0.0f, (float)0.1373f));
        armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(16, 76).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.4f, (float)0.1f, (float)-0.3927f, (float)0.0f, (float)-0.0873f));
        PartDefinition shoulderRightLeavesUpper = shoulderRight.addOrReplaceChild("shoulderRightLeavesUpper", CubeListBuilder.create().texOffs(24, 59).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-0.5f, (float)3.8f, (float)0.1023f, (float)0.0f, (float)0.0199f));
        PartDefinition shoulderRightLeavesCenter = shoulderRightLeavesUpper.addOrReplaceChild("shoulderRightLeavesCenter", CubeListBuilder.create().texOffs(48, 59).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9f, (float)0.0f, (float)-0.1246f, (float)0.0f, (float)-0.0237f));
        shoulderRightLeavesCenter.addOrReplaceChild("shoulderRightLeavesLower", CubeListBuilder.create().texOffs(54, 0).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9f, (float)0.0f, (float)-0.1246f, (float)0.0f, (float)-0.0237f));
        bodyLowerRight.addOrReplaceChild("bodyLowerTwigUpper", CubeListBuilder.create().texOffs(0, 30).addBox(-4.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.6f, (float)1.2f, (float)-0.2f, (float)0.1023f, (float)-0.4098f, (float)-0.6068f));
        bodyLowerRight.addOrReplaceChild("bodyLowerTwigLower", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -0.5f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)0.8f, (float)0.4f, (float)0.1023f, (float)-0.1047f, (float)0.9866f));
        PartDefinition thighRight = bodyMainRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(36, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.4f, (float)3.3f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.2443f));
        PartDefinition legRight = thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(62, 75).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-0.0349f));
        legRight.addOrReplaceChild("footRight", CubeListBuilder.create().texOffs(67, 64).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.3f, (float)0.0f, (float)0.0873f, (float)0.0873f, (float)-0.0349f));
        PartDefinition thighLeft = bodyMainRight.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(24, 69).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9077f, (float)3.8556f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0698f));
        PartDefinition legLeft = thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(0, 76).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0349f));
        PartDefinition kneeLeft = legLeft.addOrReplaceChild("kneeLeft", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.3f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0349f));
        PartDefinition footLeft = kneeLeft.addOrReplaceChild("footLeft", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.2f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0349f));
        footLeft.addOrReplaceChild("soleLeft", CubeListBuilder.create().texOffs(74, 18).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

