/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.ScorpionEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScorpionModel
extends HierarchicalModel<ScorpionEntity> {
    public ModelPart root;
    public ModelPart bodyMain;
    public ModelPart headMain;
    public ModelPart legRightFrontUpper;
    public ModelPart legRightFrontLower;
    public ModelPart legLeftFrontUpper;
    public ModelPart legLeftFrontLower;
    public ModelPart legRightCenterFrontUpper;
    public ModelPart legRightCenterFrontLower;
    public ModelPart legLeftCenterFrontUpper;
    public ModelPart legLeftCenterFrontLower;
    public ModelPart legRightCenterRearUpper;
    public ModelPart legRightCenterRearLower;
    public ModelPart legLeftCenterRearUpper;
    public ModelPart legLeftCenterRearLower;
    public ModelPart legRightRearUpper;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRearUpper;
    public ModelPart legLeftRearLower;

    public ScorpionModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyMain = this.root.getChild("bodyMain");
        this.headMain = this.bodyMain.getChild("headMain");
        this.legRightFrontUpper = this.bodyMain.getChild("legRightFrontUpper");
        this.legRightFrontLower = this.legRightFrontUpper.getChild("legRightFrontLower");
        this.legLeftFrontUpper = this.bodyMain.getChild("legLeftFrontUpper");
        this.legLeftFrontLower = this.legLeftFrontUpper.getChild("legLeftFrontLower");
        this.legRightCenterFrontUpper = this.bodyMain.getChild("legRightCenterFrontUpper");
        this.legRightCenterFrontLower = this.legRightCenterFrontUpper.getChild("legRightCenterFrontLower");
        this.legLeftCenterFrontUpper = this.bodyMain.getChild("legLeftCenterFrontUpper");
        this.legLeftCenterFrontLower = this.legLeftCenterFrontUpper.getChild("legLeftCenterFrontLower");
        this.legRightCenterRearUpper = this.bodyMain.getChild("legRightCenterRearUpper");
        this.legRightCenterRearLower = this.legRightCenterRearUpper.getChild("legRightCenterRearLower");
        this.legLeftCenterRearUpper = this.bodyMain.getChild("legLeftCenterRearUpper");
        this.legLeftCenterRearLower = this.legLeftCenterRearUpper.getChild("legLeftCenterRearLower");
        this.legRightRearUpper = this.bodyMain.getChild("legRightRearUpper");
        this.legRightRearLower = this.legRightRearUpper.getChild("legRightRearLower");
        this.legLeftRearUpper = this.bodyMain.getChild("legLeftRearUpper");
        this.legLeftRearLower = this.legLeftRearUpper.getChild("legLeftRearLower");
    }

    public void setupAnim(ScorpionEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setupRotateAngles();
        this.setupAnim(pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.SCORPION_ATTACK, pAgeInTicks);
    }

    public void setupRotateAngles() {
        IcariaClientHelper.setRotateAngles(this.headMain, -0.085f, 0.0f, 0.0f);
        IcariaClientHelper.setRotateAngles(this.legRightFrontUpper, -0.3581f, -0.7655f, 0.4075f);
        IcariaClientHelper.setRotateAngles(this.legLeftFrontUpper, -0.3814f, 0.7561f, -0.4412f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterFrontUpper, -0.188f, -0.2688f, 0.2789f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterFrontUpper, -0.1826f, 0.2781f, -0.2766f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterRearUpper, -0.0017f, 0.2709f, 0.2255f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterRearUpper, -0.0017f, -0.2622f, -0.2255f);
        IcariaClientHelper.setRotateAngles(this.legRightRearUpper, 0.0927f, 0.7865f, 0.2243f);
        IcariaClientHelper.setRotateAngles(this.legLeftRearUpper, 0.0971f, -0.7866f, -0.2243f);
    }

    public void setupAnim(float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch) {
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float frontY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 4.712389f)) * 0.4f * pLimbSwingAmount;
        float frontZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 4.712389f)) * 0.4f) * pLimbSwingAmount;
        float centerFrontY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 1.5707964f)) * 0.4f * pLimbSwingAmount;
        float centerFrontZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 1.5707964f)) * 0.4f) * pLimbSwingAmount;
        float centerRearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + (float)Math.PI)) * 0.4f * pLimbSwingAmount;
        float centerRearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.4f) * pLimbSwingAmount;
        float rearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 0.0f)) * 0.4f * pLimbSwingAmount;
        float rearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 0.0f)) * 0.4f) * pLimbSwingAmount;
        this.legRightFrontUpper.yRot += frontY;
        this.legRightFrontUpper.zRot += frontZ;
        this.legLeftFrontUpper.yRot -= frontY;
        this.legLeftFrontUpper.zRot -= frontZ;
        this.legRightCenterFrontUpper.yRot += centerFrontY;
        this.legRightCenterFrontUpper.zRot += centerFrontZ;
        this.legLeftCenterFrontUpper.yRot -= centerFrontY;
        this.legLeftCenterFrontUpper.zRot -= centerFrontZ;
        this.legRightCenterRearUpper.yRot += centerRearY;
        this.legRightCenterRearUpper.zRot += centerRearZ;
        this.legLeftCenterRearUpper.yRot -= centerRearY;
        this.legLeftCenterRearUpper.zRot -= centerRearZ;
        this.legRightRearUpper.yRot += rearY;
        this.legRightRearUpper.zRot += rearZ;
        this.legLeftRearUpper.yRot -= rearY;
        this.legLeftRearUpper.zRot -= rearZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyMain = partDefinition.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -3.5f, -4.0f, 9.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.7f, (float)0.0f, (float)0.0911f, (float)0.0f, (float)0.0f));
        PartDefinition headMain = bodyMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -3.0657f, -6.8917f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.525f, (float)-4.025f, (float)-0.085f, (float)0.0f, (float)0.0f));
        PartDefinition armRightRear = headMain.addOrReplaceChild("armRightRear", CubeListBuilder.create().texOffs(0, 59).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.3f, (float)-0.0657f, (float)-7.8917f, (float)0.0f, (float)0.2793f, (float)0.0f));
        PartDefinition armRightCenter = armRightRear.addOrReplaceChild("armRightCenter", CubeListBuilder.create().texOffs(0, 63).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0125f, (float)0.0f, (float)0.0f, (float)-1.309f, (float)0.0f));
        PartDefinition armRightFront = armRightCenter.addOrReplaceChild("armRightFront", CubeListBuilder.create().texOffs(46, 30).addBox(-6.006f, -1.5f, -2.1738f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.9375f, (float)0.0f, (float)0.0125f, (float)0.0f, (float)-0.7156f, (float)0.0f));
        armRightFront.addOrReplaceChild("fingerRightUpper", CubeListBuilder.create().texOffs(0, 68).addBox(-5.0067f, -0.4971f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.981f, (float)-0.9875f, (float)-0.1738f, (float)0.0f, (float)0.0f, (float)-0.182f));
        armRightFront.addOrReplaceChild("fingerRightLower", CubeListBuilder.create().texOffs(42, 59).addBox(-4.768f, -0.4841f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.9935f, (float)1.675f, (float)-0.1738f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition armLeftRear = headMain.addOrReplaceChild("armLeftRear", CubeListBuilder.create().texOffs(16, 59).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.3f, (float)-0.0657f, (float)-7.8917f, (float)0.0f, (float)-0.2793f, (float)0.0f));
        PartDefinition armLeftCenter = armLeftRear.addOrReplaceChild("armLeftCenter", CubeListBuilder.create().texOffs(16, 63).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)0.025f, (float)0.0f, (float)0.0f, (float)1.309f, (float)0.0f));
        PartDefinition armLeftFront = armLeftCenter.addOrReplaceChild("armLeftFront", CubeListBuilder.create().texOffs(0, 43).addBox(0.0011f, -1.5f, -2.1021f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.9f, (float)0.0f, (float)-0.05f, (float)0.0f, (float)0.7285f, (float)0.0f));
        armLeftFront.addOrReplaceChild("fingerLeftUpper", CubeListBuilder.create().texOffs(0, 71).addBox(-0.0056f, -0.4949f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.9886f, (float)-0.9875f, (float)-0.1021f, (float)0.0f, (float)0.0f, (float)0.182f));
        armLeftFront.addOrReplaceChild("fingerLeftLower", CubeListBuilder.create().texOffs(14, 68).addBox(-0.2304f, -0.5216f, -1.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.9886f, (float)1.7125f, (float)-0.1021f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        headMain.addOrReplaceChild("eyeRightFront", CubeListBuilder.create().texOffs(32, 70).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-2.7657f, (float)-6.5917f));
        headMain.addOrReplaceChild("eyeLeftFront", CubeListBuilder.create().texOffs(32, 68).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-2.7657f, (float)-6.5917f));
        headMain.addOrReplaceChild("eyeRightRear", CubeListBuilder.create().texOffs(36, 68).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.9f, (float)-2.7657f, (float)-3.5917f));
        headMain.addOrReplaceChild("eyeLeftRear", CubeListBuilder.create().texOffs(32, 72).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.9f, (float)-2.7657f, (float)-3.5917f));
        PartDefinition bodyFront = bodyMain.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(62, 0).addBox(-4.0f, -2.9837f, -0.1256f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4875f, (float)2.975f, (float)0.3643f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenter = bodyFront.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 13).addBox(-3.5f, -2.9986f, -0.8111f, 7.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0288f, (float)6.8619f, (float)0.2731f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = bodyCenter.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(26, 13).addBox(-3.0f, -7.6652f, -2.2439f, 6.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6361f, (float)5.1889f, (float)-0.8652f, (float)0.0f, (float)0.0f));
        PartDefinition tailFront = bodyRear.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(28, 30).addBox(-2.5f, -7.657f, -2.8162f, 5.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.6652f, (float)-0.2439f, (float)1.0174f, (float)0.0f, (float)0.0f));
        PartDefinition tailCenter = tailFront.addOrReplaceChild("tailCenter", CubeListBuilder.create().texOffs(20, 43).addBox(-2.0f, -8.0713f, -1.5312f, 4.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.657f, (float)-0.9412f, (float)0.5009f, (float)0.0f, (float)0.0f));
        PartDefinition tailRear = tailCenter.addOrReplaceChild("tailRear", CubeListBuilder.create().texOffs(32, 59).addBox(-0.5f, -5.6199f, -1.8625f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-8.0588f, (float)-0.0062f, (float)1.9124f, (float)0.0f, (float)0.0f));
        tailRear.addOrReplaceChild("stingerMain", CubeListBuilder.create().texOffs(28, 68).addBox(-0.5f, -4.61f, -0.5308f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-5.6074f, (float)-0.8f, (float)-0.4098f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFrontUpper = bodyMain.addOrReplaceChild("legRightFrontUpper", CubeListBuilder.create().texOffs(80, 55).addBox(-6.848f, -1.0357f, -0.8559f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)0.7f, (float)-3.0f, (float)-0.3581f, (float)-0.7655f, (float)0.4075f));
        legRightFrontUpper.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(0, 30).addBox(-11.3873f, -0.8919f, -0.8683f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftFrontUpper = bodyMain.addOrReplaceChild("legLeftFrontUpper", CubeListBuilder.create().texOffs(40, 55).addBox(-1.2579f, -1.0665f, -0.7541f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)0.6875f, (float)-3.0f, (float)-0.3814f, (float)0.7561f, (float)-0.4412f));
        legLeftFrontUpper.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(56, 26).addBox(-11.3135f, -1.1901f, -0.7666f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0944f));
        PartDefinition legRightCenterFrontUpper = bodyMain.addOrReplaceChild("legRightCenterFrontUpper", CubeListBuilder.create().texOffs(0, 55).addBox(-6.9187f, -1.0196f, -0.8046f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.125f, (float)-1.3f, (float)-0.188f, (float)-0.2688f, (float)0.2789f));
        legRightCenterFrontUpper.addOrReplaceChild("legRightCenterFrontLower", CubeListBuilder.create().texOffs(46, 13).addBox(-11.4393f, -0.9425f, -0.8172f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterFrontUpper = bodyMain.addOrReplaceChild("legLeftCenterFrontUpper", CubeListBuilder.create().texOffs(60, 55).addBox(-1.1387f, -1.0378f, -0.6672f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.1f, (float)-1.3f, (float)-0.1826f, (float)0.2781f, (float)-0.2766f));
        legLeftCenterFrontUpper.addOrReplaceChild("legLeftCenterFrontLower", CubeListBuilder.create().texOffs(84, 26).addBox(-11.3927f, -1.0957f, -0.6797f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightCenterRearUpper = bodyMain.addOrReplaceChild("legRightCenterRearUpper", CubeListBuilder.create().texOffs(34, 43).addBox(-7.0745f, -0.9815f, -0.8018f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.2125f, (float)-0.3f, (float)-0.0017f, (float)0.2709f, (float)0.2255f));
        legRightCenterRearUpper.addOrReplaceChild("legRightCenterRearLower", CubeListBuilder.create().texOffs(0, 34).addBox(-11.5561f, -1.0524f, -0.7893f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterRearUpper = bodyMain.addOrReplaceChild("legLeftCenterRearUpper", CubeListBuilder.create().texOffs(34, 47).addBox(-0.8729f, -0.9684f, -0.662f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.2125f, (float)-0.3f, (float)-0.0017f, (float)-0.2622f, (float)-0.2255f));
        legLeftCenterRearUpper.addOrReplaceChild("legLeftCenterRearLower", CubeListBuilder.create().texOffs(46, 17).addBox(-11.5957f, -0.9106f, -0.6495f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightRearUpper = bodyMain.addOrReplaceChild("legRightRearUpper", CubeListBuilder.create().texOffs(34, 51).addBox(-7.1468f, -0.9671f, -0.8499f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.1125f, (float)1.5f, (float)0.0927f, (float)0.7865f, (float)0.2243f));
        legRightRearUpper.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(0, 26).addBox(-11.6075f, -1.1052f, -0.8374f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftRearUpper = bodyMain.addOrReplaceChild("legLeftRearUpper", CubeListBuilder.create().texOffs(20, 55).addBox(-0.7499f, -0.9417f, -0.7442f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.1125f, (float)1.3f, (float)0.0971f, (float)-0.7866f, (float)-0.2243f));
        legLeftRearUpper.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(28, 26).addBox(-11.6852f, -0.822f, -0.7317f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

