/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.SnullEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SnullModel
extends HierarchicalModel<SnullEntity> {
    public ModelPart root;
    public ModelPart bodyFront;
    public ModelPart chest;
    public ModelPart neck;
    public ModelPart head;
    public ModelPart headFeelerRight;
    public ModelPart headFeelerLeft;
    public ModelPart bodySkull;
    public ModelPart skullJawLower;
    public ModelPart skullJawUpper;
    public ModelPart skull;
    public ModelPart skullFeelerRight;
    public ModelPart skullFeelerLeft;

    public SnullModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyFront = this.root.getChild("bodyFront");
        this.chest = this.bodyFront.getChild("chest");
        this.neck = this.chest.getChild("neck");
        this.head = this.neck.getChild("head");
        this.headFeelerRight = this.head.getChild("headFeelerRight");
        this.headFeelerLeft = this.head.getChild("headFeelerLeft");
        this.bodySkull = this.root.getChild("bodySkull");
        this.skullJawLower = this.bodySkull.getChild("skullJawLower");
        this.skullJawUpper = this.skullJawLower.getChild("skullJawUpper");
        this.skull = this.skullJawUpper.getChild("skull");
        this.skullFeelerRight = this.skull.getChild("skullFeelerRight");
        this.skullFeelerLeft = this.skull.getChild("skullFeelerLeft");
    }

    public void setupAnim(SnullEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idleAnim(pAgeInTicks);
        this.animate(pEntity.hideAnimationState, IcariaAnimations.SNULL_HIDE, pAgeInTicks);
        this.animate(pEntity.hurtAnimationState, IcariaAnimations.SNULL_HURT, pAgeInTicks);
        this.animate(pEntity.idleAnimationState, IcariaAnimations.SNULL_IDLE, pAgeInTicks);
        this.animate(pEntity.moveAnimationState, IcariaAnimations.SNULL_MOVE, pAgeInTicks);
        this.animate(pEntity.showAnimationState, IcariaAnimations.SNULL_SHOW, pAgeInTicks);
    }

    public void idleAnim(float pAgeInTicks) {
        this.headFeelerRight.xRot = Mth.sin((float)(pAgeInTicks * 0.05f + 1.0f)) * 0.075f + 0.2618f;
        this.headFeelerRight.zRot = Mth.cos((float)(pAgeInTicks * 0.075f + 2.0f)) * 0.075f + 0.7854f;
        this.headFeelerLeft.yRot = -Mth.sin((float)(pAgeInTicks * 0.05f + 3.0f)) * 0.075f - 0.2618f;
        this.headFeelerLeft.zRot = -Mth.cos((float)(pAgeInTicks * 0.075f + 4.0f)) * 0.075f + 0.7854f;
        this.skullFeelerRight.xRot = Mth.sin((float)(pAgeInTicks * 0.05f + 1.0f)) * 0.075f - 0.2618f;
        this.skullFeelerRight.yRot = Mth.cos((float)(pAgeInTicks * 0.075f + 2.0f)) * 0.075f + 0.1745f;
        this.skullFeelerLeft.xRot = -Mth.sin((float)(pAgeInTicks * 0.05f + 3.0f)) * 0.075f - 0.2618f;
        this.skullFeelerLeft.yRot = -Mth.cos((float)(pAgeInTicks * 0.075f + 4.0f)) * 0.075f - 0.1745f;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyFront = partDefinition.addOrReplaceChild("bodyFront", CubeListBuilder.create().texOffs(0, 29).addBox(-2.95f, -4.0f, -2.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)-3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition chest = bodyFront.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 21).addBox(-2.6f, -4.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition neck = chest.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 13).addBox(-2.55f, -4.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        neck.addOrReplaceChild("neckSack", CubeListBuilder.create().texOffs(18, 7).addBox(-1.8f, -1.75f, -0.75f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.5f, (float)-1.5f, (float)0.1309f, (float)-0.0873f, (float)0.6109f));
        neck.addOrReplaceChild("neckWart", CubeListBuilder.create().texOffs(0, 42).addBox(-0.95f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.0f, (float)-2.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -4.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headSack", CubeListBuilder.create().texOffs(0, 8).addBox(-3.15f, -2.25f, -0.5f, 5.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.3491f, (float)0.3054f, (float)-0.0305f));
        head.addOrReplaceChild("headWart", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-4.0f, (float)-2.0f));
        PartDefinition headFeelerRight = head.addOrReplaceChild("headFeelerRight", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.7854f));
        headFeelerRight.addOrReplaceChild("headEyeRight", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, -1.0f, -7.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headFeelerLeft = head.addOrReplaceChild("headFeelerLeft", CubeListBuilder.create().texOffs(19, 1).addBox(-0.5f, -0.5f, -4.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.7854f));
        headFeelerLeft.addOrReplaceChild("headEyeLeft", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, -1.0f, -6.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyCenter = partDefinition.addOrReplaceChild("bodyCenter", CubeListBuilder.create().texOffs(0, 52).addBox(-3.0f, -1.0f, -4.0f, 6.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
        bodyCenter.addOrReplaceChild("wartRight", CubeListBuilder.create().texOffs(0, 42).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)1.0f, (float)-1.0f));
        bodyCenter.addOrReplaceChild("wartLeft", CubeListBuilder.create().texOffs(0, 42).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.0f, (float)2.0f));
        bodyCenter.addOrReplaceChild("wartTop", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-1.0f, (float)-2.0f));
        PartDefinition bodySkull = partDefinition.addOrReplaceChild("bodySkull", CubeListBuilder.create().texOffs(78, 15).addBox(-2.0f, -2.0f, -3.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition skullJawLower = bodySkull.addOrReplaceChild("skullJawLower", CubeListBuilder.create().texOffs(71, 1).addBox(-2.5f, -0.35f, -5.95f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.8f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition skullJawUpper = skullJawLower.addOrReplaceChild("skullJawUpper", CubeListBuilder.create().texOffs(70, 7).addBox(-2.5f, -0.7f, -6.05f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0125f, (float)-0.275f, (float)0.1375f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition skull = skullJawUpper.addOrReplaceChild("skull", CubeListBuilder.create().texOffs(68, 0).addBox(-3.5f, -6.0f, -6.8f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.6f, (float)0.0f));
        PartDefinition skullFeelerRight = skull.addOrReplaceChild("skullFeelerRight", CubeListBuilder.create().texOffs(18, 0).addBox(-0.5f, -0.55f, -5.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.4f, (float)-6.8f, (float)-0.2618f, (float)0.1745f, (float)0.0f));
        skullFeelerRight.addOrReplaceChild("skullEyeRight", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, -1.05f, -7.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition skullFeelerLeft = skull.addOrReplaceChild("skullFeelerLeft", CubeListBuilder.create().texOffs(19, 1).addBox(-0.5f, -0.55f, -4.5f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.4f, (float)-6.8f, (float)-0.2618f, (float)-0.1745f, (float)0.0f));
        skullFeelerLeft.addOrReplaceChild("skullEyeLeft", CubeListBuilder.create().texOffs(14, 0).addBox(-1.0f, -1.05f, -6.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyRear = partDefinition.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(0, 42).addBox(-2.6f, -3.0f, 0.0f, 5.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)5.0f));
        bodyRear.addOrReplaceChild("wartRear", CubeListBuilder.create().texOffs(26, 0).addBox(-1.1f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-3.0f, (float)5.0f));
        bodyRear.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 35).addBox(-1.9f, -2.0f, 0.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)96, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

