/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.common.entity.SoldierRevenantEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SoldierRevenantModel
extends HierarchicalModel<SoldierRevenantEntity>
implements ArmedModel {
    public ModelPart root;
    public ModelPart bodyUpper;
    public ModelPart headMain;
    public ModelPart jawUpper;
    public ModelPart jawLower;
    public ModelPart shoulderMain;
    public ModelPart armRightUpper;
    public ModelPart armRightLower;
    public ModelPart armLeftUpper;
    public ModelPart armLeftLower;
    public ModelPart bodyLower;
    public ModelPart pelvisMain;
    public ModelPart pelvisRight;
    public ModelPart pelvisLeft;
    public ModelPart thighRight;
    public ModelPart thighLeft;
    public ModelPart legRight;
    public ModelPart legLeft;

    public SoldierRevenantModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyUpper = this.root.getChild("bodyUpper");
        this.headMain = this.bodyUpper.getChild("headMain");
        this.jawUpper = this.headMain.getChild("jawUpper");
        this.jawLower = this.jawUpper.getChild("jawLower");
        this.shoulderMain = this.bodyUpper.getChild("shoulderMain");
        this.armRightUpper = this.shoulderMain.getChild("armRightUpper");
        this.armRightLower = this.armRightUpper.getChild("armRightLower");
        this.armLeftUpper = this.shoulderMain.getChild("armLeftUpper");
        this.armLeftLower = this.armLeftUpper.getChild("armLeftLower");
        this.bodyLower = this.root.getChild("bodyLower");
        this.pelvisMain = this.bodyLower.getChild("pelvisMain");
        this.pelvisRight = this.pelvisMain.getChild("pelvisRight");
        this.pelvisLeft = this.pelvisMain.getChild("pelvisLeft");
        this.thighRight = this.pelvisRight.getChild("thighRight");
        this.thighLeft = this.pelvisLeft.getChild("thighLeft");
        this.legRight = this.thighRight.getChild("legRight");
        this.legLeft = this.thighLeft.getChild("legLeft");
    }

    public void setupAnim(SoldierRevenantEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        RandomSource randomSource = RandomSource.create((long)pEntity.getId());
        this.setRotateAngles(this.headMain, 0.0f, 0.0f, (float)randomSource.nextIntBetweenInclusive(-50, 50) * 0.005f);
        this.setRotateAngles(this.jawLower, 0.1047f, 0.0f, 0.0f);
        this.setRotateAngles(this.armRightUpper, 0.0f, 0.0f, 0.1239f);
        this.setRotateAngles(this.armRightLower, -0.1047f, 0.0f, -0.1047f);
        this.setRotateAngles(this.armLeftUpper, 0.0f, 0.0f, -0.1239f);
        this.setRotateAngles(this.armLeftLower, -0.1047f, 0.0f, 0.1047f);
        this.setRotateAngles(this.thighRight, -0.3142f, 0.3142f, -0.0436f);
        this.setRotateAngles(this.thighLeft, -0.3142f, -0.3142f, 0.0436f);
        this.setRotateAngles(this.legRight, 0.2094f, 0.0f, 0.0f);
        this.setRotateAngles(this.legLeft, 0.2094f, 0.0f, 0.0f);
        this.attackAnim();
        this.idleAnim(pAgeInTicks);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void setRotateAngles(ModelPart pModelPart, float pX, float pY, float pZ) {
        pModelPart.xRot = pX;
        pModelPart.yRot = pY;
        pModelPart.zRot = pZ;
    }

    public void attackAnim() {
        this.armRightUpper.xRot -= Mth.sin((float)(this.attackTime * (float)Math.PI));
    }

    public void idleAnim(float pAgeInTicks) {
        this.headMain.zRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.jawLower.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.xRot += Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armRightUpper.zRot += Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeftUpper.xRot -= Mth.sin((float)(pAgeInTicks * 0.06f)) * 0.05f;
        this.armLeftUpper.zRot -= Mth.cos((float)(pAgeInTicks * 0.09f)) * 0.05f + 0.05f;
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)pLimbSwing) * pLimbSwingAmount;
        this.armRightUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount;
        this.armLeftUpper.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount;
        this.armRightLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * pLimbSwingAmount + pLimbSwingAmount;
        this.armLeftLower.xRot -= Mth.cos((float)(pLimbSwing * 0.6f)) * pLimbSwingAmount + pLimbSwingAmount;
        this.thighRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.5f * pLimbSwingAmount;
        this.thighLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.5f * pLimbSwingAmount;
        this.legRight.xRot += Mth.cos((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
        this.legLeft.xRot += Mth.cos((float)(pLimbSwing * 0.6f)) * 0.8f * pLimbSwingAmount + 0.8f * pLimbSwingAmount;
    }

    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.bodyUpper.translateAndRotate(pPoseStack);
        this.shoulderMain.translateAndRotate(pPoseStack);
        this.armRightUpper.translateAndRotate(pPoseStack);
        this.armRightLower.translateAndRotate(pPoseStack);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyUpper = partDefinition.addOrReplaceChild("bodyUpper", CubeListBuilder.create().texOffs(16, 50).addBox(-1.0f, -15.025f, -0.9875f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.775f, (float)1.3875f));
        PartDefinition headMain = bodyUpper.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(28, 21).addBox(-3.4625f, -6.0f, -5.5125f, 7.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0375f, (float)-15.025f, (float)0.125f));
        PartDefinition jawUpper = headMain.addOrReplaceChild("jawUpper", CubeListBuilder.create().texOffs(32, 35).addBox(-2.5f, 0.0f, -6.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0375f, (float)0.0f, (float)0.9875f));
        jawUpper.addOrReplaceChild("jawLower", CubeListBuilder.create().texOffs(46, 0).addBox(-2.5f, -0.0043f, -6.0033f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.1047f, (float)0.0f, (float)0.0f));
        PartDefinition helmetMain = headMain.addOrReplaceChild("helmetMain", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.5f, -4.5f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0375f, (float)-2.0f, (float)-1.5125f));
        PartDefinition cristaBase = helmetMain.addOrReplaceChild("cristaBase", CubeListBuilder.create().texOffs(19, 35).addBox(-1.0f, -3.0f, -4.5f, 2.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.6f));
        cristaBase.addOrReplaceChild("cristaMain", CubeListBuilder.create().texOffs(34, 0).addBox(-0.5f, -3.5f, -5.0f, 1.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)1.0f));
        PartDefinition shoulderMain = bodyUpper.addOrReplaceChild("shoulderMain", CubeListBuilder.create().texOffs(30, 18).addBox(-6.5f, -0.5f, -0.5f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.025f, (float)-0.8875f));
        PartDefinition armRightUpper = shoulderMain.addOrReplaceChild("armRightUpper", CubeListBuilder.create().texOffs(24, 59).addBox(-1.3038f, -0.0618f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1239f));
        PartDefinition armRightLower = armRightUpper.addOrReplaceChild("armRightLower", CubeListBuilder.create().texOffs(60, 59).addBox(-2.0028f, -0.236f, -0.001f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.6962f, (float)6.9007f, (float)-1.0f, (float)-0.1047f, (float)0.0f, (float)-0.1047f));
        armRightLower.addOrReplaceChild("bracerRight", CubeListBuilder.create().texOffs(38, 53).addBox(-1.5f, -2.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0099f, (float)2.464f, (float)1.099f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition armLeftUpper = shoulderMain.addOrReplaceChild("armLeftUpper", CubeListBuilder.create().texOffs(58, 29).addBox(-0.6962f, -0.0618f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1239f));
        PartDefinition armLeftLower = armLeftUpper.addOrReplaceChild("armLeftLower", CubeListBuilder.create().texOffs(0, 0).addBox(0.0028f, -0.236f, -0.001f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.6962f, (float)6.9007f, (float)-1.0f, (float)-0.1047f, (float)0.0f, (float)0.1047f));
        armLeftLower.addOrReplaceChild("bracerLeft", CubeListBuilder.create().texOffs(50, 53).addBox(-1.5f, -2.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0027f, (float)2.464f, (float)0.9045f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition ribUpperRightRear = bodyUpper.addOrReplaceChild("ribUpperRightRear", CubeListBuilder.create().texOffs(48, 35).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-11.025f, (float)0.1125f));
        PartDefinition ribUpperRightSide = ribUpperRightRear.addOrReplaceChild("ribUpperRightSide", CubeListBuilder.create().texOffs(48, 61).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperRightSide.addOrReplaceChild("ribUpperRightFront", CubeListBuilder.create().texOffs(33, 50).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperLeftRear = bodyUpper.addOrReplaceChild("ribUpperLeftRear", CubeListBuilder.create().texOffs(46, 7).addBox(-2.0f, -1.0f, -0.5f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-11.025f, (float)0.1125f));
        PartDefinition ribUpperLeftSide = ribUpperLeftRear.addOrReplaceChild("ribUpperLeftSide", CubeListBuilder.create().texOffs(62, 0).addBox(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperLeftSide.addOrReplaceChild("ribUpperLeftFront", CubeListBuilder.create().texOffs(48, 38).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.5f, (float)-1.5f));
        PartDefinition ribUpperCenterRightRear = bodyUpper.addOrReplaceChild("ribUpperCenterRightRear", CubeListBuilder.create().texOffs(64, 29).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.9177f, (float)-9.2306f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)-0.1047f));
        PartDefinition ribUpperCenterRightSide = ribUpperCenterRightRear.addOrReplaceChild("ribUpperCenterRightSide", CubeListBuilder.create().texOffs(64, 64).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterRightSide.addOrReplaceChild("ribUpperCenterRightFront", CubeListBuilder.create().texOffs(11, 44).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribUpperCenterLeftRear = bodyUpper.addOrReplaceChild("ribUpperCenterLeftRear", CubeListBuilder.create().texOffs(66, 31).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9177f, (float)-9.2306f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)0.1047f));
        PartDefinition ribUpperCenterLeftSide = ribUpperCenterLeftRear.addOrReplaceChild("ribUpperCenterLeftSide", CubeListBuilder.create().texOffs(63, 19).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribUpperCenterLeftSide.addOrReplaceChild("ribUpperCenterLeftFront", CubeListBuilder.create().texOffs(66, 59).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterRightRear = bodyUpper.addOrReplaceChild("ribCenterRightRear", CubeListBuilder.create().texOffs(32, 42).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6068f, (float)-7.9777f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)-0.2094f));
        PartDefinition ribCenterRightSide = ribCenterRightRear.addOrReplaceChild("ribCenterRightSide", CubeListBuilder.create().texOffs(64, 24).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribCenterRightSide.addOrReplaceChild("ribCenterRightFront", CubeListBuilder.create().texOffs(67, 15).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribCenterLeftRear = bodyUpper.addOrReplaceChild("ribCenterLeftRear", CubeListBuilder.create().texOffs(34, 8).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6068f, (float)-7.9777f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)0.2094f));
        PartDefinition ribCenterLeftSide = ribCenterLeftRear.addOrReplaceChild("ribCenterLeftSide", CubeListBuilder.create().texOffs(54, 64).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribCenterLeftSide.addOrReplaceChild("ribCenterLeftFront", CubeListBuilder.create().texOffs(66, 46).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerCenterRightRear = bodyUpper.addOrReplaceChild("ribLowerCenterRightRear", CubeListBuilder.create().texOffs(32, 42).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1716f, (float)-6.7693f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)-0.3142f));
        PartDefinition ribLowerCenterRightSide = ribLowerCenterRightRear.addOrReplaceChild("ribLowerCenterRightSide", CubeListBuilder.create().texOffs(64, 24).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribLowerCenterRightSide.addOrReplaceChild("ribLowerCenterRightFront", CubeListBuilder.create().texOffs(67, 17).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerCenterLeftRear = bodyUpper.addOrReplaceChild("ribLowerCenterLeftRear", CubeListBuilder.create().texOffs(66, 33).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.1716f, (float)-6.7693f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)0.3142f));
        PartDefinition ribLowerCenterLeftSide = ribLowerCenterLeftRear.addOrReplaceChild("ribLowerCenterLeftSide", CubeListBuilder.create().texOffs(65, 10).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerCenterLeftSide.addOrReplaceChild("ribLowerCenterLeftFront", CubeListBuilder.create().texOffs(66, 35).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerRightRear = bodyUpper.addOrReplaceChild("ribLowerRightRear", CubeListBuilder.create().texOffs(32, 42).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.6171f, (float)-5.6074f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        PartDefinition ribLowerRightSide = ribLowerRightRear.addOrReplaceChild("ribLowerRightSide", CubeListBuilder.create().texOffs(64, 24).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.5f));
        ribLowerRightSide.addOrReplaceChild("ribLowerRightFront", CubeListBuilder.create().texOffs(11, 44).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-1.5f));
        PartDefinition ribLowerLeftRear = bodyUpper.addOrReplaceChild("ribLowerLeftRear", CubeListBuilder.create().texOffs(62, 57).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.6171f, (float)-5.6074f, (float)0.1125f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition ribLowerLeftSide = ribLowerLeftRear.addOrReplaceChild("ribLowerLeftSide", CubeListBuilder.create().texOffs(64, 52).addBox(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.5f));
        ribLowerLeftSide.addOrReplaceChild("ribLowerLeftFront", CubeListBuilder.create().texOffs(33, 52).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-1.5f));
        bodyUpper.addOrReplaceChild("breastboneMain", CubeListBuilder.create().texOffs(56, 7).addBox(-2.0f, -3.0f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.525f, (float)-3.0875f));
        bodyUpper.addOrReplaceChild("strapRight", CubeListBuilder.create().texOffs(41, 42).addBox(-1.0f, -2.0f, -3.5f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-11.025f, (float)-1.0875f));
        bodyUpper.addOrReplaceChild("strapLeft", CubeListBuilder.create().texOffs(0, 40).addBox(-1.0f, -2.0f, -3.5f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-11.025f, (float)-1.0875f));
        PartDefinition chestplateUpper = bodyUpper.addOrReplaceChild("chestplateUpper", CubeListBuilder.create().texOffs(0, 18).addBox(-6.0f, -2.5f, -3.0f, 12.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.525f, (float)-1.1875f));
        chestplateUpper.addOrReplaceChild("chestplateLower", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, -2.5f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-0.2f));
        chestplateUpper.addOrReplaceChild("chestplateRight", CubeListBuilder.create().texOffs(24, 50).addBox(-1.0f, -2.0f, -2.5f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8076f, (float)3.9301f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        chestplateUpper.addOrReplaceChild("chestplateLeft", CubeListBuilder.create().texOffs(50, 20).addBox(-1.0f, -2.0f, -2.5f, 2.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8076f, (float)3.9301f, (float)-0.1f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition bodyLower = partDefinition.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(11, 42).addBox(-3.4875f, -0.5375f, -0.5125f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0125f, (float)9.775f, (float)1.4f));
        PartDefinition pelvisMain = bodyLower.addOrReplaceChild("pelvisMain", CubeListBuilder.create().texOffs(11, 40).addBox(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0125f, (float)0.6f, (float)-2.4875f));
        PartDefinition pelvisRight = pelvisMain.addOrReplaceChild("pelvisRight", CubeListBuilder.create().texOffs(66, 6).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.6881f, (float)-0.3168f, (float)1.1669f, (float)0.2094f, (float)-0.1047f, (float)0.0f));
        PartDefinition thighRight = pelvisRight.addOrReplaceChild("thighRight", CubeListBuilder.create().texOffs(60, 47).addBox(-1.0119f, 0.7531f, -1.0511f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0125f, (float)-0.4875f, (float)-0.0125f, (float)-0.3142f, (float)0.3142f, (float)-0.0436f));
        thighRight.addOrReplaceChild("legRight", CubeListBuilder.create().texOffs(32, 59).addBox(-0.9875f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.0119f, (float)7.7531f, (float)-0.0511f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition pelvisLeft = pelvisMain.addOrReplaceChild("pelvisLeft", CubeListBuilder.create().texOffs(6, 51).addBox(-1.0f, -0.5f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6756f, (float)-0.3168f, (float)1.1669f, (float)0.2094f, (float)0.1047f, (float)0.0f));
        PartDefinition thighLeft = pelvisLeft.addOrReplaceChild("thighLeft", CubeListBuilder.create().texOffs(8, 60).addBox(-0.9724f, 0.7501f, -1.0436f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.4875f, (float)-0.025f, (float)-0.3142f, (float)-0.3142f, (float)0.0436f));
        thighLeft.addOrReplaceChild("legLeft", CubeListBuilder.create().texOffs(59, 14).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0151f, (float)7.7501f, (float)-0.0436f, (float)0.2094f, (float)0.0f, (float)0.0f));
        bodyLower.addOrReplaceChild("skirtFront", CubeListBuilder.create().texOffs(0, 62).addBox(-1.5f, -3.5f, -0.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0125f, (float)2.6282f, (float)-4.0993f, (float)-0.2094f, (float)0.0f, (float)0.0f));
        bodyLower.addOrReplaceChild("skirtFrontRight", CubeListBuilder.create().texOffs(62, 38).addBox(-1.5f, -3.5f, -0.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.62f, (float)2.0757f, (float)-3.664f, (float)-0.1658f, (float)0.0f, (float)0.3142f));
        bodyLower.addOrReplaceChild("skirtFrontLeft", CubeListBuilder.create().texOffs(40, 61).addBox(-1.5f, -3.5f, -0.5f, 3.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.645f, (float)2.0757f, (float)-3.664f, (float)-0.1658f, (float)0.0f, (float)-0.3142f));
        bodyLower.addOrReplaceChild("skirtRight", CubeListBuilder.create().texOffs(52, 38).addBox(-0.5f, -3.5f, -2.0f, 1.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.9579f, (float)1.8651f, (float)-1.1625f, (float)0.0f, (float)0.0f, (float)0.3142f));
        bodyLower.addOrReplaceChild("skirtLeft", CubeListBuilder.create().texOffs(0, 51).addBox(-0.5f, -3.5f, -2.0f, 1.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.971f, (float)1.8689f, (float)-1.2f, (float)0.0f, (float)0.0f, (float)-0.3142f));
        bodyLower.addOrReplaceChild("skirtRear", CubeListBuilder.create().texOffs(25, 0).addBox(-3.5f, -3.5f, -0.5f, 7.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0125f, (float)2.953f, (float)1.4667f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

