/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.common.entity.SolifugaeEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SolifugaeModel
extends HierarchicalModel<SolifugaeEntity> {
    public ModelPart root;
    public ModelPart bodyMain;
    public ModelPart headMain;
    public ModelPart legRightFrontUpper;
    public ModelPart legRightFrontLower;
    public ModelPart legLeftFrontUpper;
    public ModelPart legLeftFrontLower;
    public ModelPart legRightCenterFrontUpper;
    public ModelPart legRightCenterFrontLower;
    public ModelPart legLeftCenterFrontUpper;
    public ModelPart legLeftCenterFrontLower;
    public ModelPart legRightCenterRearUpper;
    public ModelPart legRightCenterRearLower;
    public ModelPart legLeftCenterRearUpper;
    public ModelPart legLeftCenterRearLower;
    public ModelPart legRightRearUpper;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRearUpper;
    public ModelPart legLeftRearLower;

    public SolifugaeModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyMain = this.root.getChild("bodyMain");
        this.headMain = this.bodyMain.getChild("headMain");
        this.legRightFrontUpper = this.bodyMain.getChild("legRightFrontUpper");
        this.legRightFrontLower = this.legRightFrontUpper.getChild("legRightFrontLower");
        this.legLeftFrontUpper = this.bodyMain.getChild("legLeftFrontUpper");
        this.legLeftFrontLower = this.legLeftFrontUpper.getChild("legLeftFrontLower");
        this.legRightCenterFrontUpper = this.bodyMain.getChild("legRightCenterFrontUpper");
        this.legRightCenterFrontLower = this.legRightCenterFrontUpper.getChild("legRightCenterFrontLower");
        this.legLeftCenterFrontUpper = this.bodyMain.getChild("legLeftCenterFrontUpper");
        this.legLeftCenterFrontLower = this.legLeftCenterFrontUpper.getChild("legLeftCenterFrontLower");
        this.legRightCenterRearUpper = this.bodyMain.getChild("legRightCenterRearUpper");
        this.legRightCenterRearLower = this.legRightCenterRearUpper.getChild("legRightCenterRearLower");
        this.legLeftCenterRearUpper = this.bodyMain.getChild("legLeftCenterRearUpper");
        this.legLeftCenterRearLower = this.legLeftCenterRearUpper.getChild("legLeftCenterRearLower");
        this.legRightRearUpper = this.bodyMain.getChild("legRightRearUpper");
        this.legRightRearLower = this.legRightRearUpper.getChild("legRightRearLower");
        this.legLeftRearUpper = this.bodyMain.getChild("legLeftRearUpper");
        this.legLeftRearLower = this.legLeftRearUpper.getChild("legLeftRearLower");
    }

    public void setupAnim(SolifugaeEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupRotateAngles();
        this.setupAnim(pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch);
    }

    public void setupRotateAngles() {
        IcariaClientHelper.setRotateAngles(this.headMain, -0.085f, 0.0f, 0.0f);
        IcariaClientHelper.setRotateAngles(this.legRightFrontUpper, -0.2233f, -0.7864f, 0.3079f);
        IcariaClientHelper.setRotateAngles(this.legLeftFrontUpper, -0.2445f, 0.7811f, -0.3441f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterFrontUpper, -0.0945f, -0.2698f, 0.2376f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterFrontUpper, -0.0944f, 0.2654f, -0.2372f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterRearUpper, 0.0946f, 0.2741f, 0.2381f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterRearUpper, 0.0946f, -0.2741f, -0.2381f);
        IcariaClientHelper.setRotateAngles(this.legRightRearUpper, 0.2227f, 0.781f, 0.304f);
        IcariaClientHelper.setRotateAngles(this.legLeftRearUpper, 0.2227f, -0.781f, -0.304f);
    }

    public void setupAnim(float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch) {
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float frontY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 4.712389f)) * 0.4f * pLimbSwingAmount;
        float frontZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 4.712389f)) * 0.4f) * pLimbSwingAmount;
        float centerFrontY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 1.5707964f)) * 0.4f * pLimbSwingAmount;
        float centerFrontZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 1.5707964f)) * 0.4f) * pLimbSwingAmount;
        float centerRearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + (float)Math.PI)) * 0.4f * pLimbSwingAmount;
        float centerRearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.4f) * pLimbSwingAmount;
        float rearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 0.0f)) * 0.4f * pLimbSwingAmount;
        float rearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 0.0f)) * 0.4f) * pLimbSwingAmount;
        this.legRightFrontUpper.yRot += frontY;
        this.legRightFrontUpper.zRot += frontZ;
        this.legLeftFrontUpper.yRot -= frontY;
        this.legLeftFrontUpper.zRot -= frontZ;
        this.legRightCenterFrontUpper.yRot += centerFrontY;
        this.legRightCenterFrontUpper.zRot += centerFrontZ;
        this.legLeftCenterFrontUpper.yRot -= centerFrontY;
        this.legLeftCenterFrontUpper.zRot -= centerFrontZ;
        this.legRightCenterRearUpper.yRot += centerRearY;
        this.legRightCenterRearUpper.zRot += centerRearZ;
        this.legLeftCenterRearUpper.yRot -= centerRearY;
        this.legLeftCenterRearUpper.zRot -= centerRearZ;
        this.legRightRearUpper.yRot += rearY;
        this.legRightRearUpper.zRot += rearZ;
        this.legLeftRearUpper.yRot -= rearY;
        this.legLeftRearUpper.zRot -= rearZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyMain = partDefinition.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(90, 27).addBox(-4.5f, -2.5f, -4.0f, 9.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.5f, (float)1.0f));
        PartDefinition headMain = bodyMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(54, 27).addBox(-5.0f, -4.0832f, -7.981f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-3.9375f, (float)-0.085f, (float)0.0f, (float)0.0f));
        headMain.addOrReplaceChild("eyeRight", CubeListBuilder.create().texOffs(56, 70).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.7f, (float)-3.7832f, (float)-7.681f));
        headMain.addOrReplaceChild("eyeLeft", CubeListBuilder.create().texOffs(56, 72).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.7f, (float)-3.7832f, (float)-7.681f));
        headMain.addOrReplaceChild("armRight", CubeListBuilder.create().texOffs(62, 0).addBox(-24.0f, -1.0f, -1.0f, 25.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)0.5168f, (float)-2.481f, (float)0.0f, (float)-1.1345f, (float)-0.2618f));
        headMain.addOrReplaceChild("armLeft", CubeListBuilder.create().texOffs(0, 27).addBox(-1.0f, -1.0f, -1.0f, 25.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)0.5168f, (float)-2.481f, (float)0.0f, (float)1.1345f, (float)0.2618f));
        PartDefinition jawMain = headMain.addOrReplaceChild("jawMain", CubeListBuilder.create().texOffs(0, 43).addBox(-3.95f, -2.958f, -4.4308f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.05f, (float)-0.1207f, (float)-8.006f, (float)0.096f, (float)0.0f, (float)0.0f));
        PartDefinition mouthMain = jawMain.addOrReplaceChild("mouthMain", CubeListBuilder.create().texOffs(28, 58).addBox(-2.9f, -2.6875f, -3.0f, 6.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.05f, (float)0.2295f, (float)-4.4308f));
        mouthMain.addOrReplaceChild("toothRightUpper", CubeListBuilder.create().texOffs(14, 70).addBox(-1.0f, -0.5f, -4.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.2f, (float)-1.6875f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        mouthMain.addOrReplaceChild("toothRightLower", CubeListBuilder.create().texOffs(0, 70).addBox(-1.0f, -0.5f, -4.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.2f, (float)1.3125f, (float)-3.0f, (float)-0.3f, (float)0.0f, (float)0.0f));
        mouthMain.addOrReplaceChild("toothLeftUpper", CubeListBuilder.create().texOffs(42, 70).addBox(-1.0f, -0.5f, -4.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)-1.6875f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        mouthMain.addOrReplaceChild("toothLeftLower", CubeListBuilder.create().texOffs(28, 70).addBox(-1.0f, -0.5f, -4.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.2f, (float)1.3125f, (float)-3.0f, (float)-0.3f, (float)0.0f, (float)0.0f));
        bodyMain.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -4.0875f, 0.0f, 12.0f, 8.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5125f, (float)3.0f));
        PartDefinition legRightFrontUpper = bodyMain.addOrReplaceChild("legRightFrontUpper", CubeListBuilder.create().texOffs(60, 66).addBox(-7.0053f, -1.0244f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)0.05f, (float)-4.0f, (float)-0.2233f, (float)-0.7864f, (float)0.3079f));
        legRightFrontUpper.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(84, 54).addBox(-11.4824f, -1.0178f, -1.0126f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftFrontUpper = bodyMain.addOrReplaceChild("legLeftFrontUpper", CubeListBuilder.create().texOffs(0, 66).addBox(-0.994f, -1.0243f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)0.075f, (float)-4.0f, (float)-0.2445f, (float)0.7811f, (float)-0.3441f));
        legLeftFrontUpper.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(28, 54).addBox(-11.482f, -0.9827f, -1.0124f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0944f));
        PartDefinition legRightCenterFrontUpper = bodyMain.addOrReplaceChild("legRightCenterFrontUpper", CubeListBuilder.create().texOffs(66, 58).addBox(-7.0057f, -1.0243f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)0.3f, (float)-2.3f, (float)-0.0945f, (float)-0.2698f, (float)0.2376f));
        legRightCenterFrontUpper.addOrReplaceChild("legRightCenterFrontLower", CubeListBuilder.create().texOffs(54, 43).addBox(-11.4827f, -1.0181f, -1.0126f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterFrontUpper = bodyMain.addOrReplaceChild("legLeftCenterFrontUpper", CubeListBuilder.create().texOffs(20, 66).addBox(-0.9943f, -1.0243f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)0.3f, (float)-2.3f, (float)-0.0944f, (float)0.2654f, (float)-0.2372f));
        legLeftCenterFrontUpper.addOrReplaceChild("legLeftCenterFrontLower", CubeListBuilder.create().texOffs(0, 54).addBox(-11.4827f, -0.982f, -1.0251f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightCenterRearUpper = bodyMain.addOrReplaceChild("legRightCenterRearUpper", CubeListBuilder.create().texOffs(46, 62).addBox(-7.0057f, -1.0243f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)0.3f, (float)-1.3f, (float)0.0946f, (float)0.2741f, (float)0.2381f));
        legRightCenterRearUpper.addOrReplaceChild("legRightCenterRearLower", CubeListBuilder.create().texOffs(26, 43).addBox(-11.4827f, -1.0181f, -0.9874f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterRearUpper = bodyMain.addOrReplaceChild("legLeftCenterRearUpper", CubeListBuilder.create().texOffs(46, 58).addBox(-0.9943f, -1.0243f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)0.3f, (float)-1.3f, (float)0.0946f, (float)-0.2741f, (float)-0.2381f));
        legLeftCenterRearUpper.addOrReplaceChild("legLeftCenterRearLower", CubeListBuilder.create().texOffs(26, 47).addBox(-11.4827f, -0.982f, -0.9874f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightRearUpper = bodyMain.addOrReplaceChild("legRightRearUpper", CubeListBuilder.create().texOffs(40, 66).addBox(-7.0053f, -1.0244f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)0.025f, (float)0.5f, (float)0.2227f, (float)0.781f, (float)0.304f));
        legRightRearUpper.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(56, 54).addBox(-11.4824f, -1.0178f, -0.9874f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftRearUpper = bodyMain.addOrReplaceChild("legLeftRearUpper", CubeListBuilder.create().texOffs(80, 66).addBox(-0.9947f, -1.0744f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)0.1f, (float)0.3f, (float)0.2227f, (float)-0.781f, (float)-0.304f));
        legLeftRearUpper.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(0, 58).addBox(-11.4824f, -0.9822f, -0.9874f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

