/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.SowEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SowModel
extends HierarchicalModel<SowEntity> {
    public SowEntity entity;
    public ModelPart root;
    public ModelPart body;
    public ModelPart head;
    public ModelPart mouth;
    public ModelPart tuskRightAdult;
    public ModelPart tuskLeftAdult;
    public ModelPart tuskRightTeen;
    public ModelPart tuskLeftTeen;
    public ModelPart legRightFront;
    public ModelPart legLeftFront;
    public ModelPart legRightRear;
    public ModelPart legLeftRear;

    public SowModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.body = this.root.getChild("body");
        this.head = this.root.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.tuskRightAdult = this.mouth.getChild("tuskRightAdult");
        this.tuskLeftAdult = this.mouth.getChild("tuskLeftAdult");
        this.tuskRightTeen = this.mouth.getChild("tuskRightTeen");
        this.tuskLeftTeen = this.mouth.getChild("tuskLeftTeen");
        this.legRightFront = this.root.getChild("legRightFront");
        this.legLeftFront = this.root.getChild("legLeftFront");
        this.legRightRear = this.root.getChild("legRightRear");
        this.legLeftRear = this.root.getChild("legLeftRear");
    }

    public void prepareMobModel(SowEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel((Entity)pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.entity = pEntity;
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        if (this.entity.getSize() < 2) {
            pPoseStack.pushPose();
            this.tuskRightAdult.visible = false;
            this.tuskLeftAdult.visible = false;
            this.tuskRightTeen.visible = false;
            this.tuskLeftTeen.visible = false;
            this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 3) {
            pPoseStack.pushPose();
            this.tuskRightAdult.visible = false;
            this.tuskLeftAdult.visible = false;
            this.tuskRightTeen.visible = false;
            this.tuskLeftTeen.visible = false;
            this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else if (this.entity.getSize() < 4) {
            pPoseStack.pushPose();
            this.tuskRightAdult.visible = false;
            this.tuskLeftAdult.visible = false;
            this.tuskRightTeen.visible = true;
            this.tuskLeftTeen.visible = true;
            this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        } else {
            pPoseStack.pushPose();
            this.tuskRightAdult.visible = true;
            this.tuskLeftAdult.visible = true;
            this.tuskRightTeen.visible = false;
            this.tuskLeftTeen.visible = false;
            this.root.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
            pPoseStack.popPose();
        }
    }

    public void setupAnim(SowEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.lookAnim(pNetHeadYaw, pHeadPitch);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.SOW_ATTACK, pAgeInTicks);
        this.animate(pEntity.eatingAnimationState, IcariaAnimations.SOW_EATING, pAgeInTicks);
    }

    public void lookAnim(float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = IcariaMath.rad(pHeadPitch) + 0.0834f;
        this.head.yRot = IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        this.root.y = Mth.sin((float)(pLimbSwing *= Mth.lerp((float)this.entity.getSize(), (float)0.5f, (float)1.0f))) * pLimbSwingAmount * 0.5f;
        this.legRightFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 0.0f)) * pLimbSwingAmount;
        this.legLeftFront.xRot = Mth.cos((float)(pLimbSwing * 0.5f + (float)Math.PI)) * pLimbSwingAmount;
        this.legRightRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 4.712389f)) * pLimbSwingAmount;
        this.legLeftRear.xRot = Mth.cos((float)(pLimbSwing * 0.5f + 1.5707964f)) * pLimbSwingAmount;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.5352f, -7.0f, 8.0f, 8.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)0.0f, (float)-0.0911f, (float)0.0f, (float)0.0f));
        PartDefinition rump = body.addOrReplaceChild("rump", CubeListBuilder.create().texOffs(20, 28).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)4.0f, (float)-0.1553f, (float)0.0f, (float)0.0f));
        rump.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(36, 47).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)2.0f, (float)0.5918f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("thighsFront", CubeListBuilder.create().texOffs(0, 19).addBox(-5.0f, -4.5f, -7.0f, 10.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.25f, (float)0.5f, (float)0.0911f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("thighsRear", CubeListBuilder.create().texOffs(28, 19).addBox(-4.5f, -4.5f, 1.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.25f, (float)0.9f, (float)0.0911f, (float)0.0f, (float)0.0f));
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(38, 0).addBox(-2.5f, -2.9991f, -7.4391f, 5.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0097f, (float)-4.4963f, (float)0.0834f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(36, 38).addBox(-1.5f, 0.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0E-4f, (float)-6.9391f, (float)0.182f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(10, 47).addBox(-1.0f, -0.5375f, -3.0125f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.5384f, (float)-7.4266f));
        mouth.addOrReplaceChild("tuskRightAdult", CubeListBuilder.create().texOffs(0, 52).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5375f, (float)-1.7125f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        mouth.addOrReplaceChild("tuskLeftAdult", CubeListBuilder.create().texOffs(42, 47).addBox(-0.5f, -2.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.5375f, (float)-1.7125f, (float)0.0f, (float)0.0f, (float)0.3927f));
        mouth.addOrReplaceChild("tuskRightTeen", CubeListBuilder.create().texOffs(8, 52).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5375f, (float)-1.7125f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        mouth.addOrReplaceChild("tuskLeftTeen", CubeListBuilder.create().texOffs(4, 52).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.5375f, (float)-1.7125f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -2.0156f, -2.9883f, 2.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.4991f, (float)-4.5391f, (float)0.0094f, (float)0.0f, (float)0.0f));
        hair.addOrReplaceChild("hairRear", CubeListBuilder.create().texOffs(0, 47).addBox(-1.0f, -0.0195f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.01f, (float)-2.0f, (float)5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(28, 47).addBox(-1.5f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.3125f, (float)-0.7491f, (float)-2.9391f, (float)0.3927f, (float)0.0f, (float)2.0944f));
        head.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(20, 47).addBox(-1.5f, -1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)-0.7491f, (float)-2.9391f, (float)-0.3927f, (float)0.0f, (float)1.0472f));
        partDefinition.addOrReplaceChild("legRightFront", CubeListBuilder.create().texOffs(0, 38).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)18.032f, (float)-4.7978f));
        partDefinition.addOrReplaceChild("legLeftFront", CubeListBuilder.create().texOffs(40, 28).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.032f, (float)-4.7978f));
        partDefinition.addOrReplaceChild("legRightRear", CubeListBuilder.create().texOffs(12, 38).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)18.0684f, (float)3.6006f));
        partDefinition.addOrReplaceChild("legLeftRear", CubeListBuilder.create().texOffs(24, 38).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)18.0684f, (float)3.6006f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }
}

