/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.model;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.client.registry.IcariaAnimations;
import com.axanthic.icaria.common.entity.VinegaroonEntity;
import com.axanthic.icaria.common.math.IcariaMath;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VinegaroonModel
extends HierarchicalModel<VinegaroonEntity> {
    public ModelPart root;
    public ModelPart bodyMain;
    public ModelPart headMain;
    public ModelPart armRightRear;
    public ModelPart armLeftRear;
    public ModelPart legRightCenterFrontUpper;
    public ModelPart legRightCenterFrontLower;
    public ModelPart legLeftCenterFrontUpper;
    public ModelPart legLeftCenterFrontLower;
    public ModelPart legRightCenterRearUpper;
    public ModelPart legRightCenterRearLower;
    public ModelPart legLeftCenterRearUpper;
    public ModelPart legLeftCenterRearLower;
    public ModelPart legRightRearUpper;
    public ModelPart legRightRearLower;
    public ModelPart legLeftRearUpper;
    public ModelPart legLeftRearLower;

    public VinegaroonModel(ModelPart pModelPart) {
        this.root = pModelPart;
        this.bodyMain = this.root.getChild("bodyMain");
        this.headMain = this.bodyMain.getChild("headMain");
        this.armRightRear = this.headMain.getChild("armRightRear");
        this.armLeftRear = this.headMain.getChild("armLeftRear");
        this.legRightCenterFrontUpper = this.bodyMain.getChild("legRightCenterFrontUpper");
        this.legRightCenterFrontLower = this.legRightCenterFrontUpper.getChild("legRightCenterFrontLower");
        this.legLeftCenterFrontUpper = this.bodyMain.getChild("legLeftCenterFrontUpper");
        this.legLeftCenterFrontLower = this.legLeftCenterFrontUpper.getChild("legLeftCenterFrontLower");
        this.legRightCenterRearUpper = this.bodyMain.getChild("legRightCenterRearUpper");
        this.legRightCenterRearLower = this.legRightCenterRearUpper.getChild("legRightCenterRearLower");
        this.legLeftCenterRearUpper = this.bodyMain.getChild("legLeftCenterRearUpper");
        this.legLeftCenterRearLower = this.legLeftCenterRearUpper.getChild("legLeftCenterRearLower");
        this.legRightRearUpper = this.bodyMain.getChild("legRightRearUpper");
        this.legRightRearLower = this.legRightRearUpper.getChild("legRightRearLower");
        this.legLeftRearUpper = this.bodyMain.getChild("legLeftRearUpper");
        this.legLeftRearLower = this.legLeftRearUpper.getChild("legLeftRearLower");
    }

    public void setupAnim(VinegaroonEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setupRotateAngles();
        this.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch);
        this.animate(pEntity.attackAnimationState, IcariaAnimations.VINEGAROON_ATTACK, pAgeInTicks);
    }

    public void setupRotateAngles() {
        IcariaClientHelper.setRotateAngles(this.headMain, 0.0f, 0.0f, 0.0f);
        IcariaClientHelper.setRotateAngles(this.armRightRear, 0.0f, -0.3f, 0.0f);
        IcariaClientHelper.setRotateAngles(this.armLeftRear, 0.0f, 0.3f, 0.0f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterFrontUpper, -0.0964f, -0.3076f, 0.2555f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterFrontUpper, -0.0922f, 0.3075f, -0.2558f);
        IcariaClientHelper.setRotateAngles(this.legRightCenterRearUpper, 0.092f, 0.3032f, 0.2554f);
        IcariaClientHelper.setRotateAngles(this.legLeftCenterRearUpper, 0.092f, -0.3032f, -0.2554f);
        IcariaClientHelper.setRotateAngles(this.legRightRearUpper, 0.2664f, 0.9177f, 0.375f);
        IcariaClientHelper.setRotateAngles(this.legLeftRearUpper, 0.2664f, -0.9177f, -0.375f);
    }

    public void setupAnim(VinegaroonEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch) {
        this.attackAnim(pEntity);
        this.lookAnim(pHeadPitch, pNetHeadYaw);
        this.walkAnim(pLimbSwing, pLimbSwingAmount);
    }

    public void attackAnim(VinegaroonEntity pEntity) {
        if (pEntity.hasExactlyOnePlayerPassenger()) {
            this.armRightRear.yRot -= 0.75f;
            this.armLeftRear.yRot += 0.75f;
        } else {
            this.armRightRear.yRot -= 0.0f;
            this.armLeftRear.yRot += 0.0f;
        }
    }

    public void lookAnim(float pHeadPitch, float pNetHeadYaw) {
        this.headMain.xRot += IcariaMath.rad(pHeadPitch);
        this.headMain.yRot += IcariaMath.rad(pNetHeadYaw);
    }

    public void walkAnim(float pLimbSwing, float pLimbSwingAmount) {
        float centerFrontY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 1.5707964f)) * 0.4f * pLimbSwingAmount;
        float centerFrontZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 1.5707964f)) * 0.4f) * pLimbSwingAmount;
        float centerRearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + (float)Math.PI)) * 0.4f * pLimbSwingAmount;
        float centerRearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + (float)Math.PI)) * 0.4f) * pLimbSwingAmount;
        float rearY = -Mth.cos((float)(pLimbSwing * 0.6f * 2.0f + 0.0f)) * 0.4f * pLimbSwingAmount;
        float rearZ = Math.abs(Mth.sin((float)(pLimbSwing * 0.6f + 0.0f)) * 0.4f) * pLimbSwingAmount;
        this.legRightCenterFrontUpper.yRot += centerFrontY;
        this.legRightCenterFrontUpper.zRot += centerFrontZ;
        this.legLeftCenterFrontUpper.yRot -= centerFrontY;
        this.legLeftCenterFrontUpper.zRot -= centerFrontZ;
        this.legRightCenterRearUpper.yRot += centerRearY;
        this.legRightCenterRearUpper.zRot += centerRearZ;
        this.legLeftCenterRearUpper.yRot -= centerRearY;
        this.legLeftCenterRearUpper.zRot -= centerRearZ;
        this.legRightRearUpper.yRot += rearY;
        this.legRightRearUpper.zRot += rearZ;
        this.legLeftRearUpper.yRot -= rearY;
        this.legLeftRearUpper.zRot -= rearZ;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition bodyMain = partDefinition.addOrReplaceChild("bodyMain", CubeListBuilder.create().texOffs(56, 0).addBox(-4.5f, -3.5f, -4.0f, 9.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.7f, (float)0.0f));
        PartDefinition headMain = bodyMain.addOrReplaceChild("headMain", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, -2.95f, -7.0125f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5625f, (float)-3.9875f));
        headMain.addOrReplaceChild("eyeRightFront", CubeListBuilder.create().texOffs(24, 67).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.65f, (float)-6.7125f));
        headMain.addOrReplaceChild("eyeLeftFront", CubeListBuilder.create().texOffs(18, 71).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.65f, (float)-6.7125f));
        headMain.addOrReplaceChild("eyeRightRear", CubeListBuilder.create().texOffs(18, 69).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.7f, (float)-2.65f, (float)-3.2125f));
        headMain.addOrReplaceChild("eyeLeftRear", CubeListBuilder.create().texOffs(24, 69).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.7f, (float)-2.65f, (float)-3.2125f));
        PartDefinition armRightRear = headMain.addOrReplaceChild("armRightRear", CubeListBuilder.create().texOffs(0, 55).addBox(-6.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)0.0375f, (float)-6.0125f, (float)0.0f, (float)-0.3f, (float)0.0f));
        PartDefinition armRightCenter = armRightRear.addOrReplaceChild("armRightCenter", CubeListBuilder.create().texOffs(40, 45).addBox(-7.0383f, -2.0f, -1.5747f, 7.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.8625f, (float)0.0f, (float)0.8875f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition armRightFront = armRightCenter.addOrReplaceChild("armRightFront", CubeListBuilder.create().texOffs(74, 61).addBox(-3.9112f, -2.0f, -1.2519f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0508f, (float)0.0125f, (float)-0.0247f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        armRightFront.addOrReplaceChild("fingerRightUpper", CubeListBuilder.create().texOffs(12, 71).addBox(-1.62f, -0.5125f, -0.4573f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.9112f, (float)-1.475f, (float)-0.2144f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        armRightFront.addOrReplaceChild("fingerRightLower", CubeListBuilder.create().texOffs(12, 67).addBox(-1.6302f, -0.5125f, -0.4501f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.8987f, (float)1.5f, (float)-0.2144f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        PartDefinition armLeftRear = headMain.addOrReplaceChild("armLeftRear", CubeListBuilder.create().texOffs(18, 55).addBox(0.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.05f, (float)-6.0125f, (float)0.0f, (float)0.3f, (float)0.0f));
        PartDefinition armLeftCenter = armLeftRear.addOrReplaceChild("armLeftCenter", CubeListBuilder.create().texOffs(60, 45).addBox(0.015f, -2.0f, -1.5901f, 7.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.8875f, (float)0.0f, (float)0.875f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition armLeftFront = armLeftCenter.addOrReplaceChild("armLeftFront", CubeListBuilder.create().texOffs(60, 61).addBox(-1.1025f, -2.0f, -1.2006f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.99f, (float)0.0125f, (float)-0.0776f, (float)0.0f, (float)1.0472f, (float)0.0f));
        armLeftFront.addOrReplaceChild("fingerLeftUpper", CubeListBuilder.create().texOffs(18, 67).addBox(-0.4158f, -0.5125f, -0.4061f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8975f, (float)-1.475f, (float)-0.2256f, (float)0.0f, (float)0.6109f, (float)0.0f));
        armLeftFront.addOrReplaceChild("fingerLeftLower", CubeListBuilder.create().texOffs(12, 69).addBox(-0.4158f, -0.5125f, -0.4061f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.8975f, (float)1.5f, (float)-0.2256f, (float)0.0f, (float)0.6109f, (float)0.0f));
        PartDefinition bodyRear = bodyMain.addOrReplaceChild("bodyRear", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.9625f, 0.0f, 10.0f, 6.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5375f, (float)3.0f));
        PartDefinition tailMain = bodyRear.addOrReplaceChild("tailMain", CubeListBuilder.create().texOffs(0, 67).addBox(-1.5f, -1.5f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0375f, (float)18.0f));
        PartDefinition tailFront = tailMain.addOrReplaceChild("tailFront", CubeListBuilder.create().texOffs(20, 45).addBox(-0.5f, -0.4698f, -0.1887f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0125f, (float)2.4875f, (float)0.1367f, (float)0.0f, (float)0.0f));
        tailFront.addOrReplaceChild("tailRear", CubeListBuilder.create().texOffs(0, 45).addBox(-0.4875f, -0.5048f, -0.0519f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0302f, (float)8.7863f, (float)0.1367f, (float)0.0f, (float)0.0f));
        PartDefinition legRightFrontUpper = bodyMain.addOrReplaceChild("legRightFrontUpper", CubeListBuilder.create().texOffs(30, 24).addBox(-14.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.3f, (float)-3.0f, (float)0.0f, (float)-0.9638f, (float)-0.4887f));
        legRightFrontUpper.addOrReplaceChild("legRightFrontLower", CubeListBuilder.create().texOffs(0, 37).addBox(-14.5f, -0.5f, -0.5f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-14.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)-0.3491f, (float)-0.0873f));
        PartDefinition legLeftFrontUpper = bodyMain.addOrReplaceChild("legLeftFrontUpper", CubeListBuilder.create().texOffs(30, 28).addBox(-1.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.3f, (float)-3.0f, (float)0.0f, (float)0.9638f, (float)0.4887f));
        legLeftFrontUpper.addOrReplaceChild("legLeftFrontLower", CubeListBuilder.create().texOffs(0, 39).addBox(-0.5f, -0.5f, -0.5f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.3491f, (float)0.0873f));
        PartDefinition legRightCenterFrontUpper = bodyMain.addOrReplaceChild("legRightCenterFrontUpper", CubeListBuilder.create().texOffs(76, 55).addBox(-7.006f, -1.0243f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.3f, (float)-1.3f, (float)-0.0964f, (float)-0.3076f, (float)0.2555f));
        legRightCenterFrontUpper.addOrReplaceChild("legRightCenterFrontLower", CubeListBuilder.create().texOffs(60, 37).addBox(-11.4829f, -1.0183f, -1.0125f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterFrontUpper = bodyMain.addOrReplaceChild("legLeftCenterFrontUpper", CubeListBuilder.create().texOffs(0, 61).addBox(-0.994f, -1.0243f, -0.9999f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.3f, (float)-1.3f, (float)-0.0922f, (float)0.3075f, (float)-0.2558f));
        legLeftCenterFrontUpper.addOrReplaceChild("legLeftCenterFrontLower", CubeListBuilder.create().texOffs(0, 41).addBox(-11.4829f, -0.9817f, -1.0124f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightCenterRearUpper = bodyMain.addOrReplaceChild("legRightCenterRearUpper", CubeListBuilder.create().texOffs(36, 55).addBox(-7.006f, -1.0243f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.3f, (float)-0.3f, (float)0.092f, (float)0.3032f, (float)0.2554f));
        legRightCenterRearUpper.addOrReplaceChild("legRightCenterRearLower", CubeListBuilder.create().texOffs(28, 41).addBox(-11.4829f, -1.0183f, -0.9876f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftCenterRearUpper = bodyMain.addOrReplaceChild("legLeftCenterRearUpper", CubeListBuilder.create().texOffs(56, 55).addBox(-0.994f, -1.0243f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.3f, (float)-0.3f, (float)0.092f, (float)-0.3032f, (float)-0.2554f));
        legLeftCenterRearUpper.addOrReplaceChild("legLeftCenterRearLower", CubeListBuilder.create().texOffs(32, 37).addBox(-11.4829f, -0.9817f, -0.9876f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        PartDefinition legRightRearUpper = bodyMain.addOrReplaceChild("legRightRearUpper", CubeListBuilder.create().texOffs(20, 61).addBox(-7.0056f, -1.0244f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)1.0375f, (float)1.5f, (float)0.2664f, (float)0.9177f, (float)0.375f));
        legRightRearUpper.addOrReplaceChild("legRightRearLower", CubeListBuilder.create().texOffs(84, 41).addBox(-11.4826f, -1.018f, -0.9876f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.9948f));
        PartDefinition legLeftRearUpper = bodyMain.addOrReplaceChild("legLeftRearUpper", CubeListBuilder.create().texOffs(40, 61).addBox(-0.9944f, -1.0244f, -1.0001f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)1.05f, (float)1.3f, (float)0.2664f, (float)-0.9177f, (float)-0.375f));
        legLeftRearUpper.addOrReplaceChild("legLeftRearLower", CubeListBuilder.create().texOffs(56, 41).addBox(-11.4826f, -0.982f, -0.9876f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.8f, (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.1468f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }
}

