/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.particle;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSteamParticle
extends TextureSheetParticle {
    public SpriteSet set;

    public IcariaSteamParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pSpeedX, double pSpeedY, double pSpeedZ, SpriteSet pSet) {
        super(pLevel, pX, pY, pZ);
        this.set = pSet;
        this.xd = pSpeedX;
        this.yd = pSpeedY;
        this.zd = pSpeedZ;
        this.lifetime = 80;
        this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 0.25f;
        this.setSize(0.1f, 0.1f);
        this.setSpriteFromAge(pSet);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd += 5.0E-4;
            this.move(this.xd, this.yd, this.zd);
            this.setSpriteFromAge(this.set);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

