/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.registry.IcariaRenderTypes;
import com.axanthic.icaria.common.entity.BubbleSpellEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BubbleSpellRenderer
extends EntityRenderer<BubbleSpellEntity> {
    public BubbleSpellRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(BubbleSpellEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight) {
        pPoseStack.pushPose();
        Random random = new Random(pEntity.getId());
        VertexConsumer consumer = pBufferSource.getBuffer(IcariaRenderTypes.ADDITIVE_TRANSPARENT);
        Matrix4f matrix4f = pPoseStack.last().pose();
        float scale = 0.25f;
        float ticks = pPartialTick + (float)pEntity.tickCount;
        int alpha = 255;
        int brightness = 50;
        int r0 = random.nextInt(brightness);
        int g0 = random.nextInt(brightness);
        int b0 = random.nextInt(brightness);
        int r1 = random.nextInt(brightness);
        int g1 = random.nextInt(brightness);
        int b1 = random.nextInt(brightness);
        int r2 = random.nextInt(brightness);
        int g2 = random.nextInt(brightness);
        int b2 = random.nextInt(brightness);
        int r3 = random.nextInt(brightness);
        int g3 = random.nextInt(brightness);
        int b3 = random.nextInt(brightness);
        int r4 = random.nextInt(brightness);
        int g4 = random.nextInt(brightness);
        int b4 = random.nextInt(brightness);
        int r5 = random.nextInt(brightness);
        int g5 = random.nextInt(brightness);
        int b5 = random.nextInt(brightness);
        int r6 = random.nextInt(brightness);
        int g6 = random.nextInt(brightness);
        int b6 = random.nextInt(brightness);
        int r7 = random.nextInt(brightness);
        int g7 = random.nextInt(brightness);
        int b7 = random.nextInt(brightness);
        pPoseStack.translate(0.0, 0.25, 0.0);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f + ticks * 0.5f));
        pPoseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f + ticks * 0.5f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + ticks * 0.5f));
        consumer.addVertex(matrix4f, -scale, -scale, scale).setColor(r0, g0, b0, alpha);
        consumer.addVertex(matrix4f, -scale, scale, scale).setColor(r1, g1, b1, alpha);
        consumer.addVertex(matrix4f, -scale, scale, -scale).setColor(r2, g2, b2, alpha);
        consumer.addVertex(matrix4f, -scale, -scale, -scale).setColor(r3, g3, b3, alpha);
        consumer.addVertex(matrix4f, -scale, -scale, -scale).setColor(r3, g3, b3, alpha);
        consumer.addVertex(matrix4f, -scale, scale, -scale).setColor(r2, g2, b2, alpha);
        consumer.addVertex(matrix4f, scale, scale, -scale).setColor(r4, g4, b4, alpha);
        consumer.addVertex(matrix4f, scale, -scale, -scale).setColor(r5, g5, b5, alpha);
        consumer.addVertex(matrix4f, scale, -scale, -scale).setColor(r5, g5, b5, alpha);
        consumer.addVertex(matrix4f, scale, scale, -scale).setColor(r4, g4, b4, alpha);
        consumer.addVertex(matrix4f, scale, scale, scale).setColor(r6, g6, b6, alpha);
        consumer.addVertex(matrix4f, scale, -scale, scale).setColor(r7, g7, b7, alpha);
        consumer.addVertex(matrix4f, scale, -scale, scale).setColor(r7, g7, b7, alpha);
        consumer.addVertex(matrix4f, scale, scale, scale).setColor(r6, g6, b6, alpha);
        consumer.addVertex(matrix4f, -scale, scale, scale).setColor(r1, g1, b1, alpha);
        consumer.addVertex(matrix4f, -scale, -scale, scale).setColor(r0, g0, b0, alpha);
        consumer.addVertex(matrix4f, scale, scale, scale).setColor(r6, g6, b6, alpha);
        consumer.addVertex(matrix4f, scale, scale, -scale).setColor(r4, g4, b4, alpha);
        consumer.addVertex(matrix4f, -scale, scale, -scale).setColor(r2, g2, b2, alpha);
        consumer.addVertex(matrix4f, -scale, scale, scale).setColor(r1, g1, b1, alpha);
        consumer.addVertex(matrix4f, -scale, -scale, -scale).setColor(r3, g3, b3, alpha);
        consumer.addVertex(matrix4f, scale, -scale, -scale).setColor(r5, g5, b5, alpha);
        consumer.addVertex(matrix4f, scale, -scale, scale).setColor(r7, g7, b7, alpha);
        consumer.addVertex(matrix4f, -scale, -scale, scale).setColor(r0, g0, b0, alpha);
        pPoseStack.popPose();
    }

    public ResourceLocation getTextureLocation(BubbleSpellEntity pEntity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

