/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.CrystalBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.AABB;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrystalBlockRenderer
implements BlockEntityRenderer<CrystalBlockEntity> {
    public CrystalBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public int getViewDistance() {
        return (Integer)IcariaConfig.RENDER_DISTANCE_CRYSTAL_RAYS.get();
    }

    public void render(CrystalBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        IcariaClientHelper.setPositionAndSize(pPoseStack, pBlockEntity.x, pBlockEntity.y, pBlockEntity.z, 1.0f);
        IcariaClientHelper.renderRays(pPoseStack, pBufferSource, pBlockEntity.red, pBlockEntity.green, pBlockEntity.blue);
        pPoseStack.popPose();
    }

    public AABB getRenderBoundingBox(CrystalBlockEntity pBlockEntity) {
        return AABB.INFINITE;
    }
}

