/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.layer.CrystalSlugEmissiveLayer;
import com.axanthic.icaria.client.layer.CrystalSlugRaysLayer;
import com.axanthic.icaria.client.model.CrystalSlugModel;
import com.axanthic.icaria.client.registry.IcariaLayerLocations;
import com.axanthic.icaria.common.entity.SlugEntity;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrystalSlugRenderer
extends MobRenderer<SlugEntity, CrystalSlugModel> {
    public CrystalSlugRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new CrystalSlugModel(pContext.bakeLayer(IcariaLayerLocations.CRYSTAL_SLUG_BODY)), 1.0f);
        this.addLayer(new CrystalSlugEmissiveLayer((RenderLayerParent<SlugEntity, CrystalSlugModel>)this));
        this.addLayer(new CrystalSlugRaysLayer((RenderLayerParent<SlugEntity, CrystalSlugModel>)this));
    }

    public float getShadowRadius(SlugEntity pEntity) {
        return pEntity.getScaleForShadow();
    }

    public void render(SlugEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        this.shadowStrength = pEntity.getShadowStrength();
    }

    public void scale(SlugEntity pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        pMatrixStack.scale(pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender());
        if (pLivingEntity.onClimbable()) {
            pMatrixStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            pMatrixStack.translate(0.0f, 0.25f, 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(SlugEntity pEntity) {
        return IcariaResourceLocations.CRYSTAL_SLUG;
    }
}

