/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.layer.FireJellyfishEmissiveLayer;
import com.axanthic.icaria.client.model.FireJellyfishModel;
import com.axanthic.icaria.client.registry.IcariaLayerLocations;
import com.axanthic.icaria.common.entity.JellyfishEntity;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FireJellyfishRenderer
extends MobRenderer<JellyfishEntity, FireJellyfishModel> {
    public FireJellyfishRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new FireJellyfishModel(pContext.bakeLayer(IcariaLayerLocations.FIRE_JELLYFISH)), 1.0f);
        this.addLayer(new FireJellyfishEmissiveLayer((RenderLayerParent<JellyfishEntity, FireJellyfishModel>)this));
    }

    public float getShadowRadius(JellyfishEntity pEntity) {
        return pEntity.getScaleForShadow();
    }

    public float getBob(JellyfishEntity pLivingBase, float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)pLivingBase.oldTentacleAngle, (float)pLivingBase.tentacleAngle);
    }

    public void scale(JellyfishEntity pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        pMatrixStack.scale(pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender());
    }

    public void setupRotations(JellyfishEntity pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float pScale) {
        float yRotation = 180.0f - pRotationYaw;
        float xRotation = Mth.lerp((float)pPartialTicks, (float)pEntityLiving.oldXBodyRot, (float)pEntityLiving.xBodyRot);
        float zRotation = Mth.lerp((float)pPartialTicks, (float)pEntityLiving.oldZBodyRot, (float)pEntityLiving.zBodyRot);
        pMatrixStack.translate(0.0f, pEntityLiving.getScaleForRender() * 0.5f, 0.0f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(yRotation));
        pMatrixStack.mulPose(Axis.XP.rotationDegrees(xRotation));
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(zRotation));
        pMatrixStack.translate(0.0f, pEntityLiving.getScaleForRender() * -1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(JellyfishEntity pEntity) {
        return IcariaResourceLocations.FIRE_JELLYFISH;
    }
}

