/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.entity.FloatingBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloatingBlockRenderer
extends EntityRenderer<FloatingBlockEntity> {
    public BlockRenderDispatcher blockRenderDispatcher;

    public FloatingBlockRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.blockRenderDispatcher = pContext.getBlockRenderDispatcher();
    }

    public void render(FloatingBlockEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Level level;
        BlockState blockState = pEntity.getBlockState();
        if (blockState.getRenderShape() == RenderShape.MODEL && blockState != (level = pEntity.level()).getBlockState(pEntity.blockPosition()) && blockState.getRenderShape() != RenderShape.INVISIBLE) {
            BakedModel bakedModel = this.blockRenderDispatcher.getBlockModel(blockState);
            BlockPos blockPos = BlockPos.containing((double)pEntity.getX(), (double)pEntity.getBoundingBox().maxY, (double)pEntity.getZ());
            pMatrixStack.pushPose();
            pMatrixStack.translate(-0.5, 0.0, -0.5);
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.create((long)blockState.getSeed(pEntity.getBlockPos())), ModelData.EMPTY)) {
                this.blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, bakedModel, blockState, blockPos, pMatrixStack, pBuffer.getBuffer(renderType), false, RandomSource.create(), blockState.getSeed(pEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            pMatrixStack.popPose();
            super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        }
    }

    public ResourceLocation getTextureLocation(FloatingBlockEntity pEntity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

