/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.ForgeBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForgeBlockRenderer
implements BlockEntityRenderer<ForgeBlockEntity> {
    public ForgeBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public int getViewDistance() {
        return (Integer)IcariaConfig.RENDER_DISTANCE_FORGE_ITEMS.get();
    }

    public void render(ForgeBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (((Boolean)IcariaConfig.RENDER_FORGE_ITEMS.get()).booleanValue()) {
            Direction facing = (Direction)pBlockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            ItemStack fuel = pBlockEntity.getFuel();
            ItemStack outputA = pBlockEntity.getOutputA();
            ItemStack outputB = pBlockEntity.getOutputB();
            float rotation = facing.toYRot() + 180.0f;
            if (!fuel.isEmpty()) {
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.translate(0.0f, 0.15f, 0.5f);
                } else if (facing == Direction.EAST) {
                    pPoseStack.translate(0.5f, 0.15f, 0.0f);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.translate(1.0f, 0.15f, 0.5f);
                } else if (facing == Direction.WEST) {
                    pPoseStack.translate(0.5f, 0.15f, 1.0f);
                }
                pPoseStack.scale(0.5f, 0.5f, 0.5f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
                Minecraft.getInstance().getItemRenderer().renderStatic(fuel, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
                pPoseStack.popPose();
            }
            if (!outputA.isEmpty()) {
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.translate((double)0.5125f, (double)1.2f, 0.3875);
                } else if (facing == Direction.EAST) {
                    pPoseStack.translate(0.6125, (double)1.2f, (double)0.5125f);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.translate(0.4875, (double)1.2f, 0.6125);
                } else if (facing == Direction.WEST) {
                    pPoseStack.translate(0.3875, (double)1.2f, 0.4875);
                }
                pPoseStack.scale(0.375f, 0.375f, 0.375f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
                Minecraft.getInstance().getItemRenderer().renderStatic(outputA, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
                pPoseStack.popPose();
            }
            if (!outputB.isEmpty()) {
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.translate(0.0, (double)0.9f, 0.3875);
                } else if (facing == Direction.EAST) {
                    pPoseStack.translate(0.6125, (double)0.9f, 0.0);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.translate(1.0, (double)0.9f, 0.6125);
                } else if (facing == Direction.WEST) {
                    pPoseStack.translate(0.3875, (double)0.9f, 1.0);
                }
                pPoseStack.scale(0.375f, 0.375f, 0.375f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
                Minecraft.getInstance().getItemRenderer().renderStatic(outputB, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 1);
                pPoseStack.popPose();
            }
        }
    }
}

