/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.GrinderBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrinderBlockRenderer
implements BlockEntityRenderer<GrinderBlockEntity> {
    public long prevTime;

    public GrinderBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public int getViewDistance() {
        return (Integer)IcariaConfig.RENDER_DISTANCE_GRINDER_GEARS.get();
    }

    public void render(GrinderBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (((Boolean)IcariaConfig.RENDER_GRINDER_GEARS.get()).booleanValue()) {
            BlockState state = pBlockEntity.getBlockState();
            ItemStack gear = pBlockEntity.getGear();
            Level level = pBlockEntity.getLevel();
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Boolean grinding = (Boolean)state.getValue((Property)IcariaBlockStateProperties.GRINDER_GRINDING);
            Minecraft minecraft = Minecraft.getInstance();
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            if (level != null) {
                long gameTime = level.getGameTime();
                float time = Mth.lerp((float)minecraft.getTimer().getGameTimeDeltaTicks(), (float)this.prevTime, (float)gameTime) * -16.0f;
                this.prevTime = gameTime;
                pPoseStack.pushPose();
                pPoseStack.translate(0.5f, 0.5f, 0.5f);
                pPoseStack.scale(2.0f, 2.0f, 2.0f);
                if (grinding.booleanValue()) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(time));
                }
                renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.GRINDER_STONE.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.translate(-0.5f, 0.5f, 0.5f);
                    pPoseStack.scale(2.0f, 2.0f, 2.0f);
                } else if (facing == Direction.EAST) {
                    pPoseStack.translate(0.5, 0.5, -0.5);
                    pPoseStack.scale(2.0f, 2.0f, 2.0f);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.translate(1.5f, 0.5f, 0.5f);
                    pPoseStack.scale(2.0f, 2.0f, 2.0f);
                } else if (facing == Direction.WEST) {
                    pPoseStack.translate(0.5f, 0.5f, 1.5f);
                    pPoseStack.scale(2.0f, 2.0f, 2.0f);
                }
                if (grinding.booleanValue()) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(time));
                }
                renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.GRINDER_SHAFT.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                pPoseStack.popPose();
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(0.5f, 0.405f, 0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.EAST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                    pPoseStack.translate(0.5f, 0.405f, -0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    pPoseStack.translate(-0.5f, 0.405f, -0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.WEST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    pPoseStack.translate(-0.5f, 0.405f, 0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                }
                if (grinding.booleanValue()) {
                    renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.LEFT_GRINDER_CHAIN.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                } else {
                    renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.STATIC_LEFT_GRINDER_CHAIN.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                }
                pPoseStack.popPose();
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(-0.5f, 0.405f, 0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.EAST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                    pPoseStack.translate(-0.5f, 0.405f, -0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    pPoseStack.translate(-1.5f, 0.405f, -0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                } else if (facing == Direction.WEST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    pPoseStack.translate(-1.5f, 0.405f, 0.5f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pPoseStack.scale(1.0f, 1.0f, 1.0f);
                }
                if (grinding.booleanValue()) {
                    renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.RIGHT_GRINDER_CHAIN.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                } else {
                    renderer.renderStatic(new ItemStack((ItemLike)IcariaItems.STATIC_RIGHT_GRINDER_CHAIN.get()), ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                }
                pPoseStack.popPose();
                pPoseStack.pushPose();
                if (facing == Direction.NORTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(-0.5f, 0.3425f, 0.5f);
                    pPoseStack.scale(0.625f, 1.0f, 0.625f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                } else if (facing == Direction.EAST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(0.5f, 0.3425f, -0.5f);
                    pPoseStack.scale(0.625f, 1.0f, 0.625f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                } else if (facing == Direction.SOUTH) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(1.5f, 0.3425f, 0.5f);
                    pPoseStack.scale(0.625f, 1.0f, 0.625f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                } else if (facing == Direction.WEST) {
                    pPoseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                    pPoseStack.translate(0.5f, 0.3425f, 1.5f);
                    pPoseStack.scale(0.625f, 1.0f, 0.625f);
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                }
                if (grinding.booleanValue()) {
                    pPoseStack.mulPose(Axis.ZN.rotationDegrees(time));
                }
                if (!gear.isEmpty()) {
                    renderer.renderStatic(gear, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                }
                pPoseStack.popPose();
            }
        }
    }

    public AABB getRenderBoundingBox(GrinderBlockEntity pBlockEntity) {
        return AABB.INFINITE;
    }
}

