/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.entity.IcariaChestBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.math.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaChestBlockRenderer
extends ChestRenderer<IcariaChestBlockEntity> {
    public Font font;
    public final ModelPart lid;
    public final ModelPart bottom;
    public final ModelPart lock;
    public final ModelPart doubleLeftLid;
    public final ModelPart doubleLeftBottom;
    public final ModelPart doubleLeftLock;
    public final ModelPart doubleRightLid;
    public final ModelPart doubleRightBottom;
    public final ModelPart doubleRightLock;

    public IcariaChestBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
        this.font = pContext.getFont();
        ModelPart left = pContext.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = left.getChild("bottom");
        this.doubleLeftLid = left.getChild("lid");
        this.doubleLeftLock = left.getChild("lock");
        ModelPart right = pContext.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = right.getChild("bottom");
        this.doubleRightLid = right.getChild("lid");
        this.doubleRightLock = right.getChild("lock");
        ModelPart single = pContext.bakeLayer(ModelLayers.CHEST);
        this.bottom = single.getChild("bottom");
        this.lid = single.getChild("lid");
        this.lock = single.getChild("lock");
    }

    public int getDarkColor(int pColor) {
        if (pColor == 0) {
            return -988212;
        }
        int r = (int)((float)FastColor.ARGB32.red((int)pColor) / 2.5f);
        int g = (int)((float)FastColor.ARGB32.green((int)pColor) / 2.5f);
        int b = (int)((float)FastColor.ARGB32.blue((int)pColor) / 2.5f);
        return FastColor.ARGB32.color((int)0, (int)r, (int)g, (int)b);
    }

    public void render(IcariaChestBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean flag = pBlockEntity.getLevel() != null;
        BlockState blockState = flag ? pBlockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.hasProperty((Property)BlockStateProperties.CHEST_TYPE) ? (ChestType)blockState.getValue((Property)BlockStateProperties.CHEST_TYPE) : ChestType.SINGLE;
        VertexConsumer vertexConsumer = this.getMaterial(pBlockEntity, chestType).buffer(pBuffer, RenderType::entityCutout);
        Block block = blockState.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock chestBlock = (AbstractChestBlock)block;
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
            pPoseStack.mulPose(Axis.YN.rotationDegrees(((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()));
            pPoseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? chestBlock.combine(blockState, pBlockEntity.getLevel(), pBlockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float angle = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)pBlockEntity))).get(pPartialTick);
            angle = 1.0f - angle;
            angle = 1.0f - angle * angle * angle;
            if (chestType.equals((Object)ChestType.SINGLE)) {
                this.render(angle, pPackedLight, pPackedOverlay, this.bottom, this.lid, this.lock, pPoseStack, vertexConsumer);
                this.renderSingle(pBlockEntity.hasLabelUp(), pBlockEntity.getStyleUp(), true, angle, 0.0f, pBlockEntity.getColorUp(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_lid", pBlockEntity.getLabelUp());
                if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.NORTH)) {
                    this.renderSingle(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 180.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front", pBlockEntity.getLabelNorth());
                    this.renderSingle(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 90.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right", pBlockEntity.getLabelEast());
                    this.renderSingle(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 0.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back", pBlockEntity.getLabelSouth());
                    this.renderSingle(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 270.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.EAST)) {
                    this.renderSingle(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 270.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left", pBlockEntity.getLabelNorth());
                    this.renderSingle(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 180.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front", pBlockEntity.getLabelEast());
                    this.renderSingle(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 90.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right", pBlockEntity.getLabelSouth());
                    this.renderSingle(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 0.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.SOUTH)) {
                    this.renderSingle(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 0.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back", pBlockEntity.getLabelNorth());
                    this.renderSingle(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 270.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left", pBlockEntity.getLabelEast());
                    this.renderSingle(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 180.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front", pBlockEntity.getLabelSouth());
                    this.renderSingle(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 90.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.WEST)) {
                    this.renderSingle(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 90.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right", pBlockEntity.getLabelNorth());
                    this.renderSingle(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 0.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back", pBlockEntity.getLabelEast());
                    this.renderSingle(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 270.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left", pBlockEntity.getLabelSouth());
                    this.renderSingle(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 180.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front", pBlockEntity.getLabelWest());
                }
            } else if (chestType.equals((Object)ChestType.RIGHT)) {
                this.render(angle, pPackedLight, pPackedOverlay, this.doubleRightBottom, this.doubleRightLid, this.doubleRightLock, pPoseStack, vertexConsumer);
                this.renderRight(pBlockEntity.hasLabelUp(), pBlockEntity.getStyleUp(), true, angle, 0.0f, pBlockEntity.getColorUp(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_lid_right", pBlockEntity.getLabelUp());
                if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.NORTH)) {
                    this.renderRight(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 180.0f, pBlockEntity.getColorNorth(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_right", pBlockEntity.getLabelNorth());
                    this.renderRight(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 90.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right_right", pBlockEntity.getLabelEast());
                    this.renderRight(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 0.0f, pBlockEntity.getColorSouth(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_right", pBlockEntity.getLabelSouth());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.EAST)) {
                    this.renderRight(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 180.0f, pBlockEntity.getColorEast(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_right", pBlockEntity.getLabelEast());
                    this.renderRight(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 90.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right_right", pBlockEntity.getLabelSouth());
                    this.renderRight(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 0.0f, pBlockEntity.getColorWest(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_right", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.SOUTH)) {
                    this.renderRight(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 0.0f, pBlockEntity.getColorNorth(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_right", pBlockEntity.getLabelNorth());
                    this.renderRight(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 180.0f, pBlockEntity.getColorSouth(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_right", pBlockEntity.getLabelSouth());
                    this.renderRight(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 90.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right_right", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.WEST)) {
                    this.renderRight(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 90.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_right_right", pBlockEntity.getLabelNorth());
                    this.renderRight(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 0.0f, pBlockEntity.getColorEast(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_right", pBlockEntity.getLabelEast());
                    this.renderRight(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 180.0f, pBlockEntity.getColorWest(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_right", pBlockEntity.getLabelWest());
                }
            } else if (chestType.equals((Object)ChestType.LEFT)) {
                this.render(angle, pPackedLight, pPackedOverlay, this.doubleLeftBottom, this.doubleLeftLid, this.doubleLeftLock, pPoseStack, vertexConsumer);
                this.renderLeft(pBlockEntity.hasLabelUp(), pBlockEntity.getStyleUp(), true, angle, 0.0f, pBlockEntity.getColorUp(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_lid_left", pBlockEntity.getLabelUp());
                if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.NORTH)) {
                    this.renderLeft(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 180.0f, pBlockEntity.getColorNorth(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_left", pBlockEntity.getLabelNorth());
                    this.renderLeft(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 270.0f, pBlockEntity.getColorWest(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left_left", pBlockEntity.getLabelWest());
                    this.renderLeft(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 0.0f, pBlockEntity.getColorSouth(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_left", pBlockEntity.getLabelSouth());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.EAST)) {
                    this.renderLeft(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 270.0f, pBlockEntity.getColorNorth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left_left", pBlockEntity.getLabelNorth());
                    this.renderLeft(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 180.0f, pBlockEntity.getColorEast(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_left", pBlockEntity.getLabelEast());
                    this.renderLeft(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 0.0f, pBlockEntity.getColorWest(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_left", pBlockEntity.getLabelWest());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.SOUTH)) {
                    this.renderLeft(pBlockEntity.hasLabelNorth(), pBlockEntity.getStyleNorth(), false, angle, 0.0f, pBlockEntity.getColorNorth(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_left", pBlockEntity.getLabelNorth());
                    this.renderLeft(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 270.0f, pBlockEntity.getColorEast(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left_left", pBlockEntity.getLabelEast());
                    this.renderLeft(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 180.0f, pBlockEntity.getColorSouth(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_left", pBlockEntity.getLabelSouth());
                } else if (((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).equals((Object)Direction.WEST)) {
                    this.renderLeft(pBlockEntity.hasLabelEast(), pBlockEntity.getStyleEast(), false, angle, 0.0f, pBlockEntity.getColorEast(), 5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_back_left", pBlockEntity.getLabelEast());
                    this.renderLeft(pBlockEntity.hasLabelSouth(), pBlockEntity.getStyleSouth(), false, angle, 270.0f, pBlockEntity.getColorSouth(), 0, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_left_left", pBlockEntity.getLabelSouth());
                    this.renderLeft(pBlockEntity.hasLabelWest(), pBlockEntity.getStyleWest(), false, angle, 180.0f, pBlockEntity.getColorWest(), -5, pPackedLight, pPackedOverlay, pBuffer, pPoseStack, "label_bottom_front_left", pBlockEntity.getLabelWest());
                }
            }
            pPoseStack.popPose();
        }
    }

    public void render(float pLidAngle, int pPackedLight, int pPackedOverlay, ModelPart pBottom, ModelPart pLid, ModelPart pLock, PoseStack pPoseStack, VertexConsumer pConsumer) {
        pLock.xRot = pLid.xRot = (float)Math.PI * pLidAngle * -0.5f;
        pLid.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLock.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottom.render(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    public void renderSingle(boolean pCheck, boolean pStyle, boolean pUp, float pAngle, float pRotation, int pColor, int pOffset, int pPackedLight, int pPackedOverlay, MultiBufferSource pBuffer, PoseStack pPoseStack, String pLabel, String pText) {
        if (pCheck) {
            this.renderSprite(pAngle, pPackedLight, pPackedOverlay, this.bottom, this.lid, this.lock, pBuffer, pPoseStack, pLabel);
            this.renderString(pStyle, pUp, pAngle, pRotation, pColor, pOffset, pPackedLight, pBuffer, pPoseStack, pText);
        }
    }

    public void renderRight(boolean pCheck, boolean pStyle, boolean pUp, float pAngle, float pRotation, int pColor, int pOffset, int pPackedLight, int pPackedOverlay, MultiBufferSource pBuffer, PoseStack pPoseStack, String pLabel, String pText) {
        if (pCheck) {
            this.renderSprite(pAngle, pPackedLight, pPackedOverlay, this.doubleRightBottom, this.doubleRightLid, this.doubleRightLock, pBuffer, pPoseStack, pLabel);
            this.renderString(pStyle, pUp, pAngle, pRotation, pColor, pOffset, pPackedLight, pBuffer, pPoseStack, pText);
        }
    }

    public void renderLeft(boolean pCheck, boolean pStyle, boolean pUp, float pAngle, float pRotation, int pColor, int pOffset, int pPackedLight, int pPackedOverlay, MultiBufferSource pBuffer, PoseStack pPoseStack, String pLabel, String pText) {
        if (pCheck) {
            this.renderSprite(pAngle, pPackedLight, pPackedOverlay, this.doubleLeftBottom, this.doubleLeftLid, this.doubleLeftLock, pBuffer, pPoseStack, pLabel);
            this.renderString(pStyle, pUp, pAngle, pRotation, pColor, pOffset, pPackedLight, pBuffer, pPoseStack, pText);
        }
    }

    public void renderSprite(float pAngle, int pPackedLight, int pPackedOverlay, ModelPart pBottom, ModelPart pLid, ModelPart pLock, MultiBufferSource pBuffer, PoseStack pPoseStack, String pString) {
        pPoseStack.pushPose();
        this.render(pAngle, pPackedLight, pPackedOverlay, pBottom, pLid, pLock, pPoseStack, new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)("entity/chest/" + pString))).buffer(pBuffer, RenderType::entityCutout));
        pPoseStack.popPose();
    }

    public void renderString(boolean pStyle, boolean pUp, float pAngle, float pRotation, int pColor, int pOffset, int pPackedLight, MultiBufferSource pBuffer, PoseStack pPoseStack, String pString) {
        FormattedCharSequence sequence = FormattedCharSequence.forward((String)pString, (Style)Style.EMPTY);
        pPoseStack.pushPose();
        if (pUp) {
            pPoseStack.translate(0.5f, 0.565f, 0.06f);
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.scale(1.0001f, 1.0001f, 1.0001f);
            pPoseStack.mulPose(Axis.XN.rotation((float)Math.PI * pAngle * 0.5f));
            pPoseStack.translate(0.0f, 0.405f, -0.31f);
        } else {
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(pRotation));
            pPoseStack.scale(1.0001f, 1.0001f, 1.0001f);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            pPoseStack.translate(0.0f, 0.275f, -0.4375f);
        }
        pPoseStack.scale(0.01f, 0.01f, 0.01f);
        if (pStyle) {
            this.font.drawInBatch8xOutline(sequence, (float)pOffset - (float)this.font.width(pString) * 0.5f, 0.0f, pColor, this.getDarkColor(pColor), pPoseStack.last().pose(), pBuffer, 0xF000F0);
        } else {
            this.font.drawInBatch(sequence, (float)pOffset - (float)this.font.width(pString) * 0.5f, 0.0f, pColor, false, pPoseStack.last().pose(), pBuffer, Font.DisplayMode.POLYGON_OFFSET, 0, pPackedLight);
        }
        pPoseStack.popPose();
    }

    public Material getMaterial(IcariaChestBlockEntity pBlockEntity, ChestType pChestType) {
        if (pChestType.equals((Object)ChestType.RIGHT)) {
            return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)("entity/chest/" + this.getType(pBlockEntity) + "_right")));
        }
        if (pChestType.equals((Object)ChestType.LEFT)) {
            return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)("entity/chest/" + this.getType(pBlockEntity) + "_left")));
        }
        return new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"landsoficaria", (String)("entity/chest/" + this.getType(pBlockEntity))));
    }

    public String getType(IcariaChestBlockEntity pBlockEntity) {
        if (pBlockEntity.getBlockState().getBlock().equals(IcariaBlocks.TRAPPED_CHEST.get())) {
            return "trapped";
        }
        return "normal";
    }
}

