/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.entity.IcariaChestBlockEntity;
import com.axanthic.icaria.common.entity.IcariaTrappedChestBlockEntity;
import com.axanthic.icaria.common.item.IcariaChestItem;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaChestItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public IcariaChestItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    public void renderByItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Item item = pStack.getItem();
        if (item instanceof IcariaChestItem) {
            IcariaChestItem chestItem = (IcariaChestItem)item;
            BlockState state = chestItem.getBlock().defaultBlockState();
            if (state.is(IcariaBlocks.CHEST.get())) {
                IcariaChestBlockEntity entity = new IcariaChestBlockEntity(BlockPos.ZERO, state);
                Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)entity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            } else if (state.is(IcariaBlocks.TRAPPED_CHEST.get())) {
                IcariaTrappedChestBlockEntity entity = new IcariaTrappedChestBlockEntity(BlockPos.ZERO, state);
                Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)entity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            }
        }
    }
}

