/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSignBlockRenderer
extends SignRenderer {
    public Font font;
    public Map<WoodType, SignRenderer.SignModel> map;

    public IcariaSignBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
        this.font = pContext.getFont();
        this.map = (Map)WoodType.values().collect(ImmutableMap.toImmutableMap(pWoodType -> pWoodType, pWoodType -> new SignRenderer.SignModel(pContext.bakeLayer(ModelLayers.createSignModelName((WoodType)pWoodType)))));
    }

    public boolean isOutlineVisible(BlockPos pBlockPos, int pColor) {
        if (pColor == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer != null && minecraft.options.getCameraType().isFirstPerson() && localPlayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pBlockPos)) < (double)Mth.square((int)16);
    }

    public void render(SignBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = pBlockEntity.getBlockState();
        SignBlock block = (SignBlock)blockState.getBlock();
        WoodType woodType = SignBlock.getWoodType((Block)block);
        SignRenderer.SignModel model = this.map.get(woodType);
        model.stick.visible = blockState.getBlock() instanceof StandingSignBlock;
        this.renderSignWithText(pBlockEntity, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, blockState, woodType, (Model)model);
    }

    public void renderSign(PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, WoodType pWoodType, Model pModel) {
        float scale = this.getSignModelRenderScale();
        pPoseStack.pushPose();
        pPoseStack.scale(scale, -scale, -scale);
        this.renderSignModel(pPoseStack, pPackedLight, pPackedOverlay, pModel, this.getSignMaterial(pWoodType).buffer(pBufferSource, arg_0 -> ((Model)pModel).renderType(arg_0)));
        pPoseStack.popPose();
    }

    public void renderSignModel(PoseStack pPoseStack, int pPackedLight, int pPackedOverlay, Model pModel, VertexConsumer pVertexConsumer) {
        if (pModel instanceof SignRenderer.SignModel) {
            SignRenderer.SignModel signModel = (SignRenderer.SignModel)pModel;
            signModel.root.render(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderSignText(BlockPos pBlockPos, SignText pSignText, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pLineHeight, int pLineWidth, boolean pBack) {
        boolean outline;
        int packedLight;
        int textColor;
        int darkColor = SignRenderer.getDarkColor((SignText)pSignText);
        int lineHeight = pLineHeight * 2;
        FormattedCharSequence[] formattedCharSequences = pSignText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), pComponent -> {
            List list = this.font.split((FormattedText)pComponent, pLineWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.getFirst();
        });
        pPoseStack.pushPose();
        this.translateSignText(pPoseStack, pBack, this.getTextOffset());
        if (pSignText.hasGlowingText()) {
            textColor = pSignText.getColor().getTextColor();
            packedLight = 0xF000F0;
            outline = this.isOutlineVisible(pBlockPos, textColor);
        } else {
            textColor = darkColor;
            packedLight = pPackedLight;
            outline = false;
        }
        for (int line = 0; line < 4; ++line) {
            FormattedCharSequence formattedCharSequence = formattedCharSequences[line];
            float width = this.font.width(formattedCharSequence) / -2;
            if (outline) {
                this.font.drawInBatch8xOutline(formattedCharSequence, width, (float)(line * pLineHeight - lineHeight), textColor, darkColor, pPoseStack.last().pose(), pBufferSource, packedLight);
                continue;
            }
            this.font.drawInBatch(formattedCharSequence, width, (float)(line * pLineHeight - lineHeight), textColor, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, packedLight);
        }
        pPoseStack.popPose();
    }

    public void renderSignWithText(SignBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, BlockState pBlockState, WoodType pWoodType, Model pModel) {
        pPoseStack.pushPose();
        this.translateSign(pPoseStack, pBlockState);
        this.renderSign(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, pWoodType, pModel);
        this.renderSignText(pBlockEntity.getBlockPos(), pBlockEntity.getFrontText(), pPoseStack, pBufferSource, pPackedLight, pBlockEntity.getTextLineHeight(), pBlockEntity.getMaxTextLineWidth(), true);
        this.renderSignText(pBlockEntity.getBlockPos(), pBlockEntity.getBackText(), pPoseStack, pBufferSource, pPackedLight, pBlockEntity.getTextLineHeight(), pBlockEntity.getMaxTextLineWidth(), false);
        pPoseStack.popPose();
    }

    public void translateSign(PoseStack pPoseStack, BlockState pBlockState) {
        if (pBlockState.getBlock() instanceof StandingSignBlock) {
            pPoseStack.translate(0.5, 0.75 * (double)this.getSignModelRenderScale(), 0.5);
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)((Integer)pBlockState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue() * -360.0f / 16.0f));
        } else {
            if (pBlockState.getValue((Property)BlockStateProperties.ATTACH_FACE) == AttachFace.WALL) {
                pPoseStack.translate(0.5, 0.5, 0.5);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(((Direction)pBlockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() * -1.0f));
                pPoseStack.translate(0.0, -0.3125, -0.4375);
            }
            if (pBlockState.getValue((Property)BlockStateProperties.ATTACH_FACE) == AttachFace.CEILING) {
                pPoseStack.translate(0.5, 0.5, 0.5);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(((Direction)pBlockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite().toYRot() * -1.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.translate(0.0, -0.3125, -0.4375);
            }
            if (pBlockState.getValue((Property)BlockStateProperties.ATTACH_FACE) == AttachFace.FLOOR) {
                pPoseStack.translate(0.5, 0.5, 0.5);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(((Direction)pBlockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite().toYRot() * -1.0f));
                pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                pPoseStack.translate(0.0, -0.3125, -0.4375);
            }
        }
    }

    public void translateSignText(PoseStack pPoseStack, boolean pBack, Vec3 pVec3) {
        float scale = this.getSignTextRenderScale() * 0.015625f;
        if (!pBack) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        pPoseStack.translate(pVec3.x, pVec3.y, pVec3.z);
        pPoseStack.scale(scale, -scale, scale);
    }

    public Material getSignMaterial(WoodType pWoodType) {
        return Sheets.getSignMaterial((WoodType)pWoodType);
    }

    public Vec3 getTextOffset() {
        return new Vec3(0.0, 0.33333334, 0.046666667);
    }
}

