/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.model.AeternaeSkullModel;
import com.axanthic.icaria.client.model.ArganHoundSkullModel;
import com.axanthic.icaria.client.model.CatoblepasSkullModel;
import com.axanthic.icaria.client.model.CerverSkullModel;
import com.axanthic.icaria.client.model.CypressForestHagSkullModel;
import com.axanthic.icaria.client.model.DroughtrootForestHagSkullModel;
import com.axanthic.icaria.client.model.FirForestHagSkullModel;
import com.axanthic.icaria.client.model.LaurelForestHagSkullModel;
import com.axanthic.icaria.client.model.OliveForestHagSkullModel;
import com.axanthic.icaria.client.model.PlaneForestHagSkullModel;
import com.axanthic.icaria.client.model.PopulusForestHagSkullModel;
import com.axanthic.icaria.client.model.RevenantSkullModel;
import com.axanthic.icaria.client.model.SowSkullModel;
import com.axanthic.icaria.client.registry.IcariaLayerLocations;
import com.axanthic.icaria.common.block.IcariaAbstractSkullBlock;
import com.axanthic.icaria.common.block.IcariaWallSkullBlock;
import com.axanthic.icaria.common.entity.IcariaSkullBlockEntity;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.axanthic.icaria.common.util.IcariaSkullBlockType;
import com.axanthic.icaria.common.util.IcariaSkullBlockTypes;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSkullBlockRenderer
implements BlockEntityRenderer<IcariaSkullBlockEntity> {
    public Map<IcariaSkullBlockType, SkullModel> map;
    public static final Map<IcariaSkullBlockType, ResourceLocation> RL_BY_TYPE = (Map)Util.make((Object)Maps.newHashMap(), pMap -> {
        pMap.put(IcariaSkullBlockTypes.AETERNAE, IcariaResourceLocations.AETERNAE);
        pMap.put(IcariaSkullBlockTypes.ARGAN_HOUND, IcariaResourceLocations.ARGAN_HOUND);
        pMap.put(IcariaSkullBlockTypes.CAPELLA, IcariaResourceLocations.CAPELLA);
        pMap.put(IcariaSkullBlockTypes.CATOBLEPAS, IcariaResourceLocations.CATOBLEPAS);
        pMap.put(IcariaSkullBlockTypes.CERVER, IcariaResourceLocations.CERVER);
        pMap.put(IcariaSkullBlockTypes.CROCOTTA, IcariaResourceLocations.CROCOTTA);
        pMap.put(IcariaSkullBlockTypes.CYPRESS_FOREST_HAG, IcariaResourceLocations.CYPRESS_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.DROUGHTROOT_FOREST_HAG, IcariaResourceLocations.DROUGHTROOT_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.FIR_FOREST_HAG, IcariaResourceLocations.FIR_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.LAUREL_FOREST_HAG, IcariaResourceLocations.LAUREL_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.OLIVE_FOREST_HAG, IcariaResourceLocations.OLIVE_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.PLANE_FOREST_HAG, IcariaResourceLocations.PLANE_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.POPULUS_FOREST_HAG, IcariaResourceLocations.POPULUS_FOREST_HAG);
        pMap.put(IcariaSkullBlockTypes.REVENANT, IcariaResourceLocations.CAPTAIN_REVENANT);
        pMap.put(IcariaSkullBlockTypes.SOW, IcariaResourceLocations.SOW);
    });

    public IcariaSkullBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        this.map = IcariaSkullBlockRenderer.createRenderers(pContext.getModelSet());
    }

    public void render(IcariaSkullBlockEntity pBlockEntity, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pCombinedLight, int pCombinedOverlay) {
        BlockState blockState = pBlockEntity.getBlockState();
        boolean wall = blockState.getBlock() instanceof IcariaWallSkullBlock;
        Direction direction = wall ? (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : null;
        float rotation = wall ? ((float)direction.get2DDataValue() + 2.0f) * 4.0f : (float)((Integer)blockState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue();
        IcariaSkullBlockRenderer.renderSkull(direction, rotation * 22.5f, pPoseStack, pBufferSource, pCombinedLight, this.map, blockState.getBlock());
    }

    public static void renderSkull(@Nullable Direction pDirection, float pRotation, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pCombinedLight, Map<IcariaSkullBlockType, SkullModel> pMap, Block pBlock) {
        if (pBlock instanceof IcariaAbstractSkullBlock) {
            IcariaAbstractSkullBlock icariaAbstractSkullBlock = (IcariaAbstractSkullBlock)pBlock;
            float offset = icariaAbstractSkullBlock.getOffset();
            IcariaSkullBlockType block = icariaAbstractSkullBlock.getType();
            SkullModel model = pMap.get(block);
            ResourceLocation resourceLocation = RL_BY_TYPE.get(block);
            VertexConsumer vertexConsumer = pBufferSource.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourceLocation));
            pPoseStack.pushPose();
            if (pDirection == null) {
                pPoseStack.translate(0.5, 0.0, 0.5);
            } else {
                pPoseStack.translate(0.5 - (double)pDirection.getStepX() * (0.25 + (double)offset), 0.25, 0.5 - (double)pDirection.getStepZ() * (0.25 + (double)offset));
            }
            pPoseStack.scale(-1.0f, -1.0f, 1.0f);
            model.setupAnim(0.0f, pRotation, 0.0f);
            model.renderToBuffer(pPoseStack, vertexConsumer, pCombinedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.popPose();
        }
    }

    public static Map<IcariaSkullBlockType, SkullModel> createRenderers(EntityModelSet pSet) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)IcariaSkullBlockTypes.AETERNAE, (Object)new AeternaeSkullModel(pSet.bakeLayer(IcariaLayerLocations.AETERNAE_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.ARGAN_HOUND, (Object)new ArganHoundSkullModel(pSet.bakeLayer(IcariaLayerLocations.ARGAN_HOUND_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.CAPELLA, (Object)new ArganHoundSkullModel(pSet.bakeLayer(IcariaLayerLocations.CAPELLA_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.CATOBLEPAS, (Object)new CatoblepasSkullModel(pSet.bakeLayer(IcariaLayerLocations.CATOBLEPAS_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.CERVER, (Object)new CerverSkullModel(pSet.bakeLayer(IcariaLayerLocations.CERVER_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.CROCOTTA, (Object)new ArganHoundSkullModel(pSet.bakeLayer(IcariaLayerLocations.CROCOTTA_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.CYPRESS_FOREST_HAG, (Object)new CypressForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.CYPRESS_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.DROUGHTROOT_FOREST_HAG, (Object)new DroughtrootForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.DROUGHTROOT_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.FIR_FOREST_HAG, (Object)new FirForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.FIR_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.LAUREL_FOREST_HAG, (Object)new LaurelForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.LAUREL_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.OLIVE_FOREST_HAG, (Object)new OliveForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.OLIVE_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.PLANE_FOREST_HAG, (Object)new PlaneForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.PLANE_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.POPULUS_FOREST_HAG, (Object)new PopulusForestHagSkullModel(pSet.bakeLayer(IcariaLayerLocations.POPULUS_FOREST_HAG_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.REVENANT, (Object)new RevenantSkullModel(pSet.bakeLayer(IcariaLayerLocations.REVENANT_SKULL)));
        builder.put((Object)IcariaSkullBlockTypes.SOW, (Object)new SowSkullModel(pSet.bakeLayer(IcariaLayerLocations.SOW_SKULL)));
        return builder.build();
    }
}

