/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.entity.IcariaSpawnerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaSpawnerBlockRenderer
implements BlockEntityRenderer<IcariaSpawnerBlockEntity> {
    public EntityRenderDispatcher entityRenderer;

    public IcariaSpawnerBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        this.entityRenderer = pContext.getEntityRenderer();
    }

    public void render(IcariaSpawnerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Entity entity;
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.0f, 0.5f);
        BaseSpawner blockEntity = pBlockEntity.getSpawner();
        if (pBlockEntity.getLevel() != null && (entity = blockEntity.getOrCreateDisplayEntity(pBlockEntity.getLevel(), pBlockEntity.getBlockPos())) != null) {
            float size = 0.53125f;
            float bb = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if (bb > 1.0f) {
                size /= bb;
            }
            pPoseStack.translate(0.0f, 0.4f, 0.0f);
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)Mth.lerp((double)pPartialTick, (double)blockEntity.getoSpin(), (double)blockEntity.getSpin()) * 10.0f));
            pPoseStack.translate(0.0f, -0.2f, 0.0f);
            pPoseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
            pPoseStack.scale(size, size, size);
            this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pPoseStack, pBufferSource, pPackedLight);
        }
        pPoseStack.popPose();
    }
}

