/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.block.KettleBlock;
import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.KettleBlockEntity;
import com.axanthic.icaria.common.properties.Kettle;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class KettleBlockRenderer
implements BlockEntityRenderer<KettleBlockEntity> {
    public long prevTime;

    public KettleBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public int getViewDistance() {
        return (Integer)IcariaConfig.RENDER_DISTANCE_KETTLE_ITEMS.get();
    }

    public void render(KettleBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState state = pBlockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ItemStack ingA = pBlockEntity.getIngA();
        ItemStack ingB = pBlockEntity.getIngB();
        ItemStack ingC = pBlockEntity.getIngC();
        Level level = pBlockEntity.getLevel();
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        if (level != null) {
            long gameTime = level.getGameTime();
            float time = Mth.lerp((float)minecraft.getTimer().getGameTimeDeltaTicks(), (float)this.prevTime, (float)gameTime) * -2.0f;
            float radius = 0.15f;
            float scale = 0.125f;
            float speed = 0.025f;
            float yLevel = 0.55f;
            float yRange = 0.025f;
            float ySpeed = 0.025f;
            this.prevTime = gameTime;
            Block block = state.getBlock();
            if (block instanceof KettleBlock) {
                KettleBlock kettleBlock = (KettleBlock)block;
                double x = kettleBlock.getX(state);
                double z = kettleBlock.getZ(state);
                if (state.getValue(IcariaBlockStateProperties.KETTLE) != Kettle.EMPTY) {
                    if (facing == Direction.NORTH) {
                        this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.25f, 0.75f, 0.09375f, 0.59375f, pPackedLight, pPackedOverlay);
                    } else if (facing == Direction.EAST) {
                        this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.40625f, 0.90625f, 0.25f, 0.75f, pPackedLight, pPackedOverlay);
                    } else if (facing == Direction.SOUTH) {
                        this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.25f, 0.75f, 0.40625f, 0.90625f, pPackedLight, pPackedOverlay);
                    } else if (facing == Direction.WEST) {
                        this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.09375f, 0.59375f, 0.25f, 0.75f, pPackedLight, pPackedOverlay);
                    }
                    if (((Boolean)IcariaConfig.RENDER_KETTLE_ITEMS.get()).booleanValue()) {
                        if (!ingA.isEmpty()) {
                            pPoseStack.pushPose();
                            pPoseStack.translate((double)(Mth.sin((float)(time * speed)) * radius) + x, (double)(Mth.sin((float)(time * ySpeed)) * yRange + yLevel), (double)(Mth.cos((float)(time * speed)) * radius) + z);
                            pPoseStack.scale(scale, scale, scale);
                            pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(time * 0.05f)) * 8.0f));
                            pPoseStack.mulPose(Axis.YP.rotationDegrees(time));
                            pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.cos((float)(time * 0.05f)) * 8.0f));
                            itemRenderer.renderStatic(ingA, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                            pPoseStack.popPose();
                        }
                        if (!ingB.isEmpty()) {
                            pPoseStack.pushPose();
                            pPoseStack.translate((double)(Mth.sin((float)(time * speed + 7.5f)) * radius) + x, (double)(Mth.sin((float)(time * ySpeed + 7.5f)) * yRange + yLevel), (double)(Mth.cos((float)(time * speed + 7.5f)) * radius) + z);
                            pPoseStack.scale(scale, scale, scale);
                            pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(time * 0.05f + 45.0f)) * 8.0f));
                            pPoseStack.mulPose(Axis.YP.rotationDegrees(time + 45.0f));
                            pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.cos((float)(time * 0.05f + 45.0f)) * 8.0f));
                            itemRenderer.renderStatic(ingB, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                            pPoseStack.popPose();
                        }
                        if (!ingC.isEmpty()) {
                            pPoseStack.pushPose();
                            pPoseStack.translate((double)(Mth.sin((float)(time * speed + 15.0f)) * radius) + x, (double)(Mth.sin((float)(time * ySpeed + 15.0f)) * yRange + yLevel), (double)(Mth.cos((float)(time * speed + 15.0f)) * radius) + z);
                            pPoseStack.scale(scale, scale, scale);
                            pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)(time * 0.05f + 90.0f)) * 8.0f));
                            pPoseStack.mulPose(Axis.YP.rotationDegrees(time + 90.0f));
                            pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.cos((float)(time * 0.05f + 90.0f)) * 8.0f));
                            itemRenderer.renderStatic(ingC, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                            pPoseStack.popPose();
                        }
                    }
                }
            }
        }
    }

    public void renderQuad(KettleBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, float pMinX, float pMaxX, float pMinZ, float pMaxZ, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.getLevel() != null) {
            TextureAtlasSprite sprite;
            float b;
            float g;
            float r;
            float height;
            int endColor = pBlockEntity.color;
            int startColor = BiomeColors.getAverageWaterColor((BlockAndTintGetter)pBlockEntity.getLevel(), (BlockPos)pBlockEntity.getBlockPos());
            VertexConsumer consumer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f matrix4f = pPoseStack.last().pose();
            Minecraft minecraft = Minecraft.getInstance();
            BlockState state = pBlockEntity.getBlockState();
            if (state.getValue(IcariaBlockStateProperties.KETTLE) == Kettle.BREWING) {
                height = 0.6875f + (float)pBlockEntity.progress / (float)pBlockEntity.maxProgress * 0.0625f;
                r = Mth.lerp((float)((float)pBlockEntity.progress / (float)pBlockEntity.maxProgress), (float)((float)(startColor >> 16 & 0xFF) / 255.0f), (float)((float)(endColor >> 16 & 0xFF) / 255.0f));
                g = Mth.lerp((float)((float)pBlockEntity.progress / (float)pBlockEntity.maxProgress), (float)((float)(startColor >> 8 & 0xFF) / 255.0f), (float)((float)(endColor >> 8 & 0xFF) / 255.0f));
                b = Mth.lerp((float)((float)pBlockEntity.progress / (float)pBlockEntity.maxProgress), (float)((float)(startColor & 0xFF) / 255.0f), (float)((float)(endColor & 0xFF) / 255.0f));
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.CONCOCTION_FAST);
            } else {
                height = 0.6875f;
                r = (float)(startColor >> 16 & 0xFF) / 255.0f;
                g = (float)(startColor >> 8 & 0xFF) / 255.0f;
                b = (float)(startColor & 0xFF) / 255.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.CONCOCTION_SLOW);
            }
            pPoseStack.pushPose();
            consumer.addVertex(matrix4f, pMinX, height, pMinZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(0.25f), sprite.getV(0.25f)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMinX, height, pMaxZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(0.75f), sprite.getV(0.25f)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMaxX, height, pMaxZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(0.75f), sprite.getV(0.75f)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMaxX, height, pMinZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(0.25f), sprite.getV(0.75f)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
    }
}

