/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.KilnBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class KilnBlockRenderer
implements BlockEntityRenderer<KilnBlockEntity> {
    public KilnBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public int getViewDistance() {
        return (Integer)IcariaConfig.RENDER_DISTANCE_KILN_ITEMS.get();
    }

    public void render(KilnBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (((Boolean)IcariaConfig.RENDER_KILN_ITEMS.get()).booleanValue()) {
            float rotation = ((Direction)pBlockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180.0f;
            ItemStack fuel = pBlockEntity.getFuel();
            ItemStack input = pBlockEntity.getInput();
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            Level level = pBlockEntity.getLevel();
            if (!fuel.isEmpty()) {
                pPoseStack.pushPose();
                pPoseStack.translate(0.5f, 0.2f, 0.5f);
                pPoseStack.scale(0.25f, 0.25f, 0.25f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
                itemRenderer.renderStatic(fuel, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                pPoseStack.popPose();
            }
            if (!input.isEmpty()) {
                pPoseStack.pushPose();
                pPoseStack.translate(0.5f, 0.635f, 0.5f);
                pPoseStack.scale(0.25f, 0.25f, 0.25f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
                itemRenderer.renderStatic(input, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, level, 1);
                pPoseStack.popPose();
            }
        }
    }
}

