/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.item.ScrollItem;
import com.axanthic.icaria.common.recipe.ConcoctingItemRecipe;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScrollItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public ScrollItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    public void renderByItem(ItemStack pStack, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        int height = window.getHeight();
        int width = window.getWidth();
        VertexConsumer consumer = pBuffer.getBuffer(Sheets.translucentCullBlockSheet());
        Matrix4f matrix4f = pPoseStack.last().pose();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        ClientLevel level = minecraft.level;
        LocalPlayer player = minecraft.player;
        TextureAtlasSprite sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.SCROLL);
        if (player != null) {
            ItemStack mainHandItem = player.getMainHandItem();
            ItemStack offHandItem = player.getOffhandItem();
            pPoseStack.scale(1.0f, 1.0f, 1.0f);
            if (mainHandItem == pStack) {
                pPoseStack.translate((float)width / (float)height * 0.85f - 1.25f, 0.5f, 0.0f);
            } else if (offHandItem == pStack) {
                pPoseStack.translate((float)width / (float)height * -0.85f + 1.25f, 0.5f, 0.0f);
            }
            consumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV1()).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, 1.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV1()).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, 1.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU1(), sprite.getV0()).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, 0.0f, 1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(sprite.getU0(), sprite.getV0()).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 0.0f, 1.0f);
            Item item = pStack.getItem();
            if (item instanceof ScrollItem) {
                ScrollItem scrollItem = (ScrollItem)item;
                ConcoctingItemRecipe recipe = scrollItem.getRecipe();
                NonNullList<Ingredient> ingredients = recipe.getIngredients();
                ItemStack ingC = Arrays.stream(((Ingredient)ingredients.get(2)).getItems()).findFirst().get();
                ItemStack ingB = Arrays.stream(((Ingredient)ingredients.get(1)).getItems()).findFirst().get();
                ItemStack ingA = Arrays.stream(((Ingredient)ingredients.get(0)).getItems()).findFirst().get();
                ItemStack output = recipe.getResultItem(null);
                pPoseStack.scale(1.0f, 1.0f, 1.0f);
                pPoseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                pPoseStack.translate(0.5f, -0.75f, 0.0f);
                pPoseStack.scale(0.007f, 0.007f, 0.007f);
                this.renderString(0, pPackedLight, (Component)Component.translatable((String)output.getItem().getDescriptionId()), matrix4f, pBuffer);
                pPoseStack.scale(13.5f, 13.5f, 0.1f);
                pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                pPoseStack.translate(1.5f, -2.0f, 0.0f);
                itemRenderer.renderStatic(ingC, ItemDisplayContext.GUI, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, (Level)level, 0);
                pPoseStack.translate(-1.5f, 0.0f, 0.0f);
                itemRenderer.renderStatic(ingB, ItemDisplayContext.GUI, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, (Level)level, 0);
                pPoseStack.translate(-1.5f, 0.0f, 0.0f);
                itemRenderer.renderStatic(ingA, ItemDisplayContext.GUI, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, (Level)level, 0);
                pPoseStack.translate(1.5f, -2.6375f, 0.0f);
                pPoseStack.scale(2.625f, 2.625f, 1.0f);
                itemRenderer.renderStatic(output, ItemDisplayContext.GUI, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, (Level)level, 0);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.getSkin().texture());
            pPoseStack.scale(5.0f, 5.0f, 5.0f);
            item = minecraft.getEntityRenderDispatcher().getRenderer((Entity)player);
            if (item instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)item;
                if (offHandItem == pStack) {
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(150.0f));
                    pPoseStack.mulPose(Axis.ZN.rotationDegrees(75.0f));
                    pPoseStack.translate(0.0f, -1.01f, -0.25f);
                    playerRenderer.renderLeftHand(pPoseStack, pBuffer, pPackedLight, (AbstractClientPlayer)player);
                } else if (mainHandItem == pStack) {
                    pPoseStack.mulPose(Axis.XP.rotationDegrees(150.0f));
                    pPoseStack.mulPose(Axis.ZP.rotationDegrees(75.0f));
                    pPoseStack.translate(0.0f, -1.01f, -0.25f);
                    playerRenderer.renderRightHand(pPoseStack, pBuffer, pPackedLight, (AbstractClientPlayer)player);
                    if (offHandItem.isEmpty()) {
                        pPoseStack.mulPose(Axis.XP.rotationDegrees(25.0f));
                        pPoseStack.mulPose(Axis.ZP.rotationDegrees(122.5f));
                        pPoseStack.translate(0.625f, -1.5f, -0.2f);
                        playerRenderer.renderLeftHand(pPoseStack, pBuffer, pPackedLight, (AbstractClientPlayer)player);
                    }
                }
            }
        }
        pPoseStack.popPose();
    }

    public void renderString(int pOffset, int pPackedLight, Component pComponent, Matrix4f pMatrix4f, MultiBufferSource pBuffer) {
        Minecraft.getInstance().font.drawInBatch(pComponent, (float)pOffset - (float)Minecraft.getInstance().font.width((FormattedText)pComponent) * 0.5f, 0.0f, 5260599, false, pMatrix4f, pBuffer, Font.DisplayMode.POLYGON_OFFSET, 0, pPackedLight);
    }
}

