/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.layer.SnullEmissiveLayer;
import com.axanthic.icaria.client.model.SnullModel;
import com.axanthic.icaria.client.registry.IcariaLayerLocations;
import com.axanthic.icaria.common.entity.SnullEntity;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SnullRenderer
extends MobRenderer<SnullEntity, SnullModel> {
    public SnullRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new SnullModel(pContext.bakeLayer(IcariaLayerLocations.SNULL)), 1.0f);
        this.addLayer(new SnullEmissiveLayer((RenderLayerParent<SnullEntity, SnullModel>)this));
    }

    public float getShadowRadius(SnullEntity pEntity) {
        return pEntity.getScaleForShadow();
    }

    public void scale(SnullEntity pLivingEntity, PoseStack pMatrixStack, float pPartialTickTime) {
        pMatrixStack.scale(pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender(), pLivingEntity.getScaleForRender());
        if (pLivingEntity.onClimbable()) {
            pMatrixStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            pMatrixStack.translate(0.0f, 0.25f, 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(SnullEntity pEntity) {
        return IcariaResourceLocations.SNULL;
    }
}

