/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.client.registry.IcariaRenderTypes;
import com.axanthic.icaria.common.entity.SpellEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpellRenderer
extends EntityRenderer<SpellEntity> {
    public SpellRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    float getX(float pLength, float pTicks, float pSpeed, float pWiggle) {
        return Mth.cos((float)(pLength / 3.5f - pSpeed * pTicks / 2.0f)) * pLength * pWiggle + Mth.cos((float)(pLength / 2.0f - pSpeed * pTicks / 3.5f + 3.0f)) * pLength * pWiggle + Mth.sin((float)(pLength / 7.5f - pSpeed * pTicks / 6.0f + 2.0f)) * pLength * pWiggle + Mth.sin((float)(-pSpeed * pTicks / 5.0f + 2.0f)) * pLength * pWiggle;
    }

    float getY(float pLength, float pTicks, float pSpeed, float pWiggle) {
        return Mth.sin((float)(pLength / 2.5f - pSpeed * pTicks / 3.0f)) * pLength * pWiggle + Mth.sin((float)(pLength / 3.0f - pSpeed * pTicks / 2.5f + 2.0f)) * pLength * pWiggle + Mth.cos((float)(pLength / 7.0f - pSpeed * pTicks / 6.5f + 3.0f)) * pLength * pWiggle + Mth.cos((float)(-pSpeed * pTicks / 4.0f + 3.0f)) * pLength * pWiggle;
    }

    public void render(SpellEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight) {
        pPoseStack.pushPose();
        VertexConsumer consumer = pBufferSource.getBuffer(IcariaRenderTypes.ADDITIVE_TRANSPARENT);
        Matrix4f matrix4f = pPoseStack.last().pose();
        int color = pEntity.getColor();
        float ticks = pPartialTick + (float)pEntity.tickCount;
        float length = 50.0f;
        float speed = 1.5f;
        float width = 0.1f;
        float wiggle = 0.0025f;
        float res0 = 25.0f;
        float r0 = 0.0f;
        float g0 = 0.0f;
        float b0 = 0.0f;
        float a0 = 0.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f / 2.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f / 2.0f;
        float b = (float)(color & 0xFF) / 255.0f / 2.0f;
        pPoseStack.translate(0.0, 0.25, 0.0);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.yRotO, (float)pEntity.getYRot()) + 180.0f));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)pPartialTick, (float)pEntity.xRotO, (float)pEntity.getXRot())));
        for (float i = 0.0f; i < length; i += 1.0f) {
            float res = i / res0;
            float a = (length - i) / length;
            float x = this.getX(i, ticks, speed, wiggle);
            float y = this.getY(i, ticks, speed, wiggle);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x + width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x + width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y - width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y, res).setColor(r, g, b, a);
            consumer.addVertex(matrix4f, x - width, y, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x - width, y + width, res).setColor(r0, g0, b0, a0);
            consumer.addVertex(matrix4f, x, y + width, res).setColor(r0, g0, b0, a0);
        }
        pPoseStack.popPose();
    }

    public ResourceLocation getTextureLocation(SpellEntity pEntity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

