/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.renderer;

import com.axanthic.icaria.common.entity.TroughBlockEntity;
import com.axanthic.icaria.common.properties.Trough;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TroughBlockRenderer
implements BlockEntityRenderer<TroughBlockEntity> {
    public TroughBlockRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(TroughBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState state = pBlockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (state.getValue(IcariaBlockStateProperties.TROUGH) != Trough.NONE) {
            if (facing == Direction.NORTH) {
                this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, pPackedLight, pPackedOverlay);
            } else if (facing == Direction.EAST) {
                this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, pPackedLight, pPackedOverlay);
            } else if (facing == Direction.SOUTH) {
                this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 0.5f, pPackedLight, pPackedOverlay);
            } else if (facing == Direction.WEST) {
                this.renderQuad(pBlockEntity, pPoseStack, pBufferSource, 0.5f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, pPackedLight, pPackedOverlay);
            }
        }
    }

    public void renderQuad(TroughBlockEntity pBlockEntity, PoseStack pPoseStack, MultiBufferSource pBufferSource, float pMinX, float pMaxX, float pMinZ, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int pPackedLight, int pPackedOverlay) {
        if (pBlockEntity.getLevel() != null) {
            TextureAtlasSprite sprite;
            float b;
            float g;
            float r;
            VertexConsumer consumer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            Matrix4f matrix4f = pPoseStack.last().pose();
            Minecraft minecraft = Minecraft.getInstance();
            BlockState state = pBlockEntity.getBlockState();
            int waterColor = BiomeColors.getAverageWaterColor((BlockAndTintGetter)pBlockEntity.getLevel(), (BlockPos)pBlockEntity.getBlockPos());
            float height = (float)((Integer)state.getValue((Property)IcariaBlockStateProperties.TROUGH_FILL)).intValue() * 0.0625f / 3.0f + 0.0625f;
            if (state.getValue(IcariaBlockStateProperties.TROUGH) == Trough.WATER) {
                r = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                g = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                b = (float)(waterColor & 0xFF) / 255.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.WATER);
            } else if (state.getValue(IcariaBlockStateProperties.TROUGH) == Trough.MEDITERRANEAN_WATER) {
                r = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                g = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                b = (float)(waterColor & 0xFF) / 255.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.MEDITERRANEAN_WATER);
            } else if (state.getValue(IcariaBlockStateProperties.TROUGH) == Trough.ONION) {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.ONION);
            } else if (state.getValue(IcariaBlockStateProperties.TROUGH) == Trough.SPELT) {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.SPELT);
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
                sprite = (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IcariaResourceLocations.VINEBERRIES);
            }
            pPoseStack.pushPose();
            consumer.addVertex(matrix4f, pMinX, height, pMinZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(pMinU), sprite.getV(pMinV)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMinX, height, pMaxZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(pMinU), sprite.getV(pMaxV)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMaxX, height, pMaxZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(pMaxU), sprite.getV(pMaxV)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            consumer.addVertex(matrix4f, pMaxX, height, pMinZ).setColor(r, g, b, 1.0f).setUv(sprite.getU(pMaxU), sprite.getV(pMinV)).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(1.0f, 1.0f, 1.0f);
            pPoseStack.popPose();
        }
    }
}

