/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.screen;

import com.axanthic.icaria.common.network.packet.ChestLabelPacket;
import com.axanthic.icaria.common.registry.IcariaDataComponents;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ChestLabelScreen
extends Screen {
    public Button cancelButton;
    public Button doneButton;
    public EditBox box;
    public ItemStack stack;

    public ChestLabelScreen(ItemStack pStack) {
        super(GameNarrator.NO_TITLE);
        this.stack = pStack;
    }

    public void cancel() {
        this.minecraft.setScreen(null);
    }

    public void done() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ChestLabelPacket(this.stack, this.box.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    public void init() {
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, p_98157_ -> this.cancel()).bounds(this.width / 2 + 2, this.height / 2 + 64, 98, 20).build());
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, p_280852_ -> this.done()).bounds(this.width / 2 - 100, this.height / 2 + 64, 98, 20).build());
        this.box = new EditBox(this.font, this.width / 2 - 35, this.height / 2 - 3, 200, 20, (Component)Component.translatable((String)"screen.landsoficaria.chest_label"));
        this.box.setBordered(false);
        this.box.setMaxLength(12);
        this.box.setTextColor(5260599);
        this.box.setTextShadow(false);
        this.box.setValue((String)this.stack.getOrDefault(IcariaDataComponents.LABEL, (Object)""));
        this.addWidget((GuiEventListener)this.box);
    }

    public void render(GuiGraphics pGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGraphics, pMouseX, pMouseY, pPartialTick);
        this.box.render(pGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderBackground(GuiGraphics pGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = (this.width - 216) / 2;
        int y = (this.height - 80) / 2;
        this.renderTransparentBackground(pGraphics);
        pGraphics.blit(IcariaResourceLocations.CHEST_LABEL, x, y, 0, 0, 216, 80);
    }

    public void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.box);
    }
}

