/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.client.screen;

import com.axanthic.icaria.common.menu.KilnMenu;
import com.axanthic.icaria.common.registry.IcariaResourceLocations;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class KilnScreen
extends AbstractContainerScreen<KilnMenu> {
    public KilnScreen(KilnMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageHeight = 176;
        this.imageWidth = 176;
    }

    public void render(GuiGraphics pGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBg(pGraphics, pPartialTick, pMouseX, pMouseY);
        super.render(pGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGraphics, pMouseX, pMouseY);
    }

    public void renderBg(GuiGraphics pGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGraphics.blit(IcariaResourceLocations.KILN, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFuel(pGraphics, x, y);
        this.renderProgress(pGraphics, x, y);
    }

    public void renderLabels(GuiGraphics pGraphics, int pMouseX, int pMouseY) {
        pGraphics.drawString(this.font, this.title, this.getXSize() / 2 - this.font.width((FormattedText)this.title) / 2, 8, 5260599, false);
        pGraphics.drawString(this.font, this.playerInventoryTitle, 7, 80, 5260599, false);
    }

    public void renderFuel(GuiGraphics pGraphics, int pX, int pY) {
        int fuel = ((KilnMenu)this.menu).getFuel();
        int heightFuel = 14;
        int maxFuel = ((KilnMenu)this.menu).getMaxFuel();
        if (maxFuel != 0) {
            int height = fuel * heightFuel / maxFuel;
            pGraphics.blit(IcariaResourceLocations.KILN, pX + 48, pY + 41 + heightFuel - height, this.imageWidth, 16 + heightFuel - height, 9, height);
        }
    }

    public void renderProgress(GuiGraphics pGraphics, int pX, int pY) {
        int maxProgress = ((KilnMenu)this.menu).getMaxProgress();
        int progress = ((KilnMenu)this.menu).getProgress();
        int widthProgress = 22;
        if (maxProgress != 0) {
            int width = widthProgress * progress / maxProgress;
            pGraphics.blit(IcariaResourceLocations.KILN, pX + 73, pY + 40, this.imageWidth, 0, width, 16);
        }
    }
}

