/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CardonCactusBlock
extends PipeBlock {
    public static final MapCodec<CardonCactusBlock> CODEC = Block.simpleCodec(CardonCactusBlock::new);

    public CardonCactusBlock(BlockBehaviour.Properties pProperties) {
        super(0.25f, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState belowState = pLevel.getBlockState(pPos.below());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState relativeState;
            BlockPos relativePos = pPos.relative(direction);
            if (!pLevel.getBlockState(relativePos).is((Block)this) || !(relativeState = pLevel.getBlockState(relativePos.below())).is(BlockTags.SAND) && !relativeState.is((Block)this)) continue;
            return true;
        }
        return belowState.is(BlockTags.SAND) || belowState.is((Block)this);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.UP, BlockStateProperties.DOWN});
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        pEntity.hurt(pLevel.damageSources().cactus(), 1.0f);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos abovePos = pPos.above();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(pRandom);
        if (pLevel.isAreaLoaded(pPos, 1) && pRandom.nextInt(4) == 0) {
            if (!(!pLevel.getBlockState(abovePos).isAir() || pLevel.getBlockState(pPos.below(4)).is((Block)this) || pLevel.getBlockState(pPos.north()).is((Block)this) || pLevel.getBlockState(pPos.east()).is((Block)this) || pLevel.getBlockState(pPos.south()).is((Block)this) || pLevel.getBlockState(pPos.west()).is((Block)this))) {
                pLevel.setBlockAndUpdate(abovePos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.DOWN, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.DOWN))));
            }
            if (pLevel.getBlockState(pPos.relative(direction)).isAir() && pLevel.getBlockState(abovePos.relative(direction)).isAir() && pLevel.getBlockState(pPos.above(2)).is((Block)this) && pLevel.getBlockState(pPos.below()).is((Block)this)) {
                pLevel.setBlockAndUpdate(abovePos.relative(direction), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.DOWN, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.DOWN))));
                pLevel.setBlockAndUpdate(pPos.relative(direction), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.UP, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.UP)))).setValue((Property)BlockStateProperties.DOWN, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.DOWN))));
            }
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        }
    }

    public PathType getBlockPathType(BlockState pState, BlockGetter pLevel, BlockPos pPos, @Nullable Mob pMob) {
        return PathType.DAMAGE_OTHER;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState belowState = pContext.getLevel().getBlockState(pContext.getClickedPos().below());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(belowState.is(BlockTags.SAND) || belowState.is((Block)this)));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        boolean checkU = pLevel.getBlockState(pCurrentPos.above()).is((Block)this);
        boolean checkD = pLevel.getBlockState(pCurrentPos.below()).is(BlockTags.SAND) || pLevel.getBlockState(pCurrentPos.below()).is((Block)this);
        boolean checkN = !pLevel.getBlockState(pCurrentPos.below()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below()).is((Block)this) && pLevel.getBlockState(pCurrentPos.north()).is((Block)this);
        boolean checkBelowN = !pLevel.getBlockState(pCurrentPos.below().north()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below().north()).is((Block)this) && pLevel.getBlockState(pCurrentPos.north()).is((Block)this);
        boolean checkE = !pLevel.getBlockState(pCurrentPos.below()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below()).is((Block)this) && pLevel.getBlockState(pCurrentPos.east()).is((Block)this);
        boolean checkBelowE = !pLevel.getBlockState(pCurrentPos.below().east()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below().east()).is((Block)this) && pLevel.getBlockState(pCurrentPos.east()).is((Block)this);
        boolean checkS = !pLevel.getBlockState(pCurrentPos.below().south()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below().south()).is((Block)this) && pLevel.getBlockState(pCurrentPos.south()).is((Block)this);
        boolean checkBelowS = !pLevel.getBlockState(pCurrentPos.below()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below()).is((Block)this) && pLevel.getBlockState(pCurrentPos.south()).is((Block)this);
        boolean checkW = !pLevel.getBlockState(pCurrentPos.below().west()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below().west()).is((Block)this) && pLevel.getBlockState(pCurrentPos.west()).is((Block)this);
        boolean checkBelowW = !pLevel.getBlockState(pCurrentPos.below()).is(BlockTags.SAND) && !pLevel.getBlockState(pCurrentPos.below()).is((Block)this) && pLevel.getBlockState(pCurrentPos.west()).is((Block)this);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(checkU))).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(checkD))).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(checkN || checkBelowN))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(checkE || checkBelowE))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(checkS || checkBelowS))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(checkW || checkBelowW));
    }

    public MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }
}

