/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.CrystalBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrystalBlock
extends DirectionalBlock
implements EntityBlock,
MediterraneanWaterloggedBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<CrystalBlock> CODEC = Block.simpleCodec(CrystalBlock::new);

    public CrystalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos relativePos = pPos.relative(((Direction)pState.getValue((Property)BlockStateProperties.FACING)).getOpposite());
        return pLevel.getBlockState(relativePos).isSolidRender((BlockGetter)pLevel, relativePos);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.FACING, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new CrystalBlockEntity(pPos, pState, 0.5, 0.5, 1.0);
            case Direction.EAST -> new CrystalBlockEntity(pPos, pState, 0.0, 0.5, 0.5);
            case Direction.SOUTH -> new CrystalBlockEntity(pPos, pState, 0.5, 0.5, 0.0);
            case Direction.WEST -> new CrystalBlockEntity(pPos, pState, 1.0, 0.5, 0.5);
            case Direction.UP -> new CrystalBlockEntity(pPos, pState, 0.5, 0.0, 0.5);
            case Direction.DOWN -> new CrystalBlockEntity(pPos, pState, 0.5, 1.0, 0.5);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Fluid fluid = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)pContext.getClickedFace())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluid == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pDirection == ((Direction)pState.getValue((Property)BlockStateProperties.FACING)).getOpposite() && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState));
    }

    public MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> IcariaShapes.NORTH;
            case Direction.EAST -> IcariaShapes.EAST;
            case Direction.SOUTH -> IcariaShapes.SOUTH;
            case Direction.WEST -> IcariaShapes.WEST;
            case Direction.UP -> IcariaShapes.UP;
            case Direction.DOWN -> IcariaShapes.DOWN;
        };
    }
}

